/*!
 * Esthetic Quote Selected JavaScript Library v.1.1.0
 * by Viodele<viodele@gmail.com>
 * 07.07.2011
 */

/*
 *       
 **/
var eqsDialog = {
    dragger: {x: 10, y: 10},
    paste: {x: 196, y: 10},
    location: {x: 10, y: 10, z: 999990},
    mouse: {down: {post: 0, x: 0, y: 0}},
    enabled: true, message: false, username: false, post_id: false, extended_mode: false, add_signature: true, finalQuote: false,
    init: function (allow) {
        if (allow !== true) {
            return;
        }
        var dialog = '<div id="eqsDialog" style="left:' + this.location.x + 'px;top:' + this.location.y + 'px;z-index:' + this.location.z + ';"><div id="eqsDialogBody"><div id="eqsQuoteTitle"><b>{$eqs_dialog_title}</b></div><div id="eqsQuoteMode" class="sign"></div><div id="eqsQuoteContent"></div></div></div>';
        var dragger = '<div id="eqsDialogDragger" style="left:' + (this.location.x + this.dragger.x) + 'px;top:' + (this.location.y + this.dragger.y) + 'px;z-index:' + (this.location.z + 1) + ';"></div>';
        var paste = '<div id="eqsDialogPaste" style="left:' + (this.location.x + this.paste.x)+ 'px;top:' + (this.location.y + this.paste.y) + 'px;z-index:' + (this.location.z + 1) + ';"></div>';
        
        dialog = this.render(dialog);
        
        if($('body')) {
            $('body').append(dialog + dragger + paste);
            window.dragMaster.makeDraggable(document.getElementById('eqsDialogDragger'));
            $('#eqsQuoteMode').live('click', function () {
                window.eqsDialog.changeMode ();
            });
            $('#eqsDialogPaste').live('click', function () {
                window.eqsDialog.insert ();
            });
        }
        this.reset();
        return;
    },
    render: function (body) {
        if (typeof(body) != 'string' || body == '') {
            return body;
        }
        var phrases = body.match(/\{\$([a-zA-Z0-9\_]+)\}/g);
        if (typeof (phrases) != 'array' && typeof (phrases) != 'object') {
            return body;
        }
        for (i in phrases) {
            var phrase = phrases[i].replace(/^\{\$/, '');
            phrase = phrase.replace(/\}$/, '');
            body = body.replace(phrases[i], window.eqsGetPhrase(phrase));
        }
        return body;
    },
    reset: function () {
        this.mouse.down.post = 0;
        this.mouse.down.x = 0;
        this.mouse.down.y = 0;
        this.message = false;
        this.username = false;
        this.post_id = false;
        this.finalQuote = false;
        this.fadeOut();
        return;
    },
    fadeOut: function () {
        $('#eqsDialog, #eqsDialogDragger, #eqsDialogPaste').animate({
            opacity: 0
        }, 250, function () {
            $('#eqsDialog, #eqsDialogDragger, #eqsDialogPaste').css('display', 'none');
        });
        return;
    },
    fadeIn: function () {
        $('#eqsDialog, #eqsDialogDragger, #eqsDialogPaste').css('display', 'block');
        $('#eqsDialog, #eqsDialogDragger, #eqsDialogPaste').animate({
            opacity: 1
        }, 250);
        return;
    },
    moveTo: function (x, y) {
        $('#eqsDialog').animate({
            left: x,
            top: y
        }, 500);
        $('#eqsDialogDragger').animate({
            left: x + window.eqsDialog.dragger.x,
            top: y + window.eqsDialog.dragger.y
        }, 500);
        $('#eqsDialogPaste').animate({
            left: x + window.eqsDialog.paste.x,
            top: y + window.eqsDialog.paste.y
        }, 500);
        return;
    },
    changeMode: function () {
        if (this.add_signature === true) {
            $('#eqsQuoteMode').html(window.eqsGetPhrase('eqs_no_sign'));
            $('#eqsQuoteMode').removeClass('sign');
            $('#eqsQuoteMode').addClass('nosign');
            this.add_signature = false;
        } else {
            $('#eqsQuoteMode').html(window.eqsGetPhrase('eqs_add_sign'));
            $('#eqsQuoteMode').removeClass('nosign');
            $('#eqsQuoteMode').addClass('sign');
            this.add_signature = true;
        }
        this.insertQuoteToDialog();
        return;
    },
    insertQuoteToDialog: function () {
        var embed = '';
        if (this.add_signature !== false && 
            this.extended_mode !== false &&
            typeof(this.username) == 'string' && this.username != false &&
            this.post_id != false
        ) {
            embed = '[quote="' + this.username + ', post:' + this.post_id + '"]';
        } else {
            embed = '[quote]';
        }
        embed += this.message + '[/quote]';
        this.finalQuote = embed;
        $('#eqsQuoteContent').html('<p>' + embed + '</p>');
        return;
    },
    build: function () {
        if (this.message == false || this.message == '') {
            return false;
        }
        if (this.add_signature !== false && this.extended_mode !== false) {
            $('#eqsQuoteMode').html(window.eqsGetPhrase('eqs_add_sign'));
        } else {
            $('#eqsQuoteMode').html(window.eqsGetPhrase('eqs_no_sign'));
            this.add_signature = false;
        }
        
        this.insertQuoteToDialog();
        return true;
    },
    insert: function () {
        
        var ret = $(window).scrollTop();
        if (this.finalQuote == false) {
            return;
        }
        
        window.eqsInsertQuote(this.finalQuote);
        $(window).scrollTop(ret);
        
        var id = 'node' + parseInt(Math.random() * 100000000, 10);
        var div = '<div id="' + id + '" class="eqsConfirmIcon"></div>';
        $('body').append(div);
        $('#' + id).css({
            'display': 'block',
            'top': parseInt($(window).scrollTop()),
            'left': parseInt($(window).scrollLeft() + $(window).width(), 10) - 80
        });
        
        if (this.post_id != false) {
            var postObj = $('.eqspcont-' + this.post_id);
            if (postObj) {
                postObj = postObj.offset();
                if (postObj.top > $(window).scrollTop() && postObj.top < ($(window).scrollTop() + $(window).height())) {

                    $('#' + id).css({
                        'top': parseInt(postObj.top, 10)
                    });

                }
            }
        }
        
        $('#' + id).animate({opacity:0},0).animate({opacity:1},500).animate({opacity:1},1000).animate({opacity:0},250,function (e) {
            $(this).remove();
            return;
        });
        
        this.fadeOut();
        this.reset();
        
        return;
    }
    
}

/*
 *      
 * @param  String  quote
 * @return Boolean
 **/
function eqsInsertQuote (quote) {
    var quoteHtml = "<p>" + quote + "</p>\n<p><br /></p>";
    
    var $form = $("#QuickReply");
    var ed = XenForo.getEditorInForm($form);        
    
    if (window.tinyMCE) {
        window.tinyMCE.editors["ctrl_message_html"].focus();
    } else {
        $("#QuickReply").find("textarea:first").get(0).focus();
    }

    if (!ed) {
        return;
    }

    if (ed.execCommand) {
        if (window.tinyMCE.isIE) {
            ed.execCommand("mceInsertContent", false, quoteHtml);
        } else {
            ed.execCommand("insertHtml", false, quoteHtml);
        }

        if (window.sessionStorage) {
            window.sessionStorage.quickReplyText = quoteHtml;
        }

        if (window.tinyMCE.isWebKit) {
            ed.selection.select(ed.dom.select("body")[0].lastChild);
            ed.selection.collapse(false);
        }
    } else {
        ed.val(ed.val() + quote);
        if (window.sessionStorage) {
            window.sessionStorage.quickReplyText = quote;
        }
    }
    
    return;
}

/*
 *       
 * @param  String  block_classes
 * @return Integer
 **/
function extractPostId (block_classes) {
    if (block_classes == '' || typeof (block_classes) != 'string') {
        return 0;
    }
    var matches = /eqspcont\-([0-9]+)/.exec(block_classes);
    if (!matches) {
        return 0;
    }
    return parseInt (matches[1], 10);
}

/*
 *    
 * @return String
 **/
function eqsGetSelectedText () {
    var txt = '';
    if (window.getSelection) {
        txt = window.getSelection();
    } else if (document.getSelection) {
        txt = document.getSelection();
    } else if (document.selection) {
        txt = document.selection.createRange().text;
    }
    return txt.toString();
}

/*
 *   ,   
 * @param  String  phrase_id
 * @return String
 **/
function eqsGetPhrase (phrase_id) {
    if (window.eqsForumPhrases == 'undefined' || window.eqsForumPhrases == null) {
        return phrase_id
    }
    if (typeof (window.eqsForumPhrases[phrase_id]) == 'string') {
        return window.eqsForumPhrases[phrase_id];
    }
    return phrase_id;
}

/*
 ****************************************************************************************************
 *
 * ,   DOM     
 *
 ****************************************************************************************************
 */

/*
 *     
 * @param   Integer  x
 * @param   Integer  y
 * @return  Boolean
 **/
function draggerCallBack (x, y) {
    var dialog = document.getElementById('eqsDialog');
    with (dialog.style) {
        position = 'absolute';
        top = (y - eqsDialog.dragger.y) + 'px';
        left = (x - eqsDialog.dragger.x) + 'px';
    }
    paste = document.getElementById('eqsDialogPaste');
    with (paste.style) {
        position = 'absolute';
        top = (y - eqsDialog.dragger.y + eqsDialog.paste.y) + 'px';
        left = (x - eqsDialog.dragger.x + eqsDialog.paste.x) + 'px';
    }
    return;
}

/*
 *   Drag
 **/
var dragMaster = (function() {

	var dragObject;
	var mouseOffset;

	function getMouseOffset(target, e) {
		var docPos	= draggerGetPosition(target);
		return {x:e.pageX - docPos.x, y:e.pageY - docPos.y};
	}

	function mouseUp(){
		dragObject = null;
		document.onmousemove = null;
		document.onmouseup = null;
		document.ondragstart = null;
		document.body.onselectstart = null;
	}

	function mouseMove(e){
		e = draggerFixEvent(e);
		with(dragObject.style) {
			position = 'absolute';
			top = e.pageY - mouseOffset.y + 'px';
			left = e.pageX - mouseOffset.x + 'px';
		}
        window.draggerCallBack (e.pageX - mouseOffset.x, e.pageY - mouseOffset.y);
		return false;
	}

	function mouseDown(e) {
		e = draggerFixEvent(e);
		if (e.which!=1) return;
		dragObject  = this;
		mouseOffset = getMouseOffset(this, e);
		document.onmousemove = mouseMove;
		document.onmouseup = mouseUp;
		document.ondragstart = function() { return false };
		document.body.onselectstart = function() { return false };

		return false;
	}

	return {
		makeDraggable: function(element){
			element.onmousedown = mouseDown;
		}
	};

}())

/*
 *   
 * @param   Object      e        DOM
 * @return  Object
 **/
function draggerGetPosition(e){
	var left = 0;
	var top  = 0;

	while (e.offsetParent){
		left += e.offsetLeft;
		top += e.offsetTop;
		e = e.offsetParent;
	}

	left += e.offsetLeft;
	top  += e.offsetTop;

	return {x:left, y:top};
}

/*
 *   
 * @return  Object
 **/
function draggerFixEvent(e) {
	e = e || window.event;
	if ( e.pageX == null && e.clientX != null ) {
		var html = document.documentElement;
		var body = document.body;
		e.pageX = e.clientX + (html && html.scrollLeft || body && body.scrollLeft || 0) - (html.clientLeft || 0);
		e.pageY = e.clientY + (html && html.scrollTop || body && body.scrollTop || 0) - (html.clientTop || 0);
	}

	if (!e.which && e.button) {
		e.which = e.button & 1 ? 1 : ( e.button & 2 ? 3 : ( e.button & 4 ? 2 : 0 ) );
	}

	return e;
}

/*
 ****************************************************************************************************
 *
 *     
 *
 ****************************************************************************************************
 */
function eqsRun () {

    if (window.tinyMCE.isIE) {
        return;
    }

    window.eqsDialog.init(true);

    $('blockquote.eqsPostContent').live('mousedown', function (e) {
        if (eqsDialog.enabled === false) {
            return;
        }
        var post_id = window.extractPostId($(this).attr('class'));
        if (post_id == 0) {
            eqsDialog.reset();
            return;
        }
        eqsDialog.mouse.down.post = post_id;
        eqsDialog.mouse.down.x = e.pageX;
        eqsDialog.mouse.down.y = e.pageY;
    });
    
    $('blockquote.eqsPostContent').live('focus mouseup', function (e) {
        if (eqsDialog.enabled === false) {
            return;
        }
        var msg = window.eqsGetSelectedText();
        var post_id = window.extractPostId($(this).attr('class'));
        
        eqsDialog.extended_mode = false;
        
        if (post_id == 0 || post_id != eqsDialog.mouse.down.post) {
            eqsDialog.reset();
            document.body.onselectstart = null;
            return;
        }
        if (typeof (msg) != 'string' || msg == '') {
            eqsDialog.reset();
            document.body.onselectstart = null;
            return;
        }
        
        if (typeof(window.eqsForumData[post_id]) == 'string') {
            eqsDialog.extended_mode = true;
            eqsDialog.post_id = post_id;
            eqsDialog.username = window.eqsForumData[post_id];
        }
        
        eqsDialog.message = msg;
        
        if(!eqsDialog.build()) {
            eqsDialog.reset();
            return;
        }

        var obj = $(this).offset();
        var x = e.pageX;
        var y = e.pageY + 5;
        
        if (x > ($(this).width() / 2) + obj.left) {
            x = x - $('#eqsDialog').width();
        }
        
        eqsDialog.moveTo(x, y);
        eqsDialog.fadeIn();
        
        return;
    });
    
    return;
}