<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (media_ajax.php)                             # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ##########################

error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS ######################

define('THIS_SCRIPT', '8WR_media_ajax');
define('CSRF_PROTECTION', true);
define('LOCATION_BYPASS', 1);
define('NOPMPOPUP', 1);

// #################### PRE-CACHE TEMPLATES AND DATA #####################

$phrasegroups = array(
	'8WR_media',
);
$globaltemplates = array();
$specialtemplates = array(
	'smiliecache',
	'bbcodecache',
);
$actiontemplates = array();

// ########################## REQUIRE BACK-END ###########################

require_once('./global.php');
require_once(DIR.'/includes/class_xml.php');
require_once(DIR.'/media/media_functions_builds.php');
require_once(DIR.'/media/media_functions_constructs.php');
require_once(DIR.'/media/media_functions_hrefs.php');
require_once(DIR.'/media/media_functions_perms.php');

// #######################################################################
// ######################### START MAIN SCRIPT ###########################
// #######################################################################

$perms = media_permissions();

if (!$perms['view'])
{
	print_no_permission();
}

$vbulletin->input->clean_array_gpc('r', array(
	'do'			=> TYPE_STR,
	'sid'			=> TYPE_UINT,
	'mid'			=> TYPE_UINT,
	'cmt'			=> TYPE_UINT,
	'pid'			=> TYPE_UINT,
	'cid'			=> TYPE_UINT,
	'uid'			=> TYPE_UINT,
	'tid'			=> TYPE_STR,
	'sort'			=> TYPE_STR,
	'perpage'		=> TYPE_UINT,
	'pagenumber'	=> TYPE_UINT,
));

$do = $vbulletin->GPC['do'];
$sid = $vbulletin->GPC['sid'];
$mid = $vbulletin->GPC['mid'];
$cmt = $vbulletin->GPC['cmt'];
$pid = $vbulletin->GPC['pid'];
$cid = $vbulletin->GPC['cid'];
$uid = $vbulletin->GPC['uid'];
$tid = $vbulletin->GPC['tid'];
$tid = addslashes(strtolower(trim($tid)));
$sort = $vbulletin->GPC['sort'];

$ajax = true;

switch ($do)
{
	case "details_faves":
	case "details_subs":
	case "details_pagenav":
	case "details_comments":
		require_once(DIR.'/media/media_details.php');		break;
	case "comment":
		require_once(DIR.'/media/media_comment.php');		break;
	case "rating":
		require_once(DIR.'/media/media_rating.php');		break;
	case "faves_add":
	case "faves_rem":
		require_once(DIR.'/media/media_favorites.php');		break;
	case "subs_add":
	case "subs_rem":
		require_once(DIR.'/media/media_subscriptions.php');	break;
	case "submit_feed":
		require_once(DIR.'/media/media_submit.php');		break;
}

?>