<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (media/media_subscriptions.php)              # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

if (!$perms['comment'])
{
	print_no_permission();
}

if ($do == "subscriptions")
{
	$medias = $vbulletin->db->query_read("
		SELECT media.*, media_category.*
		FROM " . TABLE_PREFIX . "media AS media
		LEFT JOIN " . TABLE_PREFIX . "media_category AS media_category ON(media_category.categoryID = media.categoryID)
		WHERE FIND_IN_SET('".$vbulletin->userinfo['userid']."', media.subscriptions)
		ORDER BY media.title ASC
	");

	while ($media = $vbulletin->db->fetch_array($medias))
	{
		$order++;
		$mediabits .= construct_media_bit($media,"subs");
	}

	if ($perms['submit'])
	{
		$submitsmall = construct_submit_small();
	}

	$sidebar = construct_sidebar();

	$title = $vbphrase['media_subscriptions'];
	$description = $vbphrase['media_subs_info'];

	$navbits[''] = $vbphrase['media_subscriptions'];

	$templater = vB_Template::create('8WR_media_browse_subs');
		$templater->register('title', $title);
		$templater->register('description', $description);
		$templater->register('mediabits', $mediabits);
		$templater->register('submitsmall', $submitsmall);
		$templater->register('sidebar', $sidebar);
	$mediaHTML = $templater->render();
}

if ($do == "subs_save")
{
	$vbulletin->input->clean_array_gpc('p', array(
		'delete'	=> TYPE_ARRAY_UINT,
	));

	if ($delete = implode(",", $vbulletin->GPC['delete']))
	{
		$medias = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "media WHERE mediaID IN (".$delete.")");
	}

	while ($media = $vbulletin->db->fetch_array($medias))
	{
		build_subs_cache($media['mediaID'], $media['subscriptions'], 0, $vbulletin->userinfo['userid']);
	}

	$vbulletin->url = construct_href_subscriptions();
	eval(print_standard_redirect('media_subs_removed'));
}

if ($do == "subs_delete")
{
	$media = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media WHERE mediaID = '".$mid."'");

	build_subs_cache($media['mediaID'], $media['subscriptions'], 0, $vbulletin->userinfo['userid']);

	$vbulletin->url = construct_href_subscriptions();
	eval(print_standard_redirect('media_subs_removed'));
}

if ($do == "subs_add")
{
	$media = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media WHERE mediaID = '".$mid."'");
	$playlist = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media_playlist WHERE playlistID = '".$pid."'");

	build_subs_cache($media['mediaID'], $media['subscriptions'], $vbulletin->userinfo['userid'], 0);

	if ($ajax)
	{
		$mediasubs = construct_media_subs($media, $playlist);

		$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
		$xml->add_group('response');
		$xml->add_tag('success', $vbphrase['media_subs_added']);
		$xml->add_tag('mediasubs', $mediasubs);
		$xml->close_group();
		$xml->print_xml(true);
	}

	$vbulletin->url = construct_href_details($media, $playlist);
	eval(print_standard_redirect('media_subs_added'));
}

if ($do == "subs_rem")
{
	$media = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media WHERE mediaID = '".$mid."'");
	$playlist = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media_playlist WHERE playlistID = '".$pid."'");

	build_subs_cache($media['mediaID'], $media['subscriptions'], 0, $vbulletin->userinfo['userid']);

	if ($ajax)
	{
		$mediasubs = construct_media_subs($media, $playlist);

		$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
		$xml->add_group('response');
		$xml->add_tag('success', $vbphrase['media_subs_removed']);
		$xml->add_tag('mediasubs', $mediasubs);
		$xml->close_group();
		$xml->print_xml(true);
	}

	$vbulletin->url = construct_href_details($media, $playlist);
	eval(print_standard_redirect('media_subs_removed'));
}

?>