<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (media/media_search.php)                     # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

if ($do == "search")
{
	$title = $vbphrase['media_search'];

	$navbits[''] =  $vbphrase['media_search'];

	$templater = vB_Template::create('8WR_media_search');
		$templater->register('title', $title);
	$mediaHTML = $templater->render();
}

if ($do == "results")
{
	$vbulletin->input->clean_array_gpc('r', array(
		'query'	=> TYPE_STR,
	));

	$keywords = preg_replace('/[^\w\s-]+/', '', $vbulletin->GPC['query']);

	if (vbstrlen($keywords) < 3)
	{
		eval(standard_error(fetch_error('media_search_string_too_short')));
	}

	$keys = explode(" ",$keywords);
	foreach ($keys as $key => $keyword)
	{
		$match .= " OR media.title LIKE '%".$keyword."%' OR media.description LIKE '%".$keyword."%'";
		if ($vbulletin->options['media_custom1_name']) { $match .= " OR media.custom1 LIKE '%".$keyword."%'"; }
		if ($vbulletin->options['media_custom2_name']) { $match .= " OR media.custom2 LIKE '%".$keyword."%'"; }
		if ($vbulletin->options['media_custom3_name']) { $match .= " OR media.custom3 LIKE '%".$keyword."%'"; }
		if ($vbulletin->options['media_custom4_name']) { $match .= " OR media.custom4 LIKE '%".$keyword."%'"; }
		if ($vbulletin->options['media_custom5_name']) { $match .= " OR media.custom5 LIKE '%".$keyword."%'"; }
		if ($vbulletin->options['media_custom6_name']) { $match .= " OR media.custom6 LIKE '%".$keyword."%'"; }
		if ($vbulletin->options['media_custom7_name']) { $match .= " OR media.custom7 LIKE '%".$keyword."%'"; }
		if ($vbulletin->options['media_custom8_name']) { $match .= " OR media.custom8 LIKE '%".$keyword."%'"; }
		if ($vbulletin->options['media_custom9_name']) { $match .= " OR media.custom9 LIKE '%".$keyword."%'"; }
	}

	$match = substr($match, 4);

	$results = $vbulletin->db->query_first("
		SELECT COUNT(mediaID) AS count
		FROM " . TABLE_PREFIX . "media AS media
		WHERE ".$match."
	");

	sanitize_pageresults($results['count'], $pagenumber, $perpage, 30, $vbulletin->options['media_limit_medias']);

	if ($vbulletin->GPC['pagenumber'] < 1)
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}
	else if ($vbulletin->GPC['pagenumber'] > ceil(($results['count'] + 1) / $perpage))
	{
		$vbulletin->GPC['pagenumber'] = ceil(($results['count'] + 1) / $perpage);
	}

	$pagenav = construct_page_nav($vbulletin->GPC['pagenumber'], $perpage, $results['count'], construct_href_results($keywords, $sort)); 

	$limitlower = ($vbulletin->GPC['pagenumber'] - 1) * $perpage;
	$limitupper = ($vbulletin->GPC['pagenumber']) * $perpage;

	$medias = $vbulletin->db->query_read("
		SELECT media.*, media_service.*, media_category.*, IF(NOT ISNULL(user.userid), user.username, media.username) AS username
		FROM " . TABLE_PREFIX . "media AS media
		LEFT JOIN " . TABLE_PREFIX . "media_service AS media_service ON(media_service.serviceID = media.serviceID)
		LEFT JOIN " . TABLE_PREFIX . "media_category AS media_category ON(media_category.categoryID = media.categoryID)
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = media.userID)
		WHERE ".$match."
		ORDER BY ".$sortQuery." media.dateline DESC
		LIMIT $limitlower, $perpage
	");

	while ($media = $vbulletin->db->fetch_array($medias))
	{
		$mediabits .= construct_media_bit($media, $vbulletin->options['media_select_bit']);
	}

	if ($perms['submit'])
	{
		$submitsmall = construct_submit_small();
	}

	$sidebar = construct_sidebar();

	$href['sort'] = $sort;
	$href['dateline'] = construct_href_results($keywords, 'dateline');
	$href['rating'] = construct_href_results($keywords, 'rating');
	$href['favorites'] = construct_href_results($keywords, 'favorites');
	$href['comments'] = construct_href_results($keywords, 'comments');
	$href['views'] = construct_href_results($keywords, 'views');

	$title = $vbphrase['media_search_results'] . ": " .  $keywords;
	$description = construct_phrase($vbphrase['media_search_info'],  $keywords);

	$navbits[''] = $vbphrase['media_search_results'] . ": " .  $keywords;

	$templater = vB_Template::create('8WR_media_browse');
		$templater->register('title', $title);
		$templater->register('description', $description);
		$templater->register('mediabits', $mediabits);
		$templater->register('href', $href);
		$templater->register('pagenav', $pagenav);
		$templater->register('pagenumber', $pagenumber);
		$templater->register('perpage', $perpage);
		$templater->register('submitsmall', $submitsmall);
		$templater->register('sidebar', $sidebar);
	$mediaHTML = $templater->render();
}

if ($do == "advresults")
{
	$vbulletin->input->clean_array_gpc('r', array(
		'title'			=> TYPE_STR,
		'description'	=> TYPE_STR,
		'custom1'		=> TYPE_STR,
		'custom2'		=> TYPE_STR,
		'custom3'		=> TYPE_STR,
		'custom4'		=> TYPE_STR,
		'custom5'		=> TYPE_STR,
		'custom6'		=> TYPE_STR,
		'custom7'		=> TYPE_STR,
		'custom8'		=> TYPE_STR,
		'custom9'		=> TYPE_STR,
	));

	$title = preg_replace('/[^\w\s-]+/', '', $vbulletin->GPC['title']);
	$description = preg_replace('/[^\w\s-]+/', '', $vbulletin->GPC['description']);
	$custom1 = preg_replace('/[^\w\s-]+/', '', $vbulletin->GPC['custom1']);
	$custom2 = preg_replace('/[^\w\s-]+/', '', $vbulletin->GPC['custom2']);
	$custom3 = preg_replace('/[^\w\s-]+/', '', $vbulletin->GPC['custom3']);
	$custom4 = preg_replace('/[^\w\s-]+/', '', $vbulletin->GPC['custom4']);
	$custom5 = preg_replace('/[^\w\s-]+/', '', $vbulletin->GPC['custom5']);
	$custom6 = preg_replace('/[^\w\s-]+/', '', $vbulletin->GPC['custom6']);
	$custom7 = preg_replace('/[^\w\s-]+/', '', $vbulletin->GPC['custom7']);
	$custom8 = preg_replace('/[^\w\s-]+/', '', $vbulletin->GPC['custom8']);
	$custom9 = preg_replace('/[^\w\s-]+/', '', $vbulletin->GPC['custom9']);

	if ($title)
	{
		$keys = explode(" ",$title);
		foreach ($keys as $key => $keyword)
		{
			$match .= " AND media.title LIKE '%".$keyword."%'";
		}
	}

	if ($description)
	{
		$keys = explode(" ",$description);
		foreach ($keys as $key => $keyword)
		{
			$match .= " AND media.description LIKE '%".$keyword."%'";
		}
	}

	if ($custom1)
	{
		$keys = explode(" ",$custom1);
		foreach ($keys as $key => $keyword)
		{
			$match .= " AND media.custom1 LIKE '%".$keyword."%'";
		}
	}

	if ($custom2)
	{
		$keys = explode(" ",$custom2);
		foreach ($keys as $key => $keyword)
		{
			$match .= " AND media.custom2 LIKE '%".$keyword."%'";
		}
	}

	if ($custom3)
	{
		$keys = explode(" ",$custom3);
		foreach ($keys as $key => $keyword)
		{
			$match .= " AND media.custom3 LIKE '%".$keyword."%'";
		}
	}

	if ($custom4)
	{
		$keys = explode(" ",$custom4);
		foreach ($keys as $key => $keyword)
		{
			$match .= " AND media.custom4 LIKE '%".$keyword."%'";
		}
	}

	if ($custom5)
	{
		$keys = explode(" ",$custom5);
		foreach ($keys as $key => $keyword)
		{
			$match .= " AND media.custom5 LIKE '%".$keyword."%'";
		}
	}

	if ($custom6)
	{
		$keys = explode(" ",$custom6);
		foreach ($keys as $key => $keyword)
		{
			$match .= " AND media.custom6 LIKE '%".$keyword."%'";
		}
	}

	if ($custom7)
	{
		$keys = explode(" ",$custom7);
		foreach ($keys as $key => $keyword)
		{
			$match .= " AND media.custom7 LIKE '%".$keyword."%'";
		}
	}

	if ($custom8)
	{
		$keys = explode(" ",$custom8);
		foreach ($keys as $key => $keyword)
		{
			$match .= " AND media.custom8 LIKE '%".$keyword."%'";
		}
	}

	if ($custom9)
	{
		$keys = explode(" ",$custom9);
		foreach ($keys as $key => $keyword)
		{
			$match .= " AND media.custom9 LIKE '%".$keyword."%'";
		}
	}

	$match = substr($match, 5);

	if (!$match)
	{
		eval(standard_error(fetch_error('media_search_string_too_short')));
	}

	$results = $vbulletin->db->query_first("
		SELECT COUNT(mediaID) AS count
		FROM " . TABLE_PREFIX . "media AS media
		WHERE ".$match."
	");

	sanitize_pageresults($results['count'], $pagenumber, $perpage, 30, $vbulletin->options['media_limit_medias']);

	if ($vbulletin->GPC['pagenumber'] < 1)
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}
	else if ($vbulletin->GPC['pagenumber'] > ceil(($results['count'] + 1) / $perpage))
	{
		$vbulletin->GPC['pagenumber'] = ceil(($results['count'] + 1) / $perpage);
	}

	$pagenav = construct_page_nav($vbulletin->GPC['pagenumber'], $perpage, $results['count'], construct_href_advresults($title, $description, $custom1, $custom2, $custom3, $custom4, $custom5, $custom6, $custom7, $custom8, $custom9, $sort)); 

	$limitlower = ($vbulletin->GPC['pagenumber'] - 1) * $perpage;
	$limitupper = ($vbulletin->GPC['pagenumber']) * $perpage;

	$medias = $vbulletin->db->query_read("
		SELECT media.*, media_service.*, media_category.*, IF(NOT ISNULL(user.userid), user.username, media.username) AS username
		FROM " . TABLE_PREFIX . "media AS media
		LEFT JOIN " . TABLE_PREFIX . "media_service AS media_service ON(media_service.serviceID = media.serviceID)
		LEFT JOIN " . TABLE_PREFIX . "media_category AS media_category ON(media_category.categoryID = media.categoryID)
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = media.userID)
		WHERE ".$match."
		ORDER BY ".$sortQuery." media.dateline DESC
		LIMIT $limitlower, $perpage
	");

	while ($media = $vbulletin->db->fetch_array($medias))
	{
		$mediabits .= construct_media_bit($media, $vbulletin->options['media_select_bit']);
	}

	if ($perms['submit'])
	{
		$submitsmall = construct_submit_small();
	}

	$sidebar = construct_sidebar();

	$href['sort'] = $sort;
	$href['dateline'] = construct_href_advresults($title, $description, $custom1, $custom2, $custom3, $custom4, $custom5, $custom6, $custom7, $custom8, $custom9, 'dateline');
	$href['rating'] = construct_href_advresults($title, $description, $custom1, $custom2, $custom3, $custom4, $custom5, $custom6, $custom7, $custom8, $custom9, 'rating');
	$href['favorites'] = construct_href_advresults($title, $description, $custom1, $custom2, $custom3, $custom4, $custom5, $custom6, $custom7, $custom8, $custom9, 'favorites');
	$href['comments'] = construct_href_advresults($title, $description, $custom1, $custom2, $custom3, $custom4, $custom5, $custom6, $custom7, $custom8, $custom9, 'comments');
	$href['views'] = construct_href_advresults($title, $description, $custom1, $custom2, $custom3, $custom4, $custom5, $custom6, $custom7, $custom8, $custom9, 'views');

	$keywords = str_replace('media.', '', $match);
	$keywords = str_replace('%', '', $keywords);

	$title = $vbphrase['media_search_results'] . ": " .  $keywords;
	$description = construct_phrase($vbphrase['media_search_info'],  $keywords);

	$navbits[''] = $vbphrase['media_search_results'] . ": " .  $keywords;

	$templater = vB_Template::create('8WR_media_browse');
		$templater->register('title', $title);
		$templater->register('description', $description);
		$templater->register('mediabits', $mediabits);
		$templater->register('href', $href);
		$templater->register('pagenav', $pagenav);
		$templater->register('pagenumber', $pagenumber);
		$templater->register('perpage', $perpage);
		$templater->register('submitsmall', $submitsmall);
		$templater->register('sidebar', $sidebar);
	$mediaHTML = $templater->render();
}

if ($do == "letter")
{
	$vbulletin->input->clean_array_gpc('r', array(
		'query'	=> TYPE_STR,
	));

	$keywords = preg_replace('/[^\w\s-]+/', '', $vbulletin->GPC['query']);

	$results = $vbulletin->db->query_first("
		SELECT COUNT(mediaID) AS count
		FROM " . TABLE_PREFIX . "media
		WHERE title LIKE '".$keywords."%'
	");

	sanitize_pageresults($results['count'], $pagenumber, $perpage, 30, $vbulletin->options['media_limit_medias']);

	if ($vbulletin->GPC['pagenumber'] < 1)
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}
	else if ($vbulletin->GPC['pagenumber'] > ceil(($results['count'] + 1) / $perpage))
	{
		$vbulletin->GPC['pagenumber'] = ceil(($results['count'] + 1) / $perpage);
	}

	$pagenav = construct_page_nav($vbulletin->GPC['pagenumber'], $perpage, $results['count'], construct_href_letter($keywords, $sort)); 

	$limitlower = ($vbulletin->GPC['pagenumber'] - 1) * $perpage;
	$limitupper = ($vbulletin->GPC['pagenumber']) * $perpage;

	$medias = $vbulletin->db->query_read("
		SELECT media.*, media_service.*, media_category.*, IF(NOT ISNULL(user.userid), user.username, media.username) AS username
		FROM " . TABLE_PREFIX . "media AS media
		LEFT JOIN " . TABLE_PREFIX . "media_service AS media_service ON(media_service.serviceID = media.serviceID)
		LEFT JOIN " . TABLE_PREFIX . "media_category AS media_category ON(media_category.categoryID = media.categoryID)
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = media.userID)
		WHERE title LIKE '".$keywords."%'
		ORDER BY ".$sortQuery." media.dateline DESC
		LIMIT $limitlower, $perpage
	");

	while ($media = $vbulletin->db->fetch_array($medias))
	{
		$mediabits .= construct_media_bit($media, $vbulletin->options['media_select_bit']);
	}

	if ($perms['submit'])
	{
		$submitsmall = construct_submit_small();
	}

	$sidebar = construct_sidebar();

	$href['sort'] = $sort;
	$href['dateline'] = construct_href_letter($keywords, 'dateline');
	$href['rating'] = construct_href_letter($keywords, 'rating');
	$href['favorites'] = construct_href_letter($keywords, 'favorites');
	$href['comments'] = construct_href_letter($keywords, 'comments');
	$href['views'] = construct_href_letter($keywords, 'views');

	$title = $vbphrase['media_search_results'] . ": " .  $keywords;
	$description = construct_phrase($vbphrase['media_search_info'],  $keywords);

	$navbits[''] = $vbphrase['media_search_results'] . ": " .  $keywords;

	$templater = vB_Template::create('8WR_media_browse');
		$templater->register('title', $title);
		$templater->register('description', $description);
		$templater->register('mediabits', $mediabits);
		$templater->register('href', $href);
		$templater->register('pagenav', $pagenav);
		$templater->register('pagenumber', $pagenumber);
		$templater->register('perpage', $perpage);
		$templater->register('submitsmall', $submitsmall);
		$templater->register('sidebar', $sidebar);
	$mediaHTML = $templater->render();
}

?>