<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (media/media_rss.php)                        # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

if ($do == "rss")
{
	require_once(DIR . '/includes/class_xml.php');

	if ($cid)
	{
		$category = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media_category WHERE categoryID = '" . $cid . "'");
		$more_sql = "WHERE media.categoryID = '" . $cid . "'";
		$more_inf = " - " . $category['catName'];
	}
	if ($uid)
	{
		$user = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "user WHERE userid = '".$uid."'");
		$more_sql = "WHERE media.userID = '" . $uid . "'";
		$more_inf = " - " . $user['username'];
	}
	if ($tid)
	{
		$tag = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media_tag WHERE tagText = '".$tid."'");
		$more_sql = "WHERE media.tagcache LIKE '%" . $tid . "%'";
		$more_inf = " - " . $tag['tagText'];
	}

	header('Content-Type: text/xml');
	$output = '<?xml version="1.0" encoding="UTF-8"?>' . "\r\n";

	$xml = new vB_XML_Builder($vbulletin);
	$rsstag = array( 'version' => '2.0', 'xmlns:dc' => 'http://purl.org/dc/elements/1.1/', 'xmlns:content' => 'http://purl.org/rss/1.0/modules/content/');

	$xml->add_group('rss', $rsstag);
		$xml->add_group('channel');
			$xml->add_tag('title', $vbulletin->options['bbtitle'] . " - " . $vbphrase['media_library'] . $more_inf);
			$xml->add_tag('link', $vbulletin->options['bburl'] . '/media.php', array(), false, true);
			$xml->add_tag('description', $vbulletin->options['description']);
			$xml->add_tag('language', vB_Template_Runtime::fetchStyleVar('languagecode'));
			$xml->add_tag('lastBuildDate', gmdate('D, d M Y H:i:s') . ' GMT');
			$xml->add_tag('generator', 'vBulletin Media Library');
			$xml->add_group('image');
				$xml->add_tag('url', create_full_url(vB_Template_Runtime::fetchStyleVar('imgdir_misc') . '/rss.png'));
				$xml->add_tag('title', $vbulletin->options['bbtitle'] . " - " . $vbphrase['media_library'] . $more_inf);
				$xml->add_tag('link', $vbulletin->options['bburl'] . '/media.php', array(), false, true);
			$xml->close_group('image');

			$medias = $vbulletin->db->query_read("
				SELECT media.*, media_category.*, IF(NOT ISNULL(user.userid), user.username, media.username) AS username
				FROM " . TABLE_PREFIX . "media AS media
				LEFT JOIN " . TABLE_PREFIX . "media_category AS media_category ON(media_category.categoryID = media.categoryID)
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = media.userID)
				" . $more_sql . "
				ORDER BY media.dateline DESC
				LIMIT 20
			");

			require_once(DIR . '/includes/class_bbcode_alt.php');

			while ($media = $vbulletin->db->fetch_array($medias))
			{
				$xml->add_group('item');
					$xml->add_tag('title', unhtmlspecialchars($media['title']));
					$xml->add_tag('link', $vbulletin->options['bburl']."/".construct_href_details($media));

					$media['description'] = strip_bbcode($media['description'], true, false, false, true);
					$xml->add_tag('description', fetch_trimmed_title($media['description'], 500));

					$xml->add_tag('dc:creator', unhtmlspecialchars($media['username']));
					$xml->add_tag('pubDate', gmdate('D, d M Y H:i:s', $media['dateline']) . ' GMT');
					$xml->add_tag('comments', $vbulletin->options['bburl']."/".construct_href_details($media).'#comments');
					$xml->add_tag('guid', $vbulletin->options['bburl']."/".construct_href_details($media), array('isPermaLink' => 'true'));
					$xml->add_tag('category', '- '.$media['catName'], array('domain' => preg_replace("/&(?!amp;)/i","&amp;", $vbulletin->options['bburl']."/".construct_href_category($media))));
					$xml->add_tag('category', '+ '.$media['username'], array('domain' => preg_replace("/&(?!amp;)/i","&amp;", $vbulletin->options['bburl']."/".construct_href_user($media))));

					$tags = explode(",",$media['tagcache']);
					foreach ($tags as $tag)
					{
						if ($tag)
						{
							$curr['tagText'] = $tag;
							$xml->add_tag('category', $tag, array('domain' => preg_replace("/&(?!amp;)/i","&amp;", $vbulletin->options['bburl']."/".construct_href_tag($curr))));
						}
					}

					$media['thumbnail'] = $vbulletin->options['bburl']."/".$vbulletin->options['media_thumb_dir']."/thumbs/". $media['mediaID'] .".jpg";
					$xml->add_tag('enclosure', '', array('url' => $media['thumbnail'], 'length' => intval(@filesize(DIR . '/' . $media['thumbnail'])), 'type' => 'image/jpeg' ));
				$xml->close_group('item');
			}
		$xml->close_group('channel');
	$xml->close_group('rss');

	$output .= $xml->output();

	echo $output;
	exit;
}

if ($do == "sitemap")
{
	$target = DIR.'/'.$vbulletin->options['media_thumb_dir'].'/sitemap/media.xml';

	echo file_get_contents($target);

	exit;
}

?>