<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (media/media_functions_href.php)             # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

function construct_href_main()
{
	global $vbulletin;
	return "media" . ($vbulletin->options['media_doseo'] ? "/" : ".php?" . $vbulletin->session->vars['sessionurl']);
}

function construct_href_playlists()
{
	global $vbulletin;
	return construct_href_main() . ($vbulletin->options['media_doseo'] ? "playlists" : "do=playlists");
}

function construct_href_playlists_mine()
{
	global $vbulletin;
	return construct_href_main() . ($vbulletin->options['media_doseo'] ? "pmine" : "do=playlists_mine");
}

function construct_href_playlists_create()
{
	global $vbulletin;
	return construct_href_main() . ($vbulletin->options['media_doseo'] ? "pcreate" : "do=playlists_create");
}

function construct_href_favorites()
{
	global $vbulletin;
	return construct_href_main() . ($vbulletin->options['media_doseo'] ? "favorites" : "do=favorites");
}

function construct_href_subscriptions()
{
	global $vbulletin;
	return construct_href_main() . ($vbulletin->options['media_doseo'] ? "subscriptions" : "do=subscriptions");
}

function construct_href_random()
{
	global $vbulletin;
	return construct_href_main() . ($vbulletin->options['media_doseo'] ? "random" : "do=random");
}

function construct_href_details($media, $playlist = false)
{
	global $vbulletin;

	if ($vbulletin->options['media_doseo'])
	{
		if ($playlist)
		{
			$title = construct_href_slug($media['title']);
			$plist = "/p" . $playlist['playlistID'] . "-" . $title;
		}
		$title = construct_href_slug($media['title']);
		return construct_href_main() . "m" . $media['mediaID'] . "-" . $title . $plist;
	}
	else
	{
		if ($playlist)
		{
			$plist = "&pid=" . $playlist['playlistID'];
		}
		return construct_href_main() . "do=details&mid=" . $media['mediaID'] . $plist;
	}
}

function construct_href_details_tags($media)
{
	global $vbulletin;

	if ($vbulletin->options['media_doseo'])
	{
		$title = construct_href_slug($media['title']);
		return construct_href_main() . "m" . $media['mediaID'] . "-" . $title . "/tags";
	}
	else
	{
		return construct_href_main() . "do=tags_edit&mid=" . $media['mediaID'];
	}
}

function construct_href_details_edit($media)
{
	global $vbulletin;

	if ($vbulletin->options['media_doseo'])
	{
		$title = construct_href_slug($media['title']);
		return construct_href_main() . "m" . $media['mediaID'] . "-" . $title . "/edit";
	}
	else
	{
		return construct_href_main() . "do=details_edit&mid=" . $media['mediaID'];
	}
}

function construct_href_details_report($media)
{
	global $vbulletin;

	if ($vbulletin->options['media_doseo'])
	{
		$title = construct_href_slug($media['title']);
		return construct_href_main() . "m" . $media['mediaID'] . "-" . $title . "/report";
	}
	else
	{
		return construct_href_main() . "do=report&mid=" . $media['mediaID'];
	}
}

function construct_href_comment($comment)
{
	global $vbulletin;

	if ($vbulletin->options['media_doseo'])
	{
		$title = construct_href_slug($comment['title']);
		return construct_href_main() . "m" . $comment['mediaID'] . "-" . $title . "/c" . $comment['commentID'];
	}
	else
	{
		return construct_href_main() . "do=comment_edit&cmt=" . $comment['commentID'];
	}
}

function construct_href_browse($sort = '')
{
	global $vbulletin;

	if ($vbulletin->options['media_doseo'])
	{
		return construct_href_main() . "browse" . ($sort ? "?sort=".$sort : "");
	}
	else
	{
		return construct_href_main() . "do=browse" . ($sort ? "&sort=".$sort : "");
	}
}

function construct_href_playlist($playlist)
{
	global $vbulletin;

	if ($vbulletin->options['media_doseo'])
	{
		$title = construct_href_slug($playlist['plName']);
		return construct_href_main() . "p" . $playlist['playlistID'] . "-" . $title;
	}
	else
	{
		return construct_href_main() . "do=playlist&pid=" . $playlist['playlistID'];
	}
}

function construct_href_playlist_edit($playlist)
{
	global $vbulletin;

	if ($vbulletin->options['media_doseo'])
	{
		$title = construct_href_slug($playlist['plName']);
		return construct_href_main() . "p" . $playlist['playlistID'] . "-" . $title . "/edit";
	}
	else
	{
		return construct_href_main() . "do=playlist_edit&pid=" . $playlist['playlistID'];
	}
}

function construct_href_category($category, $sort = '')
{
	global $vbulletin;

	if ($vbulletin->options['media_doseo'])
	{
		$title = construct_href_slug($category['catName']);
		return construct_href_main() . "c" . $category['categoryID'] . "-" . $title . ($sort ? "?sort=".$sort : "");
	}
	else
	{
		return construct_href_main() . "do=category&cid=" . $category['categoryID'] . ($sort ? "&sort=".$sort : "");
	}
}

function construct_href_user($user, $sort = '')
{
	global $vbulletin;

	if ($vbulletin->options['media_doseo'])
	{
		$title = construct_href_slug($user['username']);
		return construct_href_main() . "u" . $user['userID'] . "-" . $title . ($sort ? "?sort=".$sort : "");
	}
	else
	{
		return construct_href_main() . "do=user&uid=" . $user['userID'] . ($sort ? "&sort=".$sort : "");
	}
}

function construct_href_tag($tag, $sort = '')
{
	global $vbulletin;

	if ($vbulletin->options['media_doseo'])
	{
		return construct_href_main() . "tag/" . $tag['tagText'] . ($sort ? "?sort=".$sort : "");
	}
	else
	{
		return construct_href_main() . "do=tag&tid=" . $tag['tagText'] . ($sort ? "&sort=".$sort : "");
	}
}

function construct_href_tag_cloud()
{
	global $vbulletin;
	return construct_href_main() . ($vbulletin->options['media_doseo'] ? "tagcloud" : "do=tagcloud");
}

function construct_href_search()
{
	global $vbulletin;
	return construct_href_main() . ($vbulletin->options['media_doseo'] ? "search" : "do=search");
}

function construct_href_results($query, $sort = '')
{
	global $vbulletin;

	if ($vbulletin->options['media_doseo'])
	{
		return construct_href_main() . "results/" . $query . ($sort ? "?sort=".$sort : "");
	}
	else
	{
		return construct_href_main() . "do=results&query=" . $query . ($sort ? "&sort=".$sort : "");
	}
}

function construct_href_advresults($title, $description, $custom1, $custom2, $custom3, $custom4, $custom5, $custom6, $custom7, $custom8, $custom9, $sort = '')
{
	global $vbulletin;

	if ($title) { $query .= "title=".$title."&"; }
	if ($description) { $query .= "description=".$description."&"; }
	if ($custom1) { $query .= "custom1=".$custom1."&"; }
	if ($custom2) { $query .= "custom2=".$custom2."&"; }
	if ($custom3) { $query .= "custom3=".$custom3."&"; }
	if ($custom4) { $query .= "custom4=".$custom4."&"; }
	if ($custom5) { $query .= "custom5=".$custom5."&"; }
	if ($custom6) { $query .= "custom6=".$custom6."&"; }
	if ($custom7) { $query .= "custom7=".$custom7."&"; }
	if ($custom8) { $query .= "custom8=".$custom8."&"; }
	if ($custom9) { $query .= "custom9=".$custom9."&"; }

	if ($vbulletin->options['media_doseo'])
	{
		return construct_href_main() . "advresults/?" . $query . ($sort ? "sort=".$sort : "");
	}
	else
	{
		return construct_href_main() . "do=advresults&" . $query . ($sort ? "sort=".$sort : "");
	}
}

function construct_href_letter($query, $sort = '')
{
	global $vbulletin;

	if ($vbulletin->options['media_doseo'])
	{
		return construct_href_main() . "letter/" . $query . ($sort ? "?sort=".$sort : "");
	}
	else
	{
		return construct_href_main() . "do=letter&query=" . $query . ($sort ? "&sort=".$sort : "");
	}
}

function construct_href_submit()
{
	global $vbulletin;
	return construct_href_main() . ($vbulletin->options['media_doseo'] ? "submit" : "do=submit");
}

function construct_href_admin($admin = "cats")
{
	global $vbulletin;
	return construct_href_main() . ($vbulletin->options['media_doseo'] ? "admin/" : "do=admin_") . $admin;
}

function construct_href_host_edit($service)
{
	global $vbulletin;
	return construct_href_main() . ($vbulletin->options['media_doseo'] ? "admin/edit/s" : "do=admin_host_edit&sid=") . $service['serviceID'];
}

function construct_href_host_delete($service)
{
	global $vbulletin;
	return construct_href_main() . ($vbulletin->options['media_doseo'] ? "admin/delete/s" : "do=admin_host_delete&sid=") . $service['serviceID'];
}

function construct_href_host_export($service)
{
	global $vbulletin;
	return construct_href_main() . ($vbulletin->options['media_doseo'] ? "admin/export/s" : "do=admin_host_export&sid=") . $service['serviceID'];
}

function construct_href_slug($title)
{
	$title = preg_replace('#[^\w]#', '-', $title);		// replace all non word characters with dash
	$title = preg_replace('#-+#', '-', $title);			// replace multiple dashes with single dash
	$title = preg_replace('#^-#', '', $title);			// strip excess dash from start of string
	$title = preg_replace('#-$#', '', $title);			// strip excess dash from end of string
	$title = strtolower($title);
	return $title;
}

?>