<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (media/media_comment.php)                    # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

if (!$perms['comment'])
{
	print_no_permission();
}

if ($do == "comment")
{
	$vbulletin->input->clean_array_gpc('p', array(
		'message'	=> TYPE_STR,
		'wysiwyg'	=> TYPE_BOOL,
	));

	$message = $vbulletin->GPC['message'];
	$wysiwig = $vbulletin->GPC['wysiwyg'];
	$visible = "visible";

	if ($ajax)
	{
		$message = convert_urlencoded_unicode($message);
	}

	if ($wysiwig)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$message = convert_wysiwyg_html_to_bbcode($message, false);
	}

	$dm =& datamanager_init('Media_Comment', $vbulletin, ($ajax ? ERRTYPE_ARRAY : ERRTYPE_STANDARD));
	$dm->setr('mediaID', $mid);
	$dm->setr('message', $message);
	$dm->setr('state', $visible);
	$dm->pre_save();

	$media = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media WHERE mediaID = '".$mid."'");

	if ($media['subscriptions'])
	{
		$users = $vbulletin->db->query_read("SELECT username, userid FROM " . TABLE_PREFIX . "user WHERE userid IN (".$media['subscriptions'].")");

		while ($user = $vbulletin->db->fetch_array($users))
		{
			if ($user['userid'] != $vbulletin->userinfo['userid'])
			{
				$recipients[] = $user['username'];
			}
		}

		if ($recipients)
		{
			$recipients = implode(";", $recipients);

			$media['href'] = $vbulletin->options['bburl']."/".construct_href_details($media)."#comments";
			$user['username'] = $vbulletin->userinfo['username'];
			$user['href'] = fetch_seo_url('member', $vbulletin->userinfo);

			eval("\$title = \"$vbphrase[media_newpm_title]\";");
			eval("\$pmtext = \"$vbphrase[media_newpm_message]\";");

			$pmdm =& datamanager_init('PM', $vbulletin);
			$pmdm->overridequota = true;
			$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
			$pmdm->set('fromusername', $vbulletin->userinfo['username']);
			$pmdm->set('title', $title);
			$pmdm->set('message', $pmtext);
			$pmdm->set('dateline', TIMENOW);
			$pmdm->set_recipients($recipients, $botpermissions);
			$pmdm->pre_save();
		}
	}

	if ($ajax)
	{
		$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');

		if (sizeof($dm->errors))
		{
			$xml->add_group('errors');
			foreach ($dm->errors AS $error) { $xml->add_tag('error', $error); }
			$xml->close_group();
		}
		else
		{
			$dm->save();
			if ($recipients)
			{
				$pmdm->save();
			}

			$xml->add_group('response');
			$xml->add_tag('mid', $mid);
			$xml->close_group();
		}

		$xml->print_xml(true);
	}

	$dm->save();
	if ($recipients)
	{
		$pmdm->save();
	}

	$vbulletin->url = construct_href_details($media);
	eval(print_standard_redirect('media_comment_added'));
}

if ($do == "comment_edit")
{
	if (!$comment = $vbulletin->db->query_first("
		SELECT media_comment.*, media.*
		FROM " . TABLE_PREFIX . "media_comment AS media_comment
		LEFT JOIN " . TABLE_PREFIX . "media AS media ON(media.mediaID = media_comment.mediaID)
		WHERE media_comment.commentID = '".$cmt."'
	"))
	{
		eval(standard_error(fetch_error('media_comment_invalid')));
	}

	$comment['date'] = vbdate($vbulletin->options['dateformat'], $comment['dateline']);
	$comment['time'] = vbdate($vbulletin->options['timeformat'], $comment['dateline']);

	require_once(DIR . '/includes/functions_editor.php');
	$editorid = construct_edit_toolbar($comment['message'],0,'nonforum',1,1,0,'fe');

	$navbits[construct_href_details($comment)] = $comment['title'];
	$navbits[''] = $vbphrase['media_comment_edit']; 

	$templater = vB_Template::create('8WR_media_comment');
		$templater->register('comment', $comment);
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
	$mediaHTML = $templater->render();
}

if ($do == "comment_data")
{
	$vbulletin->input->clean_array_gpc('p', array(
		'message'	=> TYPE_STR,
		'action'	=> TYPE_STR,
		'wysiwyg'	=> TYPE_BOOL,
	));

	$comment = array('commentID' => $cmt);

	$message = $vbulletin->GPC['message'];
	$action = $vbulletin->GPC['action'];
	$wysiwig = $vbulletin->GPC['wysiwyg'];

	$dm =& datamanager_init('Media_Comment', $vbulletin);
	$dm->set_existing($comment);

	$media = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media WHERE mediaID = '".$mid."'");

	if ($action == "delete")
	{
		$dm->delete();
		build_comment_count($mid);

		$vbulletin->url = construct_href_details($media);
		eval(print_standard_redirect('media_comment_deleted'));
	}
	else
	{
		if ($wysiwyg)
		{
			require_once(DIR . '/includes/functions_wysiwyg.php');
			$description = convert_wysiwyg_html_to_bbcode($description, false);
		}

		$dm->setr('message', $message);
		$dm->save();

		$vbulletin->url = construct_href_details($media);
		eval(print_standard_redirect('media_comment_saved'));
	}
}

?>