/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (media/media_ajax_comment.js)                # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

function comment_init(mid, pid)
{
	if (AJAX_Compatible && (typeof vb_disable_ajax == 'undefined' || vb_disable_ajax < 2))
	{
		if (fetch_object('commentsubmit'))
		{
			var sbutton = document.getElementById('commentsubmit');
			var button = document.createElement('input');
			button.type      = 'button';
			button.className = sbutton.className;
			button.name      = sbutton.name;
			button.id        = sbutton.id;
			button.value     = sbutton.value;
			button.onclick   = function() { post_comment(mid); };
			sbutton.parentNode.insertBefore(button, sbutton);
			sbutton.parentNode.removeChild(sbutton);
		}
		get_pagenav(mid, pid);
	}
}

function post_comment(mid)
{
	if (!fetch_object('vB_Editor_QR_textarea').value)
	{
		return false;
	}

	fetch_object('commentsubmit').value = vbphrase['post_comment_wait'];
	fetch_object('commentsubmit').disabled = true;

	YAHOO.util.Connect.asyncRequest("POST", "media_ajax.php?do=comment", {
		success: send_comment,
		failure: vBulletin_AJAX_Error_Handler,
		timeout: 15000
	}, SESSIONURL + 'securitytoken=' + SECURITYTOKEN + "&mid=" + mid + "&message=" + PHP.urlencode(fetch_object('vB_Editor_QR_textarea').value));

	return false;
}

function send_comment(ajax)
{
	if (ajax.responseXML)
	{
		var error = ajax.responseXML.getElementsByTagName('error');
		if (error.length)
		{
			fetch_object('commentsubmit').value = vbphrase['post_comment_fail'];
			fetch_object('commentsubmit').disabled = false;
			alert(error[0].firstChild.nodeValue);
		}
		else
		{
			var mid = ajax.responseXML.getElementsByTagName('mid')[0].firstChild.nodeValue;
			fetch_object('commentsubmit').value = vbphrase['post_comment'];
			fetch_object('commentform').innerHTML = "";
			get_comments(mid,1);
		}
	}
}

function get_pagenav(mid, pid)
{
	YAHOO.util.Connect.asyncRequest("POST", "media_ajax.php?do=details_pagenav", {
		success: send_pagenav,
		failure: vBulletin_AJAX_Error_Handler,
		timeout: 15000
	}, SESSIONURL + 'securitytoken=' + SECURITYTOKEN + "&mid=" + mid + "&pid=" + pid);

	return false;
}

function send_pagenav(ajax)
{
	if (ajax.responseXML)
	{
		var error = ajax.responseXML.getElementsByTagName('error');
		if (error.length)
		{
			alert(error[0].firstChild.nodeValue);
		}
		else
		{
			try
			{
				var pagenav = ajax.responseXML.getElementsByTagName('pagenav')[0].firstChild.nodeValue;
				fetch_object('pagination_top').innerHTML = pagenav;
			}
			catch (e) { }
		}
	}
}

function get_comments(mid, pid, page)
{
	YAHOO.util.Connect.asyncRequest("POST", "media_ajax.php?do=details_comments", {
		success: send_comments,
		failure: vBulletin_AJAX_Error_Handler,
		timeout: 15000
	}, SESSIONURL + 'securitytoken=' + SECURITYTOKEN + "&mid=" + mid + "&pid=" + pid + "&page=" + page);

	return false;
}

function send_comments(ajax)
{
	if (ajax.responseXML)
	{
		// check for error first
		var error = ajax.responseXML.getElementsByTagName('error');
		if (error.length)
		{
			alert(error[0].firstChild.nodeValue);
		}
		else
		{
			try
			{
				var commentbits = ajax.responseXML.getElementsByTagName('commentbits')[0].firstChild.nodeValue;
				fetch_object('message_list').innerHTML = commentbits;
			}
			catch (e) { }

			try
			{
				var pagenav = ajax.responseXML.getElementsByTagName('pagenav')[0].firstChild.nodeValue;
				fetch_object('pagination_top').innerHTML = pagenav;
			}
			catch (e) { }
		}
	}
}