<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (media/media_admin.php)                      # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

if ($do == "admin_cats")
{
	if (!$perms['modcategory']) { print_no_permission(); }

	$categories = $vbulletin->db->query_read("
		SELECT * FROM ".TABLE_PREFIX."media_category
		WHERE catOrder != '0'
		ORDER BY catOrder
	");

	while ($category = $vbulletin->db->fetch_array($categories))
	{
		$category['align'] = "";
		for ($i = 0; $i < $category['catDepth']; $i++)
		{
			$category['align'] .= '<img src="images/misc/navbit-arrow-right.png" alt="" /> ';
		}

		$templater = vB_Template::create('8WR_media_admin_cats_bit');
			$templater->register('category', $category);
		$catbits .= $templater->render();
	}

	$categories = $vbulletin->db->query_read("
		SELECT * FROM ".TABLE_PREFIX."media_category
		WHERE catOrder = '0'
	");

	while ($category = $vbulletin->db->fetch_array($categories))
	{
		$category['align'] = "";
		for ($i = 0; $i < $category['catDepth']; $i++)
		{
			$category['align'] .= '<img src="images/misc/navbit-arrow-right.png" alt="" /> ';
		}

		$templater = vB_Template::create('8WR_media_admin_cats_bit');
			$templater->register('category', $category);
		$inactivecatbits .= $templater->render();
	}

	$navbits[''] = $vbphrase['media_admin_cats']; 

	$templater = vB_Template::create('8WR_media_admin_cats');
		$templater->register('catbits', $catbits);
		$templater->register('inactivecatbits', $inactivecatbits);
	$mediaHTML = $templater->render();
}

if ($do == "admin_cats_edit")
{
	if (!$perms['modcategory']) { print_no_permission(); }

	$categories = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "media_category");

	while ($category = $vbulletin->db->fetch_array($categories))
	{
		$catName = $vbulletin->input->clean_gpc('p', "catName:".$category['categoryID'], TYPE_STR);
		$catDesc = $vbulletin->input->clean_gpc('p', "catDesc:".$category['categoryID'], TYPE_STR);
		$catOrder = $vbulletin->input->clean_gpc('p', "catOrder:".$category['categoryID'], TYPE_UINT);
		$catDepth = $vbulletin->input->clean_gpc('p', "catDepth:".$category['categoryID'], TYPE_UINT);

		$categoryID = array('categoryID' => $category['categoryID']);

		$dm =& datamanager_init('Media_Category', $vbulletin);
		$dm->set_existing($categoryID);
		$dm->setr('catName', $catName);
		$dm->setr('catDesc', $catDesc);
		$dm->setr('catOrder', $catOrder);
		$dm->setr('catDepth', $catDepth);
		$dm->save();
	}

	$vbulletin->url = construct_href_admin("cats");
	eval(print_standard_redirect('media_cats_saved'));
}

if ($do == "admin_cats_data")
{
	if (!$perms['modcategory']) { print_no_permission(); }

	$vbulletin->input->clean_array_gpc('p', array(
		'catName'	=> TYPE_STR,
		'catDesc'	=> TYPE_STR,
		'catOrder'	=> TYPE_UINT,
		'catDepth'	=> TYPE_UINT,
	));

	$catName = $vbulletin->GPC['catName'];
	$catDesc = $vbulletin->GPC['catDesc'];
	$catOrder = $vbulletin->GPC['catOrder'];
	$catDepth = $vbulletin->GPC['catDepth'];

	$dm =& datamanager_init('Media_Category', $vbulletin);
	$dm->setr('catName', $catName);
	$dm->setr('catDesc', $catDesc);
	$dm->setr('catOrder', $catOrder);
	$dm->setr('catDepth', $catDepth);
	$dm->save();

	$vbulletin->url = construct_href_admin("cats");
	eval(print_standard_redirect('media_cats_added'));
}

if ($do == "admin_tags")
{
	if (!$perms['modtags']) { print_no_permission(); }

	$tags = $vbulletin->db->query_first("SELECT COUNT('tagID') AS count FROM ".TABLE_PREFIX."media_tag");

	sanitize_pageresults($tags['count'], $pagenumber, $perpage, 400, 400);

	if ($vbulletin->GPC['pagenumber'] < 1)
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}
	else if ($vbulletin->GPC['pagenumber'] > ceil(($tags['count'] + 1) / $perpage))
	{
		$vbulletin->GPC['pagenumber'] = ceil(($tags['count'] + 1) / $perpage);
	}

	$pagenav = construct_page_nav($vbulletin->GPC['pagenumber'], $perpage, $tags['count'], construct_href_admin("tags")); 

	$limitlower = ($vbulletin->GPC['pagenumber'] - 1) * $perpage;
	$limitupper = ($vbulletin->GPC['pagenumber']) * $perpage;

	$tags = $vbulletin->db->query_read("
		SELECT media_tag.*, COUNT(media_tag_content.mediaID) AS count
		FROM " . TABLE_PREFIX . "media_tag AS media_tag
		LEFT JOIN " . TABLE_PREFIX . "media_tag_content AS media_tag_content ON (media_tag_content.tagID = media_tag.tagID)
		GROUP BY media_tag.tagID
		ORDER BY media_tag.tagText
		LIMIT $limitlower, $perpage
	");

	while ($tag = $vbulletin->db->fetch_array($tags))
	{
		$href['tag'] = construct_href_tag($tag);

		$templater = vB_Template::create('8WR_media_admin_tags_bit');
			$templater->register('tag', $tag);
			$templater->register('href', $href);
		$tagbits .= $templater->render();

		$count++;
		if (($count % 100 == 0) AND ($count != 400)) { $tagbits .= '</td><td valign="top">'; }
	}

	$navbits[''] = $vbphrase['media_admin_tags']; 

	$templater = vB_Template::create('8WR_media_admin_tags');
		$templater->register('tagbits', $tagbits);
		$templater->register('pagenav', $pagenav);
		$templater->register('pagenumber', $pagenumber);
		$templater->register('perpage', $perpage);
	$mediaHTML = $templater->render();
}

if ($do == "admin_tags_edit")
{
	if (!$perms['modtags']) { print_no_permission(); }

	$vbulletin->input->clean_array_gpc('p', array(
		'tag' => TYPE_ARRAY_KEYS_INT
	));

	if ($vbulletin->GPC['tag'])
	{
		$tags = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "media_tag
			WHERE tagID IN (" . implode(',', $vbulletin->GPC['tag']) . ")
		");

		$medias = $vbulletin->db->query_read("
			SELECT media.*
			FROM " . TABLE_PREFIX . "media AS media
			LEFT JOIN " . TABLE_PREFIX . "media_tag_content AS media_tag_content ON (media_tag_content.mediaID = media.mediaID)
			WHERE media_tag_content.tagID IN (" . implode(',', $vbulletin->GPC['tag']) . ")
		");

		$db->query_write("
			DELETE FROM " . TABLE_PREFIX . "media_tag
			WHERE tagID IN (" . implode(',', $vbulletin->GPC['tag']) . ")
		");

		$db->query_write("
			DELETE FROM " . TABLE_PREFIX . "media_tag_content
			WHERE tagID IN (" . implode(',', $vbulletin->GPC['tag']) . ")
		");

		while ($media = $vbulletin->db->fetch_array($medias))
		{
			build_tags_cache($media['mediaID']);
		}
	}

	$vbulletin->url = construct_href_admin("tags");
	eval(print_standard_redirect('media_tags_deleted'));
}

if ($do == "admin_tags_data")
{
	if (!$perms['modtags']) { print_no_permission(); }

	$vbulletin->input->clean_array_gpc('p', array(
		'taglist'   => TYPE_NOHTML,
	));

	$taglist = $vbulletin->GPC['taglist'];
	
	if ($taglist)
	{
		build_tags($taglist);
	}

	$vbulletin->url = construct_href_admin("tags");
	eval(print_standard_redirect('media_tags_added'));
}

if ($do == "admin_host")
{
	if (!$perms['modservice']) { print_no_permission(); }

	$services = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "media_service ORDER BY svcName");

	while ($service = $vbulletin->db->fetch_array($services))
	{
		$href['edit'] = construct_href_host_edit($service);
		$href['delete'] = construct_href_host_delete($service);
		$href['export'] = construct_href_host_export($service);

		$templater = vB_Template::create('8WR_media_admin_host_bit');
			$templater->register('service', $service);
			$templater->register('href', $href);
		$hostbits .= $templater->render();
	}

	$navbits[''] = $vbphrase['media_admin_host']; 

	$templater = vB_Template::create('8WR_media_admin_host');
		$templater->register('hostbits', $hostbits);
	$mediaHTML = $templater->render();
}

if ($do == "admin_host_edit")
{
	if (!$perms['modservice']) { print_no_permission(); }

	if (!$service = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media_service WHERE serviceID = '".$sid."'"))
	{
		eval(standard_error(fetch_error('media_service_invalid')));
	}

	$navbits[construct_href_admin("host")] = $vbphrase['media_admin_host'];
	$navbits[''] = $service['svcName']; 

	$templater = vB_Template::create('8WR_media_admin_host_edit');
		$templater->register('service', $service);
	$mediaHTML = $templater->render();
}

if ($do == "admin_host_data")
{
	if (!$perms['modservice']) { print_no_permission(); }

	$vbulletin->input->clean_array_gpc('p', array(
		'svcRegex'		=> TYPE_STR,
		'svcURL'		=> TYPE_STR,
		'svcFeed'		=> TYPE_STR,
		'svcValue2'		=> TYPE_STR,
		'svcThumb'		=> TYPE_STR,
		'svcTitle'		=> TYPE_STR,
		'svcDesc'		=> TYPE_STR,
		'svcLength'		=> TYPE_STR,
		'svcTags'		=> TYPE_STR,
		'svcMovie'		=> TYPE_STR,
		'svcWidth'		=> TYPE_UINT,
		'svcHeight'		=> TYPE_UINT,
		'svcStream'		=> TYPE_STR,
		'svcError'		=> TYPE_STR,
		'svcParams'		=> TYPE_STR,
	));

	$svcRegex = $vbulletin->GPC['svcRegex'];
	$svcURL = $vbulletin->GPC['svcURL'];
	$svcFeed = $vbulletin->GPC['svcFeed'];
	$svcValue2 = $vbulletin->GPC['svcValue2'];
	$svcThumb = $vbulletin->GPC['svcThumb'];
	$svcTitle = $vbulletin->GPC['svcTitle'];
	$svcDesc = $vbulletin->GPC['svcDesc'];
	$svcLength = $vbulletin->GPC['svcLength'];
	$svcTags = $vbulletin->GPC['svcTags'];
	$svcMovie = $vbulletin->GPC['svcMovie'];
	$svcWidth = $vbulletin->GPC['svcWidth'];
	$svcHeight = $vbulletin->GPC['svcHeight'];
	$svcStream = $vbulletin->GPC['svcStream'];
	$svcError = $vbulletin->GPC['svcError'];
	$svcParams = $vbulletin->GPC['svcParams'];

	$service = array('serviceID' => $sid);

	$dm =& datamanager_init('Media_Service', $vbulletin);
	$dm->set_existing($service);
	$dm->setr('svcRegex', $svcRegex);
	$dm->setr('svcURL', $svcURL);
	$dm->setr('svcFeed', $svcFeed);
	$dm->setr('svcValue2', $svcValue2);
	$dm->setr('svcThumb', $svcThumb);
	$dm->setr('svcTitle', $svcTitle);
	$dm->setr('svcDesc', $svcDesc);
	$dm->setr('svcLength', $svcLength);
	$dm->setr('svcTags', $svcTags);
	$dm->setr('svcMovie', $svcMovie);
	$dm->setr('svcWidth', $svcWidth);
	$dm->setr('svcHeight', $svcHeight);
	$dm->setr('svcStream', $svcStream);
	$dm->setr('svcError', $svcError);
	$dm->setr('svcParams', $svcParams);
	$dm->save();

	$vbulletin->url = construct_href_admin("host");
	eval(print_standard_redirect('media_host_saved'));
}

if ($do == "admin_host_delete")
{
	if (!$perms['modservice']) { print_no_permission(); }

	if (!$service = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media_service WHERE serviceID = '".$sid."'"))
	{
		eval(standard_error(fetch_error('media_service_invalid')));
	}

	$medias = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "media WHERE serviceID = '".$sid."' ORDER BY mediaID ASC");

	while ($media = $vbulletin->db->fetch_array($medias))
	{
		$media['date'] = vbdate($vbulletin->options['dateformat'], $media['dateline']);
		$media['time'] = vbdate($vbulletin->options['timeformat'], $media['dateline']);
		$media['href'] = construct_href_details($media);

		$templater = vB_Template::create('8WR_media_admin_host_delete_bit');
			$templater->register('media', $media);
		$mediabits .= $templater->render();
	}

	$navbits[construct_href_admin("host")] = $vbphrase['media_admin_host'];
	$navbits[''] = $service['svcName']; 

	$templater = vB_Template::create('8WR_media_admin_host_delete');
		$templater->register('service', $service);
		$templater->register('mediabits', $mediabits);
	$mediaHTML = $templater->render();
}

if ($do == "admin_host_kill")
{
	if (!$perms['modservice']) { print_no_permission(); }

	$vbulletin->input->clean_array_gpc('p', array(
		'action'		=> TYPE_STR,
	));

	$action = $vbulletin->GPC['action'];

	if (!$service = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media_service WHERE serviceID = '".$sid."'"))
	{
		eval(standard_error(fetch_error('media_service_invalid')));
	}

	if ($media = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media WHERE serviceID = '".$sid."'"))
	{
		$vbulletin->url = construct_href_host_delete($service);
		eval(print_standard_redirect('media_details_thumb'));
	}

	if ($action == "delete")
	{
		$dm =& datamanager_init('Media_Service', $vbulletin);
		$dm->set_existing($service);
		$dm->delete();
	}

	$vbulletin->url = construct_href_admin('host');
	eval(print_standard_redirect('media_host_deleted'));
}

if ($do == "admin_host_export")
{
	if (!$perms['modservice']) { print_no_permission(); }

	if (!$service = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media_service WHERE serviceID = '".$sid."'"))
	{
		eval(standard_error(fetch_error('media_service_invalid')));
	}

	$output = '<?xml version="1.0" encoding="UTF-8"?>' . "\r\n\r\n";

	require_once(DIR . '/includes/class_xml.php');
	$xml = new vB_XML_Builder($vbulletin);

	$xml->add_group('service');
		$xml->add_tag('svcName', $service['svcName']);
		$xml->add_tag('svcRegex', $service['svcRegex']);
		$xml->add_tag('svcURL', $service['svcURL']);
		$xml->add_tag('svcFeed', $service['svcFeed']);
		$xml->add_tag('svcValue2', $service['svcValue2']);
		$xml->add_tag('svcThumb', $service['svcThumb']);
		$xml->add_tag('svcTitle', $service['svcTitle']);
		$xml->add_tag('svcDesc', $service['svcDesc']);
		$xml->add_tag('svcLength', $service['svcLength']);
		$xml->add_tag('svcTags', $service['svcTags']);
		$xml->add_tag('svcMovie', $service['svcMovie']);
		$xml->add_tag('svcWidth', $service['svcWidth']);
		$xml->add_tag('svcHeight', $service['svcHeight']);
		$xml->add_tag('svcStream', $service['svcStream']);
		$xml->add_tag('svcError', $service['svcError']);
		$xml->add_tag('svcParams', $service['svcParams']);
	$xml->close_group('service');

	$output .= $xml->output();

	require_once(DIR . '/includes/functions_file.php');
	file_download($output, $service['svcName'] . '.xml', 'text/xml');
}

if ($do == "admin_host_import")
{
	if (!$perms['modservice']) { print_no_permission(); }

	$vbulletin->input->clean_array_gpc('f', array(
		'upload'	=> TYPE_FILE,
	));

	if (!$upload = file_get_contents($vbulletin->GPC['upload']['tmp_name']))
	{ 
   		eval(standard_error(fetch_error('no_file_uploaded_and_no_local_file_found'))); 
	}

	require_once(DIR.'/includes/class_xml.php');
	$xmlobj = new vB_XML_Parser($upload);
	$arr = $xmlobj->parse();

	$dm =& datamanager_init('Media_Service', $vbulletin);

	if ($service = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media_service WHERE svcName = '".$arr['svcName']."'"))
	{
		$dm->set_existing($service);
	}

	$dm->setr('svcName', $arr['svcName']);
	$dm->setr('svcRegex', $arr['svcRegex']);
	$dm->setr('svcURL', $arr['svcURL']);
	$dm->setr('svcFeed', $arr['svcFeed']);
	$dm->setr('svcValue2', $arr['svcValue2']);
	$dm->setr('svcThumb', $arr['svcThumb']);
	$dm->setr('svcTitle', $arr['svcTitle']);
	$dm->setr('svcDesc', $arr['svcDesc']);
	$dm->setr('svcLength', $arr['svcLength']);
	$dm->setr('svcTags', $arr['svcTags']);
	$dm->setr('svcMovie', $arr['svcMovie']);
	$dm->setr('svcWidth', $arr['svcWidth']);
	$dm->setr('svcHeight', $arr['svcHeight']);
	$dm->setr('svcStream', $arr['svcStream']);
	$dm->setr('svcError', $arr['svcError']);
	$dm->setr('svcParams', $arr['svcParams']);
	$dm->save();

	$service = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media_service WHERE svcName = '".$arr['svcName']."'");

	$vbulletin->url = construct_href_host_edit($service);
	eval(print_standard_redirect('media_host_imported'));
}

if ($do == "admin_host_restore")
{
	if ($handle = opendir(DIR.'/media/xml'))
	{
		require_once(DIR.'/includes/class_xml.php');

		while (false !== ($file = readdir($handle)))
		{
			if (strstr($file,'xml'))
			{
				$upload = file_get_contents(DIR."/media/xml/".$file);

				$xmlobj = new vB_XML_Parser($upload);
				$arr = $xmlobj->parse();

				$dm =& datamanager_init('Media_Service', $vbulletin);

				if ($service = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media_service WHERE svcName = '".$arr['svcName']."'"))
				{
					$dm->set_existing($service);
				}

				$dm->setr('svcName', $arr['svcName']);
				$dm->setr('svcRegex', $arr['svcRegex']);
				$dm->setr('svcURL', $arr['svcURL']);
				$dm->setr('svcFeed', $arr['svcFeed']);
				$dm->setr('svcValue2', $arr['svcValue2']);
				$dm->setr('svcThumb', $arr['svcThumb']);
				$dm->setr('svcTitle', $arr['svcTitle']);
				$dm->setr('svcDesc', $arr['svcDesc']);
				$dm->setr('svcLength', $arr['svcLength']);
				$dm->setr('svcTags', $arr['svcTags']);
				$dm->setr('svcMovie', $arr['svcMovie']);
				$dm->setr('svcWidth', $arr['svcWidth']);
				$dm->setr('svcHeight', $arr['svcHeight']);
				$dm->setr('svcStream', $arr['svcStream']);
				$dm->setr('svcError', $arr['svcError']);
				$dm->setr('svcParams', $arr['svcParams']);
				$dm->save();
			}
		}
	}

	$vbulletin->url = construct_href_admin('host');
	eval(print_standard_redirect('media_host_restored'));
}

?>