<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (includes/class_dm_media_tag_content.php)    # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager')) { exit; }  

class vB_DataManager_Media_Tag_Content extends vB_DataManager
{
	var $validfields = array(
		'tagID'		=> array(TYPE_UINT,	REQ_YES),
		'mediaID'	=> array(TYPE_UINT,	REQ_YES),
		'userID'	=> array(TYPE_UINT,	REQ_YES),
		'dateline'	=> array(TYPE_STR,	REQ_YES),
	);

	var $table = 'media_tag_content';

	function vB_DataManager_Media_Tag_Content(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);
	}

	function pre_save($doquery = true)
	{
		if (!$this->condition)
		{
			$this->set('dateline', TIMENOW);
			$this->set('userID', $this->registry->userinfo['userid']);
		}

		if ($tagcontent = $this->dbobject->query_first("
			SELECT * FROM " . TABLE_PREFIX . "media_tag_content AS media_tag_content
			WHERE mediaID = '" . $this->fetch_field('mediaID') . "'
				AND tagID = '" . $this->fetch_field('tagID') . "'
		"))
		{
			$this->error('media_details_exists');
			return false;
		}

		return parent::pre_save($doquery);
	}
}

?>