<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (includes/class_dm_media_comment.php)        # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager')) { exit; }  

class vB_DataManager_Media_Comment extends vB_DataManager
{
	var $validfields = array(
		'commentID'		=> array(TYPE_UINT,	REQ_INCR),
		'mediaID'		=> array(TYPE_UINT,	REQ_YES),
		'userID'		=> array(TYPE_UINT,	REQ_YES),
		'username'		=> array(TYPE_STR,	REQ_YES),
		'dateline'		=> array(TYPE_UINT,	REQ_YES),
		'message'		=> array(TYPE_STR,	REQ_YES,	VF_METHOD),
		'state'			=> array(TYPE_STR,	REQ_YES),
		'ipaddress'		=> array(TYPE_STR,	REQ_YES),
	);

	var $table = 'media_comment';
	var $condition_construct = array('commentID = %1$d', 'commentID');

	function vB_DataManager_Media_Comment(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);
	}

	function verify_message(&$message)
	{
		require_once(DIR . '/includes/functions_newpost.php');

		$message = trim(strip_tags($message));
		$message = preg_replace('/&#(0*32|x0*20);/', ' ', $message);
		$message = preg_replace('#\[color=(&quot;|"|\'|)([a-f0-9]{6})\\1]#i', '[color=\1#\2\1]', $message);
		$message = preg_replace('#\[/(left|center|right)]((\r\n|\r|\n)*)\[\\1]#si', '\\2', $message);

		if ($this->registry->options['postmaxchars'] && (vbstrlen($message) > $this->registry->options['postmaxchars']))
		{
			$this->error('media_desc_long', vbstrlen($message), $this->registry->options['postmaxchars']);
			return false;
		}

		if ($this->registry->options['postminchars'] && (vbstrlen($message) < $this->registry->options['postminchars']))
		{
			$this->error('media_desc_short', vbstrlen($message), $this->registry->options['postminchars']);
			return false;
		}

		return true;
	}

	function post_save_once()
	{
		build_comment_count($this->fetch_field('mediaID'));
		return true;
	}

	function pre_save($doquery = true)
	{
		if (!$this->condition)
		{
			$this->set('dateline', TIMENOW);
			$this->set('ipaddress', IPADDRESS);
			$this->set('userID', $this->registry->userinfo['userid']);
			$this->set('username', $this->registry->userinfo['username']);
		}

		return parent::pre_save($doquery);
	}
}

?>