<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (media/media_user.php)                       # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

if ($do == "user")
{
	if (!$user = $vbulletin->db->query_first("
		SELECT user.*, media.userID, COUNT(media.mediaID) AS count
		FROM " . TABLE_PREFIX . "user AS user 
		LEFT JOIN " . TABLE_PREFIX . "media AS media ON(media.userID = user.userid)
		WHERE user.userid = '".$uid."'
		GROUP BY user.userid
	"))
	{
		eval(standard_error(fetch_error('media_user_empty')));
	}

	sanitize_pageresults($user['count'], $pagenumber, $perpage, 30, $vbulletin->options['media_limit_medias']);

	if ($vbulletin->GPC['pagenumber'] < 1)
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}
	else if ($vbulletin->GPC['pagenumber'] > ceil(($user['count'] + 1) / $perpage))
	{
		$vbulletin->GPC['pagenumber'] = ceil(($user['count'] + 1) / $perpage);
	}

	$pagenav = construct_page_nav($vbulletin->GPC['pagenumber'], $perpage, $user['count'], construct_href_user($user, $sort)); 

	$limitlower = ($vbulletin->GPC['pagenumber'] - 1) * $perpage;
	$limitupper = ($vbulletin->GPC['pagenumber']) * $perpage;

	$medias = $vbulletin->db->query_read("
		SELECT media.*, media_service.*, media_category.*, IF(NOT ISNULL(user.userid), user.username, media.username) AS username
		FROM " . TABLE_PREFIX . "media AS media
		LEFT JOIN " . TABLE_PREFIX . "media_service AS media_service ON(media_service.serviceID = media.serviceID)
		LEFT JOIN " . TABLE_PREFIX . "media_category AS media_category ON(media_category.categoryID = media.categoryID)
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = media.userID)
		WHERE media.userID = '".$uid."'
		ORDER BY ".$sortQuery." media.dateline DESC
		LIMIT $limitlower, $perpage
	");

	while ($media = $vbulletin->db->fetch_array($medias))
	{
		$mediabits .= construct_media_bit($media, $vbulletin->options['media_select_bit']);
	}

	if ($perms['submit'])
	{
		$submitsmall = construct_submit_small();
	}

	$sidebar = construct_sidebar();

	$href['sort'] = $sort;
	$href['dateline'] = construct_href_user($user, 'dateline');
	$href['rating'] = construct_href_user($user, 'rating');
	$href['favorites'] = construct_href_user($user, 'favorites');
	$href['comments'] = construct_href_user($user, 'comments');
	$href['views'] = construct_href_user($user, 'views');

	$title = $vbphrase['media_user'] . ": " . $user['username'];
	$description = construct_phrase($vbphrase['media_user_info'],  $user['username'], fetch_seo_url("member", $user));

	$navbits[''] = $vbphrase['media_user'] . ": " . $user['username'];

	$templater = vB_Template::create('8WR_media_browse');
		$templater->register('title', $title);
		$templater->register('description', $description);
		$templater->register('user', $user);
		$templater->register('mediabits', $mediabits);
		$templater->register('href', $href);
		$templater->register('pagenav', $pagenav);
		$templater->register('pagenumber', $pagenumber);
		$templater->register('perpage', $perpage);
		$templater->register('submitsmall', $submitsmall);
		$templater->register('sidebar', $sidebar);
	$mediaHTML = $templater->render();
}

?>