<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (media/media_submit.php)                     # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

if (!$perms['submit'])
{
	print_no_permission();
}

if ($do == "submit")
{
	$vbulletin->input->clean_array_gpc('p', array(
		'source'	=> TYPE_STR,
		'category'	=> TYPE_UINT,
	));

	$source = $vbulletin->GPC['source'];
	$categoryID = $vbulletin->GPC_exists['category'] ? $vbulletin->GPC['category'] : $cid;
	$catselect = construct_cat_bits($categoryID);

	if ($source) { $feed = construct_feed_data($source); }

	require_once(DIR . '/includes/functions_editor.php');
	$editorid = construct_edit_toolbar($feed['description'],0,'nonforum',1,1,0,'fe');

	$navbits[''] = $vbphrase['media_submit'];

	$forum = fetch_foruminfo($vbulletin->options['media_submit_forum']);

	$templater = vB_Template::create('8WR_media_submit');
		$templater->register('categoryID', $categoryID);
		$templater->register('catselect', $catselect);
		$templater->register('feed', $feed);
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
		$templater->register('source', $source);
		$templater->register('forum', $forum);
	$mediaHTML = $templater->render();
}

if ($do == "submit_feed")
{
	$vbulletin->input->clean_array_gpc('p', array(
		'source'	=> TYPE_STR,
	));

	$source = $vbulletin->GPC['source'];

	$feed = construct_feed_data($source);

	$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
	$xml->add_group('response');
	$xml->add_tag('thumbnail', $feed['thumbnail']);
	$xml->add_tag('title', $feed['title']);
	$xml->add_tag('description', $feed['description']);
	$xml->add_tag('taglist', $feed['taglist']);
	$xml->add_tag('minutes', $feed['minutes']);
	$xml->add_tag('seconds', $feed['seconds']);
	$xml->add_tag('embed', $feed['embed']);
	$xml->add_tag('source', $feed['source']);
	$xml->add_tag('serviceID', $feed['serviceID']);
	$xml->add_tag('serviceVAL', $feed['serviceVAL']);
	$xml->add_tag('serviceVAL2', $feed['serviceVAL2']);
	$xml->close_group();
	$xml->print_xml();
}

if ($do == "submit_data")
{
	$vbulletin->input->clean_array_gpc('p', array(
		'category'		=> TYPE_UINT,
		'serviceID'		=> TYPE_UINT,
		'serviceVAL'	=> TYPE_STR,
		'serviceVAL2'	=> TYPE_STR,
		'title'			=> TYPE_STR,
		'message'		=> TYPE_STR,
		'minutes'		=> TYPE_UINT,
		'seconds'		=> TYPE_UINT,
		'custom1'		=> TYPE_STR,
		'custom2'		=> TYPE_STR,
		'custom3'		=> TYPE_STR,
		'custom4'		=> TYPE_STR,
		'custom5'		=> TYPE_STR,
		'custom6'		=> TYPE_STR,
		'custom7'		=> TYPE_STR,
		'custom8'		=> TYPE_STR,
		'custom9'		=> TYPE_STR,
		'source'		=> TYPE_STR,
		'thumbnail'		=> TYPE_STR,
		'taglist'		=> TYPE_NOHTML,
		'newthread'		=> TYPE_STR,
		'wysiwyg'		=> TYPE_BOOL,
	));

	$categoryID = $vbulletin->GPC['category'];
	$serviceID = $vbulletin->GPC['serviceID'];
	$serviceVAL = $vbulletin->GPC['serviceVAL'];
	$serviceVAL2 = $vbulletin->GPC['serviceVAL2'];
	$title = $vbulletin->GPC['title'];
	$description = $vbulletin->GPC['message'];
	$minutes = $vbulletin->GPC['minutes'] * 60;
	$seconds = $vbulletin->GPC['seconds'];
	$length = $minutes + $seconds;
	$custom1 = $vbulletin->GPC['custom1'];
	$custom2 = $vbulletin->GPC['custom2'];
	$custom3 = $vbulletin->GPC['custom3'];
	$custom4 = $vbulletin->GPC['custom4'];
	$custom5 = $vbulletin->GPC['custom5'];
	$custom6 = $vbulletin->GPC['custom6'];
	$custom7 = $vbulletin->GPC['custom7'];
	$custom8 = $vbulletin->GPC['custom8'];
	$custom9 = $vbulletin->GPC['custom9'];
	$visible = "visible";

	$thumbnail = $vbulletin->GPC['thumbnail'];
	$taglist = $vbulletin->GPC['taglist'];
	$newthread = $vbulletin->GPC['newthread'];
	$wysiwig = $vbulletin->GPC['wysiwyg'];

	if ($wysiwyg)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$description = convert_wysiwyg_html_to_bbcode($description, false);
	}

	$dm =& datamanager_init('Media', $vbulletin);
	$dm->setr('categoryID', $categoryID);
	$dm->setr('serviceID', $serviceID);
	$dm->setr('serviceVAL', $serviceVAL);
	$dm->setr('serviceVAL2', $serviceVAL2);
	$dm->setr('title', $title);
	$dm->setr('description', $description);
	$dm->setr('length', $length);
	$dm->setr('custom1', $custom1);
	$dm->setr('custom2', $custom2);
	$dm->setr('custom3', $custom3);
	$dm->setr('custom4', $custom4);
	$dm->setr('custom5', $custom5);
	$dm->setr('custom6', $custom6);
	$dm->setr('custom7', $custom7);
	$dm->setr('custom8', $custom8);
	$dm->setr('custom9', $custom9);
	$dm->setr('state', $visible);
	$dm->pre_save();
	$mediaID = $dm->save();

	if ($thumbnail)
	{
		build_thumbnail($thumbnail, $mediaID);
	}

	if ($taglist)
	{
		build_tags($taglist);
		build_tags_content($taglist,$mediaID);
		build_tags_cache($mediaID);
	}

	$media = $vbulletin->db->query_first("
		SELECT media.*, media_service.*, media_category.*
		FROM " . TABLE_PREFIX . "media AS media
		LEFT JOIN " . TABLE_PREFIX . "media_service AS media_service ON(media_service.serviceID = media.serviceID)
		LEFT JOIN " . TABLE_PREFIX . "media_category AS media_category ON(media_category.categoryID = media.categoryID)
		WHERE mediaID = '".$mediaID."'
	");

	if (($forum = fetch_foruminfo($vbulletin->options['media_submit_forum'])) && ($newthread == "newthread"))
	{
		if ($media['length'] == 0)
		{
			$media['length'] = "???";
		}
		else
		{
			$duration = $media['length'];
			$minutes = floor($duration / 60);
			$seconds = $duration % 60;
			$seconds = str_pad($seconds, 2, "0", STR_PAD_LEFT); 
			$media['length'] = "$minutes $vbphrase[media_min] $seconds $vbphrase[media_sec]";
		}

		$media['date'] = vbdate($vbulletin->options['dateformat'], $media['dateline']);
		$media['time'] = vbdate($vbulletin->options['timeformat'], $media['dateline']);
		$media['thumbnail'] = $vbulletin->options['bburl'].'/'.$vbulletin->options['media_thumb_dir']."/thumbs/". $media['mediaID'] .".jpg";

		$href['details'] = $vbulletin->options['bburl'].'/'.construct_href_details($media);
		$href['category'] = $vbulletin->options['bburl'].'/'.construct_href_category($media);
		$href['user'] = $vbulletin->options['bburl'].'/'.construct_href_user($media);

		$tags = explode(",",$media['tagcache']);
		foreach ($tags as $tagtemp)
		{
			$tag['tagText'] = $tagtemp;
			$tag['href'] = $vbulletin->options['bburl'].'/'.construct_href_tag($tag);

			$media['tags'][] = "[URL=$tag[href]]$tag[tagText][/URL]";
		}
		$media['tags'] = implode(", ", $media['tags']);

		eval("\$title = \"$vbphrase[media_newthread_title]\";");
		eval("\$pagetext = \"$vbphrase[media_newthread_pagetext]\";");

		$threadman =& datamanager_init('Thread_FirstPost', $vbulletin, ERRTYPE_STANDARD, 'threadpost');
		$threadman->setr_info('user', $vbulletin->userinfo);
		$threadman->set_info('forum', $forum);
		$threadman->set_info('skip_moderator_email', true);
		$threadman->set_info('skip_floodcheck', true);
		$threadman->set_info('skip_charcount', true);
		$threadman->set_info('skip_title_error', true);
		$threadman->set_info('parseurl', true);
		$threadman->set('allowsmilie', true);
		$threadman->set('visible', true);
		$threadman->set('open', false);;
		$threadman->set('taglist', $media['tagcache']);
		$threadman->set('forumid', $vbulletin->options['media_submit_forum']);
		$threadman->set('userid', $vbulletin->userinfo['userid']);
		$threadman->set('title', $title);
		$threadman->set('pagetext', $pagetext);
		$threadman->save();
	}

	$vbulletin->url = construct_href_details($media);
	eval(print_standard_redirect('media_submit_added'));
}

?>