<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (media/media_playlist.php)                   # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

if ($do == "playlists")
{
	$medias = $vbulletin->db->query_read("
		SELECT media_playlist.*, IF(NOT ISNULL(user.userid), user.username, media_playlist.username) AS username
		FROM " . TABLE_PREFIX . "media_playlist AS media_playlist
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = media_playlist.userID)
		ORDER BY media_playlist.plName ASC
	");

	while ($media = $vbulletin->db->fetch_array($medias))
	{
		$mediabits .= construct_media_bit($media,"list");
	}

	if ($perms['submit'])
	{
		$submitsmall = construct_submit_small();
	}

	$sidebar = construct_sidebar();

	$title = $vbphrase['media_playlists'];
	$description = $vbphrase['media_playlists_info'];

	$navbits[''] = $vbphrase['media_playlists'];

	$templater = vB_Template::create('8WR_media_browse_list');
		$templater->register('title', $title);
		$templater->register('description', $description);
		$templater->register('mediabits', $mediabits);
		$templater->register('submitsmall', $submitsmall);
		$templater->register('sidebar', $sidebar);
	$mediaHTML = $templater->render();
}

if ($do == "playlists_mine")
{
	$medias = $vbulletin->db->query_read("
		SELECT media_playlist.*, IF(NOT ISNULL(user.userid), user.username, media_playlist.username) AS username
		FROM " . TABLE_PREFIX . "media_playlist AS media_playlist
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = media_playlist.userID)
		WHERE media_playlist.userID = '".$vbulletin->userinfo['userid']."'
		ORDER BY media_playlist.plName ASC
	");

	while ($media = $vbulletin->db->fetch_array($medias))
	{
		$mediabits .= construct_media_bit($media,"list");
	}

	if ($perms['submit'])
	{
		$submitsmall = construct_submit_small();
	}

	$sidebar = construct_sidebar();

	$title = $vbphrase['media_playlists_mine'];
	$description = $vbphrase['media_playlists_info'];

	$navbits[construct_href_playlists()] = $vbphrase['media_playlists'];
	$navbits[''] = $vbphrase['media_playlists_mine'];

	$templater = vB_Template::create('8WR_media_browse_list');
		$templater->register('title', $title);
		$templater->register('description', $description);
		$templater->register('mediabits', $mediabits);
		$templater->register('submitsmall', $submitsmall);
		$templater->register('sidebar', $sidebar);
	$mediaHTML = $templater->render();
}

if ($do == "playlists_create")
{
	if (!$perms['playlist']) { print_no_permission(); }

	$navbits[construct_href_playlists()] = $vbphrase['media_playlists'];
	$navbits[''] = $vbphrase['media_playlists_create']; 

	$templater = vB_Template::create('8WR_media_playlist_create');
	$mediaHTML = $templater->render();
}

if ($do == "playlists_data")
{
	if (!$perms['playlist']) { print_no_permission(); }

	$vbulletin->input->clean_array_gpc('p', array(
		'plName'	=> TYPE_STR,
		'plDesc'	=> TYPE_STR,
	));

	$plName = $vbulletin->GPC['plName'];
	$plDesc = $vbulletin->GPC['plDesc'];

	$dm =& datamanager_init('Media_Playlist', $vbulletin);
	$dm->setr('plName', $plName);
	$dm->setr('plDesc', $plDesc);
	$dm->pre_save();
	$playlistID = $dm->save();

	$playlist = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media_playlist WHERE playlistID = '".$playlistID."'");

	$vbulletin->url = construct_href_playlist($playlist);
	eval(print_standard_redirect('media_playlist_created'));
}

if ($do == "playlist")
{
	if (!$playlist = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media_playlist WHERE playlistID = '".$pid."'"))
	{
		eval(standard_error(fetch_error('media_playlist_invalid')));
	}

	if ($vbulletin->userinfo['userid'] == $playlist['userID'])
	{
		$perms['edit'] = true;
	}

	if ($playlist['mediaIDs'])
	{
		$medias = $vbulletin->db->query_read("
			SELECT media.*, media_service.*, media_category.*, IF(NOT ISNULL(user.userid), user.username, media.username) AS username
			FROM " . TABLE_PREFIX . "media AS media
			LEFT JOIN " . TABLE_PREFIX . "media_service AS media_service ON(media_service.serviceID = media.serviceID)
			LEFT JOIN " . TABLE_PREFIX . "media_category AS media_category ON(media_category.categoryID = media.categoryID)
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = media.userID)
			WHERE media.mediaID IN (".$playlist['mediaIDs'].")
			ORDER BY FIELD(media.mediaID,".$playlist['mediaIDs'].")
		");

		while ($media = $vbulletin->db->fetch_array($medias))
		{
			$mediabits .= construct_media_bit($media, 'plist', $playlist);
		}
	}

	$sidebar = construct_sidebar();

	require_once(DIR . '/includes/class_bbcode.php');
	$bbcode = new vB_BbCodeParser($vbulletin, fetch_tag_list());
 	$playlist['plDesc'] = $bbcode->do_parse($playlist['plDesc']);

	$playlist['href'] = construct_href_playlist_edit($playlist);

	$title = $playlist['plName'];
	$description = $playlist['plDesc'];

	$navbits[construct_href_playlists()] = $vbphrase['media_playlists'];
	$navbits[''] = $playlist['plName'];

	$templater = vB_Template::create('8WR_media_playlist');
		$templater->register('title', $title);
		$templater->register('description', $description);
		$templater->register('playlist', $playlist);
		$templater->register('mediabits', $mediabits);
		$templater->register('perms', $perms);
		$templater->register('sidebar', $sidebar);
	$mediaHTML = $templater->render();
}

if ($do == "playlist_move")
{
	$vbulletin->input->clean_array_gpc('r', array(
		'action'		=> TYPE_STR,
	));

	$action = $vbulletin->GPC['action'];

	if (!$playlist = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media_playlist WHERE playlistID = '".$pid."'"))
	{
		eval(standard_error(fetch_error('media_playlist_invalid')));
	}

	if (($vbulletin->userinfo['userid'] != $playlist['userID']) AND !$perms['modedit'])
	{
		print_no_permission();
	}

	$playlist['mediaIDs'] = explode(',',$playlist['mediaIDs']);

	foreach ($playlist['mediaIDs'] as $key => $value)
	{
		$mediaIDs[$key*2+1] = $playlist['mediaIDs'][$key];
	}

	if ($now = array_search($mid,$mediaIDs))
	{
		switch ($action)
		{
			case "top": $mediaIDs[000000] = $mediaIDs[$now]; unset($mediaIDs[$now]); break;
			case "btm": $mediaIDs[999999] = $mediaIDs[$now]; unset($mediaIDs[$now]); break;
			case "upp": $mediaIDs[$now-3] = $mediaIDs[$now]; unset($mediaIDs[$now]); break;
			case "dwn": $mediaIDs[$now+3] = $mediaIDs[$now]; unset($mediaIDs[$now]); break;
			case "rem": unset($mediaIDs[$now]); break;
		}
		ksort($mediaIDs);
	}

	$playlist['mediaIDs'] = implode(',',$mediaIDs);

	$dm =& datamanager_init('Media_Playlist', $vbulletin);
	$dm->set_existing($playlist);
	$dm->setr('mediaIDs', $playlist['mediaIDs']);
	$dm->save();

	$vbulletin->url = construct_href_playlist($playlist);
	eval(print_standard_redirect('media_playlist_saved'));
}

if ($do == "playlist_add")
{
	$vbulletin->input->clean_array_gpc('p', array(
		'mediaurl'	=> TYPE_STR,
	));

	$mediaurl = $vbulletin->GPC['mediaurl'];

	if (!$playlist = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media_playlist WHERE playlistID = '".$pid."'"))
	{
		eval(standard_error(fetch_error('media_playlist_invalid')));
	}

	if ($vbulletin->options['media_doseo'])
	{
		preg_match('#/m(\d+)#i', $mediaurl, $matches);
	}
	else
	{
		preg_match('#&mid=(\d+)#i', $mediaurl, $matches);
	}

	if (!$media = $vbulletin->db->query_first("SELECT media.* FROM " . TABLE_PREFIX . "media AS media WHERE media.mediaID = '".$matches[1]."'"))
	{
		eval(standard_error(fetch_error('media_details_invalid')));
	}

	$playlist['mediaIDs'] = explode(',',$playlist['mediaIDs']);
	if (in_array($media['mediaID'],$playlist['mediaIDs']))
	{
		eval(standard_error(fetch_error('media_playlist_exists')));
	}

	$playlist['mediaIDs'][] = $media['mediaID'];
	if ($playlist['mediaIDs'][0] == "") { unset($playlist['mediaIDs'][0]); }

	$playlist['mediaIDs'] = implode(',',$playlist['mediaIDs']);

	$dm =& datamanager_init('Media_Playlist', $vbulletin);
	$dm->set_existing($playlist);
	$dm->setr('mediaIDs', $playlist['mediaIDs']);
	$dm->save();

	$vbulletin->url = construct_href_playlist($playlist);
	eval(print_standard_redirect('media_playlist_saved'));
}

if ($do == "playlist_edit")
{
	if (!$playlist = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media_playlist WHERE playlistID = '".$pid."'"))
	{
		eval(standard_error(fetch_error('media_playlist_invalid')));
	}

	if (($vbulletin->userinfo['userid'] != $playlist['userID']) AND !$perms['modedit'])
	{
		print_no_permission();
	}

	$navbits[construct_href_playlists()] = $vbphrase['media_playlists'];
	$navbits[construct_href_playlist($playlist)] = $playlist['plName'];
	$navbits[''] = $vbphrase['media_playlists_edit']; 

	$templater = vB_Template::create('8WR_media_playlist_edit');
		$templater->register('playlist', $playlist);
	$mediaHTML = $templater->render();
}

if ($do == "playlist_data")
{
	$vbulletin->input->clean_array_gpc('p', array(
		'plName'	=> TYPE_STR,
		'plDesc'	=> TYPE_STR,
		'action'	=> TYPE_STR,
	));

	$playlist = array('playlistID' => $pid);

	$plName = $vbulletin->GPC['plName'];
	$plDesc = $vbulletin->GPC['plDesc'];
	$action = $vbulletin->GPC['action'];

	$dm =& datamanager_init('Media_Playlist', $vbulletin);
	$dm->set_existing($playlist);

	if ($action == "delete")
	{
		$dm->delete();

		$vbulletin->url = construct_href_main();
		eval(print_standard_redirect('media_playlist_deleted'));
	}
	else
	{
		$dm->setr('plName', $plName);
		$dm->setr('plDesc', $plDesc);
		$dm->save();

		$playlist = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media_playlist WHERE playlistID = '".$pid."'");

		$vbulletin->url = construct_href_playlist($playlist);
		eval(print_standard_redirect('media_playlist_saved'));
	}
}

?>