<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (media/media_favorites.php)                  # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

if (!$perms['rate'])
{
	print_no_permission();
}

if ($do == "favorites")
{
	if ($vbulletin->userinfo['mediafaves'])
	{
		$medias = $vbulletin->db->query_read("
			SELECT media.*, media_service.*, media_category.*, IF(NOT ISNULL(user.userid), user.username, media.username) AS username
			FROM " . TABLE_PREFIX . "media AS media
			LEFT JOIN " . TABLE_PREFIX . "media_service AS media_service ON(media_service.serviceID = media.serviceID)
			LEFT JOIN " . TABLE_PREFIX . "media_category AS media_category ON(media_category.categoryID = media.categoryID)
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = media.userID)
			WHERE media.mediaID IN (".$vbulletin->userinfo['mediafaves'].")
			ORDER BY media.title ASC
		");

		while ($media = $vbulletin->db->fetch_array($medias))
		{
			$mediabits .= construct_media_bit($media,"faves");
		}
	}

	if ($perms['submit'])
	{
		$submitsmall = construct_submit_small();
	}

	$sidebar = construct_sidebar();

	$title = $vbphrase['media_favorites'];
	$description = $vbphrase['media_faves_info'];

	$navbits[''] = $vbphrase['media_favorites'];

	$templater = vB_Template::create('8WR_media_browse_faves');
		$templater->register('title', $title);
		$templater->register('description', $description);
		$templater->register('mediabits', $mediabits);
		$templater->register('submitsmall', $submitsmall);
		$templater->register('sidebar', $sidebar);
	$mediaHTML = $templater->render();
}

if ($do == "faves_save")
{
	$vbulletin->input->clean_array_gpc('p', array(
		'delete'	=> TYPE_ARRAY_UINT,
	));

	if ($delete = $vbulletin->GPC['delete'])
	{
		foreach ($delete as $key => $mediaid)
		{
			build_faves_cache($vbulletin->userinfo['userid'], $vbulletin->userinfo['mediafaves'], 0, $mediaid);
		}
	}

	$vbulletin->url = construct_href_favorites();
	eval(print_standard_redirect('media_faves_removed'));
}

if ($do == "faves_delete")
{
	$media = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media WHERE mediaID = '".$mid."'");

	build_faves_cache($vbulletin->userinfo['userid'], $vbulletin->userinfo['mediafaves'], 0, $media['mediaID']);

	$vbulletin->url = construct_href_favorites();
	eval(print_standard_redirect('media_faves_removed'));
}

if ($do == "faves_add")
{
	$media = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media WHERE mediaID = '".$mid."'");
	$playlist = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media_playlist WHERE playlistID = '".$pid."'");

	build_faves_cache($vbulletin->userinfo['userid'], $vbulletin->userinfo['mediafaves'], $media['mediaID'], 0);

	if ($ajax)
	{
		$mediafaves = construct_media_faves($media, $playlist);

		$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
		$xml->add_group('response');
		$xml->add_tag('success', $vbphrase['media_faves_added']);
		$xml->add_tag('mediafaves', $mediafaves);
		$xml->close_group();
		$xml->print_xml(true);
	}

	$vbulletin->url = construct_href_details($media, $playlist);
	eval(print_standard_redirect('media_faves_added'));
}

if ($do == "faves_rem")
{
	$media = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media WHERE mediaID = '".$mid."'");
	$playlist = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media_playlist WHERE playlistID = '".$pid."'");

	build_faves_cache($vbulletin->userinfo['userid'], $vbulletin->userinfo['mediafaves'], 0, $media['mediaID']);

	if ($ajax)
	{
		$mediafaves = construct_media_faves($media, $playlist);

		$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
		$xml->add_group('response');
		$xml->add_tag('success', $vbphrase['media_faves_removed']);
		$xml->add_tag('mediafaves', $mediafaves);
		$xml->close_group();
		$xml->print_xml(true);
	}

	$vbulletin->url = construct_href_details($media, $playlist);
	eval(print_standard_redirect('media_faves_removed'));
}

?>