/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (media/media_ajax_submit.js)                 # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

function submit_init()
{
	if (AJAX_Compatible && (typeof vb_disable_ajax == 'undefined' || vb_disable_ajax < 2))
	{
		var sbutton = document.getElementById('getxmlfeeds');
		var button = document.createElement('input');
		button.type      = 'button';
		button.className = sbutton.className;
		button.name      = sbutton.name;
		button.id        = sbutton.id;
		button.value     = sbutton.value;
		button.onclick   = function() { get_xmlfeeds(); };
		sbutton.parentNode.insertBefore(button, sbutton);
		sbutton.parentNode.removeChild(sbutton);
	}
}

function get_xmlfeeds()
{
	if (!fetch_object('source').value)
	{
		return false;
	}

	var source = fetch_object('source').value;
	source = source.replace("&","{amp}");

	YAHOO.util.Connect.asyncRequest("POST", "media_ajax.php?do=submit_feed", {
		success: send_xmlfeeds,
		failure: vBulletin_AJAX_Error_Handler,
		timeout: 15000
	}, SESSIONURL + 'securitytoken=' + SECURITYTOKEN + "&source=" + source);

	fetch_object('getxmlfeeds').value = vbphrase['retrieve_information_wait'];
	fetch_object('getxmlfeeds').disabled = true;

	return false;
}

function send_xmlfeeds(ajax)
{
	if (ajax.responseXML)
	{
		var error = ajax.responseXML.getElementsByTagName('error');
		if (error.length)
		{
			fetch_object('thumbnail').setAttribute('src', '');
			fetch_object('thumbnail_border').style.display = 'none';
			fetch_object('submitbutton').style.display = 'none';
			alert(error[0].firstChild.nodeValue);
		}
		else
		{
			try
			{
				var thumbnail = ajax.responseXML.getElementsByTagName('thumbnail')[0].firstChild.nodeValue;
				fetch_object('thumbnail').value = thumbnail;
				fetch_object('thumbnail_image').setAttribute('src', thumbnail);
				fetch_object('thumbnail_border').style.display = '';
				fetch_object('submitbutton').style.display = 'inline';
			}
			catch (e) { }

			try
			{
				var title = ajax.responseXML.getElementsByTagName('title')[0].firstChild.nodeValue;
				fetch_object('title').value = title;
			}
			catch (e) { }

			try
			{
				var description = ajax.responseXML.getElementsByTagName('description')[0].firstChild.nodeValue;
				fetch_object('vB_Editor_001_textarea').value = description;
			}
			catch (e) { }

			try
			{
				var taglist = ajax.responseXML.getElementsByTagName('taglist')[0].firstChild.nodeValue;
				fetch_object('taglist').value = taglist;
			}
			catch (e) { }

			try
			{
				var minutes = ajax.responseXML.getElementsByTagName('minutes')[0].firstChild.nodeValue;
				fetch_object('minutes').value = minutes;
			}
			catch (e) { }

			try
			{
				var seconds = ajax.responseXML.getElementsByTagName('seconds')[0].firstChild.nodeValue;
				fetch_object('seconds').value = seconds;
			}
			catch (e) { }

			try
			{
				var source = ajax.responseXML.getElementsByTagName('source')[0].firstChild.nodeValue;
				fetch_object('source').value = source;
			}
			catch (e) { }

			try
			{
				var serviceID = ajax.responseXML.getElementsByTagName('serviceID')[0].firstChild.nodeValue;
				fetch_object('serviceID').value = serviceID;
			}
			catch (e) { }

			try
			{
				var serviceVAL = ajax.responseXML.getElementsByTagName('serviceVAL')[0].firstChild.nodeValue;
				fetch_object('serviceVAL').value = serviceVAL;
			}
			catch (e) { }

			try
			{
				var serviceVAL2 = ajax.responseXML.getElementsByTagName('serviceVAL2')[0].firstChild.nodeValue;
				fetch_object('serviceVAL2').value = serviceVAL2;
			}
			catch (e) { }

			try
			{
				var embed = ajax.responseXML.getElementsByTagName('embed')[0].firstChild.nodeValue;
				fetch_object('embed').innerHTML = parseScript(embed);
			}
			catch (e) { }
		}
	}
	fetch_object('getxmlfeeds').value = vbphrase['retrieve_information'];
	fetch_object('getxmlfeeds').disabled = false;
}

function validate()
{
	var error = '';
	var category = document.getElementById('category');
	var title = document.getElementById('title');
	var length = document.getElementById('minutes').value + document.getElementById('seconds').value;
	var message = document.getElementById('vB_Editor_001_textarea');
	var taglist = document.getElementById('taglist');

	if (!category.value.length) { error += vbphrase['media_validate_category'] + '\n'; }
	if (!title.value.length) { error += vbphrase['media_validate_title'] + '\n'; }
	if (length == 0) { error += vbphrase['media_validate_length'] + '\n'; }
	if (!message.value.length) { error += vbphrase['media_validate_desc'] + '\n'; }
	if (!taglist.value.length) { error += vbphrase['media_validate_tags'] + '\n'; }

	if (error.length)
	{
		alert(error);
		return false;
	}
	else
	{
		return true;
	}
}

function parseScript(_source)
{
	var source = _source;
	var scripts = new Array();

	// Strip out tags
	while(source.indexOf("<script") > -1 || source.indexOf("</script") > -1) {
		var s = source.indexOf("<script");
		var s_e = source.indexOf(">", s);
		var e = source.indexOf("</script", s);
		var e_e = source.indexOf(">", e);

		// Add to scripts array
		scripts.push(source.substring(s_e+1, e));
		// Strip from source
		source = source.substring(0, s) + source.substring(e_e+1);
	}

	// Loop through every script collected and eval it
	for(var i=0; i<scripts.length; i++) {
		try {
			eval(scripts[i]);
		}
		catch(ex) {
			// do what you want here when a script fails
		}
	}

	// Return the cleaned source
	return source;
}