<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (media.php)                                  # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ##########################

error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS ######################

define('THIS_SCRIPT', '8WR_media');
define('CSRF_PROTECTION', true);
define('GET_EDIT_TEMPLATES', true);

// #################### PRE-CACHE TEMPLATES AND DATA #####################

$phrasegroups = array(
	'8WR_media',
	'posting',
);
$globaltemplates = array(
	'8WR_media_NAVTAB',
	'8WR_media_NAVTAB_cat',
	'8WR_media_NAVTAB_sub',
	'8WR_media_SHELL',
);
$specialtemplates = array(
	'smiliecache',
	'bbcodecache',
);
$actiontemplates = array(
	'main' => array(
		'8WR_media_SIDEBAR',
		'8WR_media_SIDEBAR_cat',
		'8WR_media_SIDEBAR_user',
		'8WR_media_bit_large',
		'8WR_media_bit_small',
		'8WR_media_bit_tiny',
		'8WR_media_bit_table',
		'8WR_media_tag_bit',
		'8WR_media_main',
		'8WR_media_tag_cloud',
		'8WR_media_tag_cloud_bit',
		'8WR_media_submit_small',
	),
	'playlists' => array(
		'8WR_media_SIDEBAR',
		'8WR_media_SIDEBAR_cat',
		'8WR_media_SIDEBAR_user',
		'8WR_media_bit_list',
		'8WR_media_browse_list',
		'8WR_media_submit_small',
	),
	'playlists_mine' => array(
		'8WR_media_SIDEBAR',
		'8WR_media_SIDEBAR_cat',
		'8WR_media_SIDEBAR_user',
		'8WR_media_bit_list',
		'8WR_media_browse_list',
		'8WR_media_submit_small',
	),
	'playlists_create' => array(
		'8WR_media_playlist_create',
	),
	'favorites' => array(
		'8WR_media_SIDEBAR',
		'8WR_media_SIDEBAR_cat',
		'8WR_media_SIDEBAR_user',
		'8WR_media_bit_faves',
		'8WR_media_browse_faves',
		'8WR_media_submit_small',
	),
	'subscriptions' => array(
		'8WR_media_SIDEBAR',
		'8WR_media_SIDEBAR_cat',
		'8WR_media_SIDEBAR_user',
		'8WR_media_bit_subs',
		'8WR_media_browse_subs',
		'8WR_media_submit_small',
	),
	'details' => array(
		'8WR_media_details',
		'8WR_media_details_faves',
		'8WR_media_details_subs',
		'8WR_media_details_rate',
		'8WR_media_embed',
		'8WR_media_embed_stream',
		'8WR_media_tag_bit',
		'8WR_media_comment_bit',
		'showthread_quickreply',
	),
	'details_edit' => array(
		'8WR_media_details_edit',
	),
	'comment_edit' => array(
		'8WR_media_comment',
	),
	'browse' => array(
		'8WR_media_SIDEBAR',
		'8WR_media_SIDEBAR_cat',
		'8WR_media_SIDEBAR_user',
		'8WR_media_bit_large',
		'8WR_media_bit_small',
		'8WR_media_bit_tiny',
		'8WR_media_bit_table',
		'8WR_media_tag_bit',
		'8WR_media_browse',
		'8WR_media_submit_small',
	),
	'playlist' => array(
		'8WR_media_SIDEBAR',
		'8WR_media_SIDEBAR_cat',
		'8WR_media_SIDEBAR_user',
		'8WR_media_bit_plist',
		'8WR_media_playlist',
	),
	'playlist_edit' => array(
		'8WR_media_playlist_edit',
	),
	'category' => array(
		'8WR_media_SIDEBAR',
		'8WR_media_SIDEBAR_cat',
		'8WR_media_SIDEBAR_user',
		'8WR_media_bit_large',
		'8WR_media_bit_small',
		'8WR_media_bit_tiny',
		'8WR_media_bit_table',
		'8WR_media_tag_bit',
		'8WR_media_browse',
		'8WR_media_submit_small',
	),
	'user' => array(
		'8WR_media_SIDEBAR',
		'8WR_media_SIDEBAR_cat',
		'8WR_media_SIDEBAR_user',
		'8WR_media_bit_large',
		'8WR_media_bit_small',
		'8WR_media_bit_tiny',
		'8WR_media_bit_table',
		'8WR_media_tag_bit',
		'8WR_media_browse',
		'8WR_media_submit_small',
	),
	'tag' => array(
		'8WR_media_SIDEBAR',
		'8WR_media_SIDEBAR_cat',
		'8WR_media_SIDEBAR_user',
		'8WR_media_bit_large',
		'8WR_media_bit_small',
		'8WR_media_bit_tiny',
		'8WR_media_bit_table',
		'8WR_media_tag_bit',
		'8WR_media_browse',
		'8WR_media_submit_small',
	),
	'search' => array(
		'8WR_media_search',
	),
	'results' => array(
		'8WR_media_SIDEBAR',
		'8WR_media_SIDEBAR_cat',
		'8WR_media_SIDEBAR_user',
		'8WR_media_bit_large',
		'8WR_media_bit_small',
		'8WR_media_bit_tiny',
		'8WR_media_bit_table',
		'8WR_media_tag_bit',
		'8WR_media_browse',
		'8WR_media_submit_small',
	),
	'advresults' => array(
		'8WR_media_SIDEBAR',
		'8WR_media_SIDEBAR_cat',
		'8WR_media_SIDEBAR_user',
		'8WR_media_bit_large',
		'8WR_media_bit_small',
		'8WR_media_bit_tiny',
		'8WR_media_bit_table',
		'8WR_media_tag_bit',
		'8WR_media_browse',
		'8WR_media_submit_small',
	),
	'letter' => array(
		'8WR_media_SIDEBAR',
		'8WR_media_SIDEBAR_cat',
		'8WR_media_SIDEBAR_user',
		'8WR_media_bit_large',
		'8WR_media_bit_small',
		'8WR_media_bit_tiny',
		'8WR_media_bit_table',
		'8WR_media_tag_bit',
		'8WR_media_browse',
		'8WR_media_submit_small',
	),
	'tagcloud' => array(
		'8WR_media_tag_cloud',
		'8WR_media_tag_cloud_bit',
	),
	'tags_edit' => array(
		'8WR_media_tags_edit',
		'8WR_media_tags_bit',
	),
	'report' => array(
		'8WR_media_report',
	),
	'submit' => array(
		'8WR_media_submit',
		'8WR_media_embed',
	),
	'admin_cats' => array(
		'8WR_media_admin_cats',
		'8WR_media_admin_cats_bit',
	),
	'admin_tags' => array(
		'8WR_media_admin_tags',
		'8WR_media_admin_tags_bit',
	),
	'admin_host' => array(
		'8WR_media_admin_host',
		'8WR_media_admin_host_bit',
	),
	'admin_host_edit' => array(
		'8WR_media_admin_host_edit',
	),
	'admin_host_delete' => array(
		'8WR_media_admin_host_delete',
		'8WR_media_admin_host_delete_bit',
	),
);

$actiontemplates['none'] =& $actiontemplates['main'];
$actiontemplates['random'] =& $actiontemplates['details'];

// ########################## REQUIRE BACK-END ###########################

require_once('./global.php');
require_once(DIR.'/media/media_functions_builds.php');
require_once(DIR.'/media/media_functions_constructs.php');
require_once(DIR.'/media/media_functions_hrefs.php');
require_once(DIR.'/media/media_functions_perms.php');

// #######################################################################
// ######################### START MAIN SCRIPT ###########################
// #######################################################################

$perms = media_permissions();

if (!$perms['view'])
{
	print_no_permission();
}

$vbulletin->input->clean_array_gpc('r', array(
	'do'			=> TYPE_STR,
	'sid'			=> TYPE_UINT,
	'mid'			=> TYPE_UINT,
	'cmt'			=> TYPE_UINT,
	'pid'			=> TYPE_UINT,
	'cid'			=> TYPE_UINT,
	'uid'			=> TYPE_UINT,
	'tid'			=> TYPE_STR,
	'sort'			=> TYPE_STR,
	'perpage'		=> TYPE_UINT,
	'pagenumber'	=> TYPE_UINT,
));

$do = $vbulletin->GPC['do'];
$sid = $vbulletin->GPC['sid'];
$mid = $vbulletin->GPC['mid'];
$cmt = $vbulletin->GPC['cmt'];
$pid = $vbulletin->GPC['pid'];
$cid = $vbulletin->GPC['cid'];
$uid = $vbulletin->GPC['uid'];
$tid = $vbulletin->GPC['tid'];
$tid = addslashes(strtolower(trim($tid)));
$sort = $vbulletin->GPC['sort'];

if ($do == "random")
{
	$random = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media AS media ORDER BY RAND() LIMIT 1");
	$do = "details";
	$mid = $random['mediaID'];
}

$navbits = array();
$navbits[construct_href_main()] = $vbphrase['media_library'];

switch ($sort)
{
	case "rating":		$sortQuery = 'media.rating DESC, media.ratingCount DESC,';	break;
	case "favorites":	$sortQuery = 'media.favorites DESC,';						break;
	case "comments":	$sortQuery = 'media.comments DESC,';						break;
	case "views":		$sortQuery = 'media.views DESC,';							break;
	default:			$sort = dateline;
}

switch ($do)
{
	case "rss":
	case "sitemap":
		require_once(DIR.'/media/media_rss.php');			break;
	case "favorites":
	case "faves_save":
	case "faves_delete":
	case "faves_add":
	case "faves_rem":
		require_once(DIR.'/media/media_favorites.php');		break;
	case "subscriptions":
	case "subs_save":
	case "subs_delete":
	case "subs_add":
	case "subs_rem":
		require_once(DIR.'/media/media_subscriptions.php');	break;
	case "playlists":
	case "playlists_mine":
	case "playlists_create":
	case "playlists_data":
	case "playlist":
	case "playlist_move":
	case "playlist_add":
	case "playlist_rem":
	case "playlist_edit":
	case "playlist_data":
		require_once(DIR.'/media/media_playlist.php');		break;
	case "details":
	case "details_edit":
	case "details_thumb":
	case "details_data":
		require_once(DIR.'/media/media_details.php');		break;
	case "rating":
		require_once(DIR.'/media/media_rating.php');		break;
	case "comment":
	case "comment_edit":
	case "comment_data":
		require_once(DIR.'/media/media_comment.php');		break;
	case "search":
	case "results":
	case "advresults":
	case "letter":
		require_once(DIR.'/media/media_search.php');		break;
	case "browse":
		require_once(DIR.'/media/media_browse.php');		break;
	case "category":
		require_once(DIR.'/media/media_category.php');		break;
	case "user":
		require_once(DIR.'/media/media_user.php');			break;
	case "tag":
	case "tagcloud":
	case "tags_edit":
	case "tags_data":
		require_once(DIR.'/media/media_tag.php');			break;
	case "report":
	case "report_send":
		require_once(DIR.'/media/media_report.php');		break;
	case "submit":
	case "submit_data":
		require_once(DIR.'/media/media_submit.php');		break;
	case "admin_cats":
	case "admin_cats_edit":
	case "admin_cats_data":
	case "admin_tags":
	case "admin_tags_edit":
	case "admin_tags_data":
	case "admin_host":
	case "admin_host_edit":
	case "admin_host_data":
	case "admin_host_delete":
	case "admin_host_kill":
	case "admin_host_export":
	case "admin_host_import":
	case "admin_host_restore":
		require_once(DIR.'/media/media_admin.php');			break;
	case "main":
	default:	$do = "main";
		require_once(DIR.'/media/media_main.php');
}

$navbits = construct_navbits($navbits);
$navbar = render_navbar_template($navbits);

$templater = vB_Template::create('8WR_media_SHELL');
	$templater->register('mediaHTML', $mediaHTML);
	$templater->register('perms', $perms);
	$templater->register('navbar', $navbar);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('description', $description);
	$templater->register('editorjs', $editorjs);

	switch ($do)
	{
		case "category":	$templater->register('cat', $category);		break;
		case "user":		$templater->register('usr', $user);			break;
		case "tag":			$templater->register('tag', $tag);			break;
	}

	$templater->register_page_templates();
print_output($templater->render());

?>