<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (includes/class_dm_media_service.php)        # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager')) { exit; }  

class vB_DataManager_Media_Service extends vB_DataManager
{
	var $validfields = array(
		'serviceID'	=> array(TYPE_UINT,	REQ_INCR),
		'svcName'	=> array(TYPE_STR,	REQ_YES,	VF_METHOD),
		'svcRegex'	=> array(TYPE_STR,	REQ_YES),
		'svcURL'	=> array(TYPE_STR,	REQ_YES),
		'svcFeed'	=> array(TYPE_STR,	REQ_YES),
		'svcValue2'	=> array(TYPE_STR,	REQ_YES),
		'svcThumb'	=> array(TYPE_STR,	REQ_YES),
		'svcTitle'	=> array(TYPE_STR,	REQ_YES),
		'svcDesc'	=> array(TYPE_STR,	REQ_YES),
		'svcLength'	=> array(TYPE_STR,	REQ_YES),
		'svcTags'	=> array(TYPE_STR,	REQ_YES),
		'svcMovie'	=> array(TYPE_STR,	REQ_YES),
		'svcWidth'	=> array(TYPE_UINT,	REQ_YES),
		'svcHeight'	=> array(TYPE_UINT,	REQ_YES),
		'svcStream'	=> array(TYPE_STR,	REQ_YES),
		'svcError'	=> array(TYPE_STR,	REQ_YES),
		'svcParams'	=> array(TYPE_STR,	REQ_YES),
	);

	var $table = 'media_service';
	var $condition_construct = array('serviceID = %1$d', 'serviceID');

	function vB_DataManager_Media_Service(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);
	}

	function verify_svcName(&$svcName)
	{
		$svcName = trim(strip_tags($svcName));

		if ($this->registry->options['titlemaxchars'] && (vbstrlen($svcName) > $this->registry->options['titlemaxchars']))
		{
			$this->error('media_service_long', vbstrlen($svcName), $this->registry->options['titlemaxchars']);
			return false;
		}

		if (vbstrlen($svcName) < 3)
		{
			$this->error('media_service_short', vbstrlen($svcName), 3);
			return false;
		}

		return true;
	}
}

?>