<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (includes/class_dm_media_tag_content.php)    # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager')) { exit; }  

class vB_DataManager_Media_Playlist extends vB_DataManager
{
	var $validfields = array(
		'playlistID'	=> array(TYPE_UINT,	REQ_INCR),
		'userID'		=> array(TYPE_UINT,	REQ_YES),
		'username'		=> array(TYPE_STR,	REQ_YES),
		'mediaIDs'		=> array(TYPE_STR,	REQ_NO),
		'plName'		=> array(TYPE_STR,	REQ_YES,	VF_METHOD),
		'plDesc'		=> array(TYPE_STR,	REQ_YES,	VF_METHOD),
	);

	var $table = 'media_playlist';
	var $condition_construct = array('playlistID = %1$d', 'playlistID');

	function vB_DataManager_Media_Playlist(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);
	}

	function verify_plName(&$plName)
	{
		$plName = trim(strip_tags($plName));

		if ($this->registry->options['titlemaxchars'] && (vbstrlen($plName) > $this->registry->options['titlemaxchars']))
		{
			$this->error('media_category_long', vbstrlen($plName), $this->registry->options['titlemaxchars']);
			return false;
		}

		if (vbstrlen($plName) < 5)
		{
			$this->error('media_category_short', vbstrlen($plName), 5);
			return false;
		}

		return true;
	}

	function verify_plDesc(&$plDesc)
	{
		$plDesc = trim(strip_tags($plDesc));

		return true;
	}

	function pre_save($doquery = true)
	{
		if (!$this->condition)
		{
			$this->set('userID', $this->registry->userinfo['userid']);
			$this->set('username', $this->registry->userinfo['username']);
		}

		return parent::pre_save($doquery);
	}
}

?>