<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (includes/class_dm_media.php)                # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager')) { exit; }  

class vB_DataManager_Media extends vB_DataManager
{
	var $validfields = array(
		'mediaID'		=> array(TYPE_UINT,	REQ_INCR),
		'categoryID'	=> array(TYPE_UINT,	REQ_YES,	VF_METHOD),
		'userID'		=> array(TYPE_UINT,	REQ_YES),
		'serviceID'		=> array(TYPE_UINT,	REQ_YES),
		'serviceVAL'	=> array(TYPE_STR,	REQ_YES,	VF_METHOD),
		'serviceVAL2'	=> array(TYPE_STR,	REQ_YES),
		'username'		=> array(TYPE_STR,	REQ_YES),
		'title'			=> array(TYPE_STR,	REQ_YES,	VF_METHOD),
		'description'	=> array(TYPE_STR,	REQ_YES,	VF_METHOD),
		'length'		=> array(TYPE_UINT,	REQ_YES),
		'dateline'		=> array(TYPE_UINT,	REQ_YES),
		'favorites'		=> array(TYPE_UINT,	REQ_NO),
		'views'			=> array(TYPE_UINT,	REQ_NO),
		'comments'		=> array(TYPE_UINT,	REQ_NO),
		'ratingTotal'	=> array(TYPE_UINT,	REQ_NO),
		'ratingCount'	=> array(TYPE_UINT,	REQ_NO),
		'rating'		=> array(TYPE_NUM,	REQ_NO),
		'state'			=> array(TYPE_STR,	REQ_YES),
		'tagcache'		=> array(TYPE_STR,	REQ_NO),
		'subscriptions'	=> array(TYPE_STR,	REQ_YES),
		'custom1'		=> array(TYPE_STR,	REQ_NO,		VF_METHOD,	'verify_custom'),
		'custom2'		=> array(TYPE_STR,	REQ_NO,		VF_METHOD,	'verify_custom'),
		'custom3'		=> array(TYPE_STR,	REQ_NO,		VF_METHOD,	'verify_custom'),
		'custom4'		=> array(TYPE_STR,	REQ_NO,		VF_METHOD,	'verify_custom'),
		'custom5'		=> array(TYPE_STR,	REQ_NO,		VF_METHOD,	'verify_custom'),
		'custom6'		=> array(TYPE_STR,	REQ_NO,		VF_METHOD,	'verify_custom'),
		'custom7'		=> array(TYPE_STR,	REQ_NO,		VF_METHOD,	'verify_custom'),
		'custom8'		=> array(TYPE_STR,	REQ_NO,		VF_METHOD,	'verify_custom'),
		'custom9'		=> array(TYPE_STR,	REQ_NO,		VF_METHOD,	'verify_custom'),
	);

	var $table = 'media';
	var $condition_construct = array('mediaID = %1$d', 'mediaID');

	function vB_DataManager_Media(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);
	}

	function verify_categoryID($categoryID)
	{
		global $vbulletin;

		if (!$category = $vbulletin->db->query_first("SELECT * FROM ".TABLE_PREFIX."media_category WHERE categoryID = '".$categoryID."'"))
		{
			$this->error('media_details_category');
			return false;
		}

		return true;
	}

	function verify_serviceVAL($serviceVAL)
	{
		$serviceID = $this->fetch_field('serviceID');

		if ($media = $this->dbobject->query_first("
			SELECT * FROM " . TABLE_PREFIX . "media AS media
			WHERE serviceVAL = '" . $serviceVAL . "'
				AND serviceID = '" . $serviceID . "'
		"))
		{
			$this->error('media_details_exists');
			return false;
		}

		return true;
	}

	function verify_title(&$title)
	{
		$title = trim(strip_tags($title));

		if ($this->registry->options['titlemaxchars'] && (vbstrlen($title) > $this->registry->options['titlemaxchars']))
		{
			$this->error('media_title_long', vbstrlen($title), $this->registry->options['titlemaxchars']);
			return false;
		}

		if (vbstrlen($title) < 5)
		{
			$this->error('media_title_short', vbstrlen($title), 5);
			return false;
		}

		return true;
	}

	function verify_description(&$desc)
	{
		require_once(DIR . '/includes/functions_newpost.php');

		$desc = trim(strip_tags($desc));
		$desc = preg_replace('/&#(0*32|x0*20);/', ' ', $desc);
		$desc = preg_replace('#\[color=(&quot;|"|\'|)([a-f0-9]{6})\\1]#i', '[color=\1#\2\1]', $desc);
		$desc = preg_replace('#\[/(left|center|right)]((\r\n|\r|\n)*)\[\\1]#si', '\\2', $desc);
		$desc = convert_url_to_bbcode($desc);

		if ($this->registry->options['postmaxchars'] && (vbstrlen($desc) > $this->registry->options['postmaxchars']))
		{
			$this->error('media_desc_long', vbstrlen($desc), $this->registry->options['postmaxchars']);
			return false;
		}

		if ($this->registry->options['postminchars'] && (vbstrlen($desc) < $this->registry->options['postminchars']))
		{
			$this->error('media_desc_short', vbstrlen($desc), $this->registry->options['postminchars']);
			return false;
		}

		return true;
	}

	function verify_custom(&$custom)
	{
		$custom = trim(strip_tags($custom));
		return true;
	}

	function pre_save($doquery = true)
	{
		if (!$this->condition)
		{
			$this->set('dateline', TIMENOW);
			$this->set('subscriptions', $this->registry->userinfo['userid']);
			$this->set('userID', $this->registry->userinfo['userid']);
			$this->set('username', $this->registry->userinfo['username']);
		}

		return parent::pre_save($doquery);
	}
}

?>