<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (media/media_tag.php)                        # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

if ($do == "tag")
{
	if (!$tag = $vbulletin->db->query_first("
		SELECT media_tag.*, COUNT(media_tag_content.mediaID) AS count
		FROM " . TABLE_PREFIX . "media_tag AS media_tag
		LEFT JOIN " . TABLE_PREFIX . "media_tag_content AS media_tag_content ON(media_tag_content.tagID = media_tag.tagID)
		WHERE media_tag.tagText = '".$tid."'
		GROUP BY media_tag.tagText
	"))
	{
		eval(standard_error(fetch_error('media_tag_invalid')));
	}

	if (!$tag['count'])
	{
		eval(standard_error(fetch_error('media_tag_empty')));
	}

	sanitize_pageresults($tag['count'], $pagenumber, $perpage, 30, $vbulletin->options['media_limit_medias']);

	if ($vbulletin->GPC['pagenumber'] < 1)
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}
	else if ($vbulletin->GPC['pagenumber'] > ceil(($tag['count'] + 1) / $perpage))
	{
		$vbulletin->GPC['pagenumber'] = ceil(($tag['count'] + 1) / $perpage);
	}

	$pagenav = construct_page_nav($vbulletin->GPC['pagenumber'], $perpage, $tag['count'], construct_href_tag($tag, $sort)); 

	$limitlower = ($vbulletin->GPC['pagenumber'] - 1) * $perpage;
	$limitupper = ($vbulletin->GPC['pagenumber']) * $perpage;

	$medias = $vbulletin->db->query_read("
		SELECT media.*, media_service.*, media_category.*, IF(NOT ISNULL(user.userid), user.username, media.username) AS username
		FROM " . TABLE_PREFIX . "media AS media
		LEFT JOIN " . TABLE_PREFIX . "media_service AS media_service ON(media_service.serviceID = media.serviceID)
		LEFT JOIN " . TABLE_PREFIX . "media_category AS media_category ON(media_category.categoryID = media.categoryID)
		LEFT JOIN " . TABLE_PREFIX . "media_tag_content AS media_tag_content ON(media_tag_content.mediaID = media.mediaID)
		LEFT JOIN " . TABLE_PREFIX . "media_tag AS media_tag ON(media_tag.tagID = media_tag_content.tagID)
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = media.userID)
		WHERE media_tag.tagText = '".$tid."'
		ORDER BY ".$sortQuery." media.dateline DESC
		LIMIT $limitlower, $perpage
	");

	while ($media = $vbulletin->db->fetch_array($medias))
	{
		$mediabits .= construct_media_bit($media, $vbulletin->options['media_select_bit']);
	}

	if ($perms['submit'])
	{
		$submitsmall = construct_submit_small();
	}

	$sidebar = construct_sidebar();

	$href['sort'] = $sort;
	$href['dateline'] = construct_href_tag($tag, 'dateline');
	$href['rating'] = construct_href_tag($tag, 'rating');
	$href['favorites'] = construct_href_tag($tag, 'favorites');
	$href['comments'] = construct_href_tag($tag, 'comments');
	$href['views'] = construct_href_tag($tag, 'views');

	$title = $vbphrase['media_tag'] . ": " . $tag['tagText'];
	$description = construct_phrase($vbphrase['media_tag_info'],  $tag['tagText']);

	$navbits[''] = $vbphrase['media_tag'] . ": " . $tag['tagText'];

	$templater = vB_Template::create('8WR_media_browse');
		$templater->register('title', $title);
		$templater->register('description', $description);
		$templater->register('tag', $tag);
		$templater->register('mediabits', $mediabits);
		$templater->register('href', $href);
		$templater->register('submitsmall', $submitsmall);
		$templater->register('pagenav', $pagenav);
		$templater->register('pagenumber', $pagenumber);
		$templater->register('perpage', $perpage);
		$templater->register('sidebar', $sidebar);
	$mediaHTML = $templater->render();
}

if ($do == "tagcloud")
{
	$navbits[''] = $vbphrase['media_tag_cloud'];

	$mediaHTML = construct_tag_cloud(99999, 6);
}

if ($do == "tags_edit")
{
	$tags = $vbulletin->db->query_read("
		SELECT media_tag_content.*, media_tag.tagText, user.username
		FROM " . TABLE_PREFIX . "media_tag_content AS media_tag_content
		LEFT JOIN " . TABLE_PREFIX . "media_tag AS media_tag ON(media_tag.tagID = media_tag_content.tagID)
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = media_tag_content.userid)
		WHERE media_tag_content.mediaID = '".$mid."'
	");

	$media = $vbulletin->db->query_first("SELECT * FROM ".TABLE_PREFIX."media WHERE mediaID = '".$mid."'");

	if (($vbulletin->userinfo['userid'] != $media['userID']) AND !$perms['modedit'])
	{
		print_no_permission();
	}
	
	while ($tag = $db->fetch_array($tags))
	{
		$tag['ismine'] = ($tag['userID'] == $vbulletin->userinfo['userid']);
		$show['tag_checkbox'] = ($tag['ismine'] OR $perms['modedit']);

		$templater = vB_Template::create('8WR_media_tags_bit');
			$templater->register('tag', $tag);
		$tag_manage_options .= $templater->render();
	}
	
	$navbits[construct_href_category($media)] = $media['catName'];
	$navbits[construct_href_details($media)] = $media['title'];
	$navbits[''] = $vbphrase['media_tags_edit'];
	
	$templater = vB_Template::create('8WR_media_tags_edit');
		$templater->register('mid', $mid);
		$templater->register('tag_manage_options', $tag_manage_options);
	$mediaHTML = $templater->render();
}

if ($do == "tags_data")
{
	$vbulletin->input->clean_array_gpc('p', array(
		'tagskept'  => TYPE_ARRAY_UINT,
		'tagsshown' => TYPE_ARRAY_UINT,
		'taglist'   => TYPE_NOHTML,
	));

	$tagskept = $vbulletin->GPC['tagskept'];
	$tagsshown = $vbulletin->GPC['tagsshown'];
	$taglist = $vbulletin->GPC['taglist'];
	
	if ($ajax)
	{
		$taglist = convert_urlencoded_unicode($taglist);
	}
	
	if ($tagsshown)
	{
		$tags_sql = $vbulletin->db->query_read("
			SELECT media_tag.*, media_tag_content.userID
			FROM " . TABLE_PREFIX . "media_tag_content AS media_tag_content
			INNER JOIN " . TABLE_PREFIX . "media_tag AS media_tag ON (media_tag.tagID = media_tag_content.tagID)
			WHERE media_tag_content.mediaID = '".$mid."'
				AND media_tag_content.tagID IN (" . implode(',', $tagsshown) . ")
		");

		$delete = array();
		while ($tag = $db->fetch_array($tags_sql))
		{
			if (!in_array($tag['tagID'], $tagskept))
			{
				$delete[] = $tag['tagID'];
			}
		}

		if ($delete)
		{
			$vbulletin->db->query_write("
				DELETE FROM " . TABLE_PREFIX . "media_tag_content
				WHERE mediaID = '".$mid."' AND
					tagID IN (" . implode(',', $delete) . ")
			");
		}
	}
	
	if ($taglist)
	{
		build_tags($taglist);
		build_tags_content($taglist,$mid);
	}

	build_tags_cache($mid);

	$media = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media WHERE mediaID = '".$mid."'");

	$vbulletin->url = construct_href_details($media);
	eval(print_standard_redirect('media_tags_saved'));
}

?>