<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (media/media_main.php)                       # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

if ($do == "main")
{
	if ($vbulletin->options['media_limit_recent'])
	{
		$recent_medias = $vbulletin->db->query_read("
			SELECT media.*, media_service.*, media_category.*, IF(NOT ISNULL(user.userid), user.username, media.username) AS username
			FROM " . TABLE_PREFIX . "media AS media
			LEFT JOIN " . TABLE_PREFIX . "media_service AS media_service ON(media_service.serviceID = media.serviceID)
			LEFT JOIN " . TABLE_PREFIX . "media_category AS media_category ON(media_category.categoryID = media.categoryID)
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = media.userID)
			WHERE media_category.catOrder != '0'
			ORDER BY media.dateline DESC
			LIMIT ".$vbulletin->options['media_limit_recent']."
		");

		while ($recent_media = $vbulletin->db->fetch_array($recent_medias))
		{
			$recentbits .= construct_media_bit($recent_media, $vbulletin->options['media_select_bit']);
		}
	}

	if ($vbulletin->options['media_limit_rated'])
	{
		$rated_medias = $vbulletin->db->query_read("
			SELECT media.*, media_service.*, media_category.*, IF(NOT ISNULL(user.userid), user.username, media.username) AS username
			FROM " . TABLE_PREFIX . "media AS media
			LEFT JOIN " . TABLE_PREFIX . "media_service AS media_service ON(media_service.serviceID = media.serviceID)
			LEFT JOIN " . TABLE_PREFIX . "media_category AS media_category ON(media_category.categoryID = media.categoryID)
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = media.userID)
			WHERE media_category.catOrder != '0'
			ORDER BY media.rating DESC, media.ratingCount DESC, media.dateline DESC
			LIMIT ".$vbulletin->options['media_limit_rated']."
		");

		while ($rated_media = $vbulletin->db->fetch_array($rated_medias))
		{
			$ratedbits .= construct_media_bit($rated_media, $vbulletin->options['media_select_bit']);
		}
	}

	if ($vbulletin->options['media_limit_popular'])
	{
		$popular_medias = $vbulletin->db->query_read("
			SELECT media.*, media_service.*, media_category.*, IF(NOT ISNULL(user.userid), user.username, media.username) AS username
			FROM " . TABLE_PREFIX . "media AS media
			LEFT JOIN " . TABLE_PREFIX . "media_service AS media_service ON(media_service.serviceID = media.serviceID)
			LEFT JOIN " . TABLE_PREFIX . "media_category AS media_category ON(media_category.categoryID = media.categoryID)
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = media.userID)
			WHERE media_category.catOrder != '0'
			ORDER BY media.favorites DESC, media.comments DESC, media.views DESC
			LIMIT ".$vbulletin->options['media_limit_popular']."
		");

		while ($popular_media = $vbulletin->db->fetch_array($popular_medias))
		{
			$popularbits .= construct_media_bit($popular_media, $vbulletin->options['media_select_bit']);
		}
	}

	if ($vbulletin->options['media_limit_cloud'])
	{
		$tagcloud = construct_tag_cloud();
	}

	if ($perms['submit'])
	{
		$submitsmall = construct_submit_small();
	}

	$sidebar = construct_sidebar();

	$templater = vB_Template::create('8WR_media_main');
		$templater->register('recentbits', $recentbits);
		$templater->register('ratedbits', $ratedbits);
		$templater->register('popularbits', $popularbits);
		$templater->register('submitsmall', $submitsmall);
		$templater->register('tagcloud', $tagcloud);
		$templater->register('sidebar', $sidebar);
	$mediaHTML = $templater->render();
}

?>