<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (media/media_functions_constructs.php)       # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

function construct_feed_data($source)
{
	global $vbulletin;
	require_once(DIR.'/includes/class_xml.php');
	require_once(DIR.'/includes/class_vurl.php');
	$source = str_replace('{amp}', '&', $source);

	$services = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "media_service");

	while ($service = $vbulletin->db->fetch_array($services))
	{
		if (preg_match('#'.$service['svcRegex'].'#i', $source, $matches))
		{
			if (strpos($service['svcName'],"ocal-"))
			{
				if (!file_exists(DIR."/".$vbulletin->options['media_thumb_dir']."/".$matches[1])) { break; }
			}

			$found = true; break;
		}
	}

	if (!$found) { eval(standard_error(fetch_error('media_submit_parse'))); }
	if ($service['svcFeed'] == "null") { $service['svcFeed'] = $vbulletin->options['bburl']."/media/index.html"; }

	$service['serviceID'] = $service['serviceID'];
	$service['serviceVAL'] = $matches[1];
	$service['source'] = str_replace('{serviceVAL}', $service['serviceVAL'], $service['svcURL']);
	$service['feed'] = str_replace('{serviceVAL}', $service['serviceVAL'], $service['svcFeed']);

	$vurl = new vB_vURL($vbulletin);
	$vurl->set_option(VURL_URL, $service['feed']);
	$vurl->set_option(VURL_RETURNTRANSFER, 1);
	$vurl->set_option(VURL_FOLLOWLOCATION, 1);
	$vurl->set_option(VURL_TIMEOUT, 30);
	$result = $vurl->exec();

	$xmlobj = new vB_XML_Parser($result);
	$arr = $xmlobj->parse('UTF-8');

	eval("\$err = $service[svcError];");
	if ($err) { eval(standard_error($err)); }

	preg_match_all('#<meta[\s]+(name|property)=["\']([^"\']*)["\'][\s]+content=["\']([^"\']*)["\']#i',$result,$matches);
	foreach ($matches[2] as $key => $value) { $meta[$value] = $matches[3][$key]; }
	preg_match_all('#<link[\s]+rel=["\']([^"\']*)["\'][\s]+(href|src)=["\']([^"\']*)["\']#i',$result,$matches);
	foreach ($matches[1] as $key => $value) { $link[$value] = $matches[3][$key]; }
	preg_match('#<title>(.*)</title>#i',$result,$matches);
	$head['title'] = $matches[1];

	eval("\$sv2 = $service[svcValue2];");
	eval("\$thu = $service[svcThumb];");
	eval("\$tit = $service[svcTitle];");
	eval("\$des = $service[svcDesc];");
	eval("\$len = $service[svcLength];");
	eval("\$tag = $service[svcTags];");

	if (!$thu) { eval(standard_error(fetch_error('media_submit_invalid'))); }

	$service['serviceVAL2'] = $sv2;
	$service['thumbnail'] = $thu;
	$service['title'] = $tit;
	$service['description'] = $des;
	$service['length'] = $len;
	$service['taglist'] = $tag;

	if ($service['length'] == 0)
	{
		$service['minutes'] = "0";
		$service['seconds'] = "00";
	}
	else
	{
		$service['minutes'] = floor($service['length'] / 60);
		$service['seconds'] = $service['length'] % 60;
		$service['seconds'] = str_pad($service['seconds'], 2, "0", STR_PAD_LEFT);
	}

	$templater = vB_Template::create('8WR_media_embed');
		$templater->register('media', $service);
	$service['embed'] = $templater->render();

	$service['embed'] = str_replace('{serviceVAL}', $service['serviceVAL'], $service['embed']);
	$service['embed'] = str_replace('{serviceVAL2}', $service['serviceVAL2'], $service['embed']);
	$service['embed'] = str_replace('{bburl}', $vbulletin->options['bburl'], $service['embed']);
	$service['embed'] = str_replace('{local}', $vbulletin->options['bburl']."/".$vbulletin->options['media_thumb_dir'], $service['embed']);

	if ($vbulletin->options['media_autoplay'])
	{
		$service['embed'] = str_replace("{ap10}", "1", $service['embed']);
		$service['embed'] = str_replace("{apYN}", "yes", $service['embed']);
		$service['embed'] = str_replace("{apTF}", "true", $service['embed']);
	}
	else
	{
		$service['embed'] = str_replace("{ap10}", "0", $service['embed']);
		$service['embed'] = str_replace("{apYN}", "no", $service['embed']);
		$service['embed'] = str_replace("{apTF}", "false", $service['embed']);
	}

	return $service;
}

function construct_sidebar()
{
	global $vbulletin;

	$categories = $vbulletin->db->query_read("
        SELECT media_category.*, COUNT(media.mediaID) AS count
		FROM " . TABLE_PREFIX . "media_category AS media_category
		LEFT JOIN " . TABLE_PREFIX . "media AS media ON (media.categoryID = media_category.categoryID)
        WHERE catOrder != '0'
		GROUP BY media_category.categoryID
        ORDER BY media_category.catOrder
    ");

	while ($category = $vbulletin->db->fetch_array($categories))
	{
		if ($category['catDepth'])
		{
			$category['space'] = $category['catDepth'] * 7; 
		}

		$category['href'] = construct_href_category($category);

		$templater = vB_Template::create('8WR_media_SIDEBAR_cat');
			$templater->register('category', $category);
		$catbits .= $templater->render();
	}

	if ($vbulletin->options['media_limit_users'])
	{
		$users = $vbulletin->db->query_read("
			SELECT media.*, COUNT(media.mediaID) AS count, IF(NOT ISNULL(user.userid), user.username, media.username) AS username
			FROM " . TABLE_PREFIX . "media AS media
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = media.userID)
			WHERE NOT ISNULL(user.userid)
			GROUP BY media.userID
			ORDER BY count DESC
			LIMIT ".$vbulletin->options['media_limit_users']."
		");

		while ($user = $vbulletin->db->fetch_array($users))
		{
			$user['musername'] = fetch_musername($user);
			$user['href'] = construct_href_user($user);

			$templater = vB_Template::create('8WR_media_SIDEBAR_user');
				$templater->register('user', $user);
			$userbits .= $templater->render();
		}

		$statbits['users'] = $vbulletin->options['media_limit_users'];
	}

	$medias = $vbulletin->db->query_first("SELECT COUNT(mediaID) AS media, SUM(views) AS views, SUM(comments) AS comments FROM " . TABLE_PREFIX . "media");
	$categories = $vbulletin->db->query_first("SELECT COUNT(categoryID) AS categories FROM " . TABLE_PREFIX . "media_category WHERE catOrder != '0'");

	$statbits['browse'] = construct_href_browse();
	$statbits['search'] = construct_href_search();
	$statbits['media'] = $medias['media'];
	$statbits['views'] = $medias['views'];
	$statbits['comments'] = $medias['comments'];
	$statbits['categories'] = $categories['categories'];

	$templater = vB_Template::create('8WR_media_SIDEBAR');
		$templater->register('catbits', $catbits);
		$templater->register('userbits', $userbits);
		$templater->register('statbits', $statbits);
	$sidebar .= $templater->render();

	return $sidebar;
}

function construct_cat_bits($categoryID)
{
	global $vbulletin;

	$categories = $vbulletin->db->query_read("
        SELECT * FROM ".TABLE_PREFIX."media_category
        WHERE catOrder != '0'
        ORDER BY catOrder
    ");
	$catselect = vB_Template::create('option')->render();

	while ($category = $vbulletin->db->fetch_array($categories))
	{
		$category['align'] = "";
        for ($i = 0; $i < $category['catDepth']; $i++)
        {
            $category['align'] .= '-- ';
        }

		$optiontitle = $category['align'].$category['catName'];
		$optionselected = (($category['categoryID'] == $categoryID) ? 'selected="selected"' : '');
		$optionvalue = $category['categoryID'];

		$templater = vB_Template::create('option');
			$templater->register('optionselected', $optionselected);
			$templater->register('optiontitle', $optiontitle);
			$templater->register('optionvalue', $optionvalue);
		$catselect .= $templater->render();
	}

	return $catselect;
}

function construct_submit_small($cid = 0)
{
	global $vbulletin;

	$catselect = construct_cat_bits($cid);

	$templater = vB_Template::create('8WR_media_submit_small');
		$templater->register('catselect', $catselect);
	return $templater->render();
}

function construct_media_bit($media, $type, $playlist = false, $count = 0)
{
	global $vbulletin, $vbphrase, $perms;

	$faves = explode(",",$vbulletin->userinfo['mediafaves']);

	if (in_array($media['mediaID'], $faves))
	{
		$media['faves'] = true;
	}

	if ($media['length'] == 0)
	{
		$media['length'] = "???";
	}
	else if ($media['svcStream'] != "null")
	{
		$media['length'] = $vbphrase['media_live'];
	}
	else
	{
		$duration = $media['length'];
		$minutes = floor($duration / 60);
		$seconds = $duration % 60;
		$seconds = str_pad($seconds, 2, "0", STR_PAD_LEFT); 
		$media['length'] = "$minutes:$seconds";
	}

	$media['date'] = vbdate($vbulletin->options['dateformat'], $media['dateline']);
	$media['time'] = vbdate($vbulletin->options['timeformat'], $media['dateline']);
	$media['intrate'] = intval($media['rating']);
	$media['thumbnail'] = $vbulletin->options['media_thumb_dir']."/thumbs/". $media['mediaID'] .".jpg";

	$media['description'] = strip_bbcode($media['description'], true, false, false, true);
	$media['description'] = fetch_trimmed_title($media['description'], $vbulletin->options['media_limit_desc']);

	$href['details'] = construct_href_details($media, $playlist, $count);
	$href['playlist'] = construct_href_playlist($media);
	$href['category'] = construct_href_category($media);
	$href['user'] = construct_href_user($media);

	switch ($type)
	{
		case "large":
			$media['tags'] = construct_tag_bits($media,$vbulletin->options['media_limit_tags']);
						$templater = vB_Template::create('8WR_media_bit_large');	break;
		case "small":	$templater = vB_Template::create('8WR_media_bit_small');	break;
		case "tiny":	$templater = vB_Template::create('8WR_media_bit_tiny');		break;
		case "table":	$templater = vB_Template::create('8WR_media_bit_table');	break;
		case "plist":	$templater = vB_Template::create('8WR_media_bit_plist');	break;
		case "list":	$templater = vB_Template::create('8WR_media_bit_list');		break;
		case "faves":	$templater = vB_Template::create('8WR_media_bit_faves');	break;
		case "subs":	$templater = vB_Template::create('8WR_media_bit_subs');		break;
		default:		$templater = vB_Template::create('8WR_media_bit_small');	break;
	}

		$templater->register('perms', $perms);
		$templater->register('href', $href);
		$templater->register('media', $media);
		$templater->register('playlist', $playlist);
		$templater->register('tagbits', $tagbits);
	return $templater->render();
}

function construct_tag_bits($media, $limit = 0)
{
	global $vbulletin, $vbphrase;

	$tags = explode(",",$media['tagcache']);
	$count = count($tags);
	
	if ($limit && ($count > $limit))
	{
		return construct_phrase($vbphrase['media_tags_count'],  construct_href_details($media), $count);
	}

	foreach ($tags as $tagtemp)
	{
		$tag['tagText'] = $tagtemp;
		$tag['href'] = construct_href_tag($tag);

		$templater = vB_Template::create('8WR_media_tag_bit');
			$templater->register('tag', $tag);
		$tagbits .= $templater->render();
	}
	
	return $tagbits;
}

function construct_tag_cloud($limit = 0, $sizeadd = 0)
{
	global $vbulletin;

	$limit = $limit ? $limit : $vbulletin->options['media_limit_cloud'];

	$results = $vbulletin->db->query_read("
		SELECT media_tag_content.tagID AS tagID, media_tag.*, COUNT(*) AS count
			FROM " . TABLE_PREFIX . "media_tag_content AS media_tag_content
			INNER JOIN " . TABLE_PREFIX . "media_tag AS media_tag ON (media_tag.tagID = media_tag_content.tagID)
			GROUP BY media_tag.tagID, media_tag.tagText
			ORDER BY count DESC
			LIMIT " . $limit . "
	");
	
	while ($row = $vbulletin->db->fetch_array($results))
	{
		$tags[$row['tagID']] = $row['count'];
		$text[$row['tagID']] = $row['tagText'];
	}

	if (count($tags) == 0) { return; }

	$max_size = 22 + $sizeadd;
	$min_size = 12;

	$max_qty = max(array_values($tags));
	$min_qty = min(array_values($tags));
	
	$spread = $max_qty - $min_qty;

	if ($spread == 0) {	$spread = 1; }

	$step = ($max_size - $min_size) / ($spread);

	asort($text);
	
	foreach ($text as $key => $value)
	{
		$size = $min_size + (($tags[$key] - $min_qty) * $step);
		$tag['tagSize'] = floor($size);
		$tag['tagText'] = $value;
		$tag['count'] = $tags[$key];

		$href['tag'] = construct_href_tag($tag);
		
		$templater = vB_Template::create('8WR_media_tag_cloud_bit');
			$templater->register('href', $href);
			$templater->register('tag', $tag);
		$cloudbits .= $templater->render();
	}

	$href['cloud'] = construct_href_tag_cloud();

	$templater = vB_Template::create('8WR_media_tag_cloud');
		$templater->register('cloudbits', $cloudbits);
		$templater->register('href', $href);
	return $templater->render();
}

function construct_pagenav_bits($media, $playlist = false)
{
	global $vbulletin, $ajax;

	sanitize_pageresults($media['comments'], $pagenumber, $perpage, 50, $vbulletin->options['media_limit_comments']);

	if ($vbulletin->GPC['pagenumber'] < 1)
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}
	else if ($vbulletin->GPC['pagenumber'] > ceil(($media['comments'] + 1) / $perpage))
	{
		$vbulletin->GPC['pagenumber'] = ceil(($media['comments'] + 1) / $perpage);
	}

	$pagenav = construct_page_nav($vbulletin->GPC['pagenumber'], $perpage, $media['comments'], construct_href_details($media));
	$pagenav = preg_replace('/popupmenu/i', '', $pagenav);

	if ($ajax)
	{
		if ($playlist) { $playlistID = $playlist['playlistID']; } else { $playlistID = 0; }
		if ($vbulletin->options['media_doseo'])
		{
			$pagenav = preg_replace('/href="media\/m\d+[\w-]+?"/i', 'href="'.construct_href_details($media,$playlist).'#comments" onclick="get_comments('.$media['mediaID'].','.$playlistID.',1)"', $pagenav);
			$pagenav = preg_replace('/href="media\/m\d+[\w-]+?\?page=(\d+)"/i', 'href="'.construct_href_details($media,$playlist).'#comments" onclick="get_comments('.$media['mediaID'].','.$playlistID.',$1)"', $pagenav);
		}
		else
		{
			$pagenav = preg_replace('/href="[\w.?=&]+?mid=\d+"/i', 'href="'.construct_href_details($media,$playlist).'#comments" onclick="get_comments('.$media['mediaID'].','.$playlistID.',1)"', $pagenav);
			$pagenav = preg_replace('/href="[\w.?=&]+?mid=\d+&amp;page=(\d+)"/i', 'href="'.construct_href_details($media,$playlist).'#comments" onclick="get_comments('.$media['mediaID'].','.$playlistID.',$1)"', $pagenav);
		}
	}

	return $pagenav;
}

function construct_comment_bits($media)
{
	global $vbulletin, $perms;

	sanitize_pageresults($media['comments'], $pagenumber, $perpage, 50, $vbulletin->options['media_limit_comments']);

	if ($vbulletin->GPC['pagenumber'] < 1)
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}
	else if ($vbulletin->GPC['pagenumber'] > ceil(($media['comments'] + 1) / $perpage))
	{
		$vbulletin->GPC['pagenumber'] = ceil(($media['comments'] + 1) / $perpage);
	}

	$limitlower = ($vbulletin->GPC['pagenumber'] - 1) * $perpage;
	$limitupper = ($vbulletin->GPC['pagenumber']) * $perpage;

	$comments = $vbulletin->db->query_read("
		SELECT media_comment.*, user.*, media.title, IF(NOT ISNULL(user.userid), user.username, media_comment.username) AS username,
			NOT ISNULL(customavatar.userid) AS hascustomavatar,	user.avatarrevision AS avatarrevision, avatar.avatarpath AS avatarpath,
			customavatar.width AS avwidth, customavatar.height AS avheight, customavatar.dateline AS avatardateline
		FROM " . TABLE_PREFIX . "media_comment AS media_comment
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = media_comment.userID)
		LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON(avatar.avatarid = user.avatarid)
		LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON(customavatar.userid = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "media AS media ON(media.mediaID = media_comment.mediaID)
		WHERE media_comment.mediaID = '".$media['mediaID']."'
		ORDER BY media_comment.dateline DESC
		LIMIT $limitlower, $perpage
	");

	require_once(DIR . '/includes/functions_user.php');
	require_once(DIR . '/includes/class_bbcode.php');
	$bbcode = new vB_BbCodeParser($vbulletin, fetch_tag_list());

	while ($comment = $vbulletin->db->fetch_array($comments))
	{
		$response[0] = $comment['username'];
		$response[1] = $comment['userid'];

		$comment['date'] = vbdate($vbulletin->options['dateformat'], $comment['dateline']);
		$comment['time'] = vbdate($vbulletin->options['timeformat'], $comment['dateline']);

		$comment['musername'] = fetch_musername($comment);
		$comment['message'] = $bbcode->parse($comment['message'],'nonforum',1);

		fetch_avatar_from_userinfo($comment,true,true);

		$href['comment'] = construct_href_comment($comment);

		$templater = vB_Template::create('8WR_media_comment_bit');
			$templater->register('comment', $comment);
			$templater->register('response', $response);
			$templater->register('href', $href);
			$templater->register('perms', $perms);
		$commentbits .= $templater->render();
	}

	return $commentbits;
}

function construct_media_rating($media)
{
	global $vbulletin, $perms;

	$rating = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "media_rating
		WHERE mediaID = '".$media['mediaID']."'
			AND userID = '".$vbulletin->userinfo['userid']."'
	");

	$media['intrate'] = intval($media['rating']);

	$templater = vB_Template::create('8WR_media_details_rate');
		$templater->register('rating', $rating);
		$templater->register('media', $media);
		$templater->register('perms', $perms);
	return $templater->render();
}

function construct_media_faves($media, $playlist = false)
{
	global $vbulletin, $ajax, $perms;

	$user = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "user WHERE userID = '".$vbulletin->userinfo['userid']."'");

	$faves = explode(",",$user['mediafaves']);

	if (in_array($media['mediaID'], $faves))
	{
		$media['faves1'] = "rem";
		$media['faves2'] = "add";
	}
	else
	{
		$media['faves1'] = "add";
		$media['faves2'] = "rem";
	}

	$templater = vB_Template::create('8WR_media_details_faves');
		$templater->register('media', $media);
		$templater->register('playlist', $playlist);
		$templater->register('perms', $perms);
	$favesbits = $templater->render();

	if ($ajax)
	{
		if ($playlist) { $playlistID = $playlist['playlistID']; } else { $playlistID = 0; }
		$favesbits = preg_replace('/href=".+?"/i', 'href="'.construct_href_details($media, $playlist).'#" onclick="post_faves_'.$media['faves1'].'('.$media['mediaID'].','.$playlistID.')"', $favesbits);
	}

	return $favesbits;
}

function construct_media_subs($media, $playlist = false)
{
	global $vbulletin, $ajax, $perms;

	$subs = explode(",",$media['subscriptions']);

	if (in_array($vbulletin->userinfo['userid'], $subs))
	{
		$media['subs1'] = "rem";
		$media['subs2'] = "add";
	}
	else
	{
		$media['subs1'] = "add";
		$media['subs2'] = "rem";
	}

	$templater = vB_Template::create('8WR_media_details_subs');
		$templater->register('media', $media);
		$templater->register('playlist', $playlist);
		$templater->register('perms', $perms);
	$subsbits = $templater->render();

	if ($ajax)
	{
		if ($playlist) { $playlistID = $playlist['playlistID']; } else { $playlistID = 0; }
		$subsbits = preg_replace('/href=".+?"/i', 'href="'.construct_href_details($media, $playlist).'#comments" onclick="post_subs_'.$media['subs1'].'('.$media['mediaID'].','.$playlistID.')"', $subsbits);
	}

	return $subsbits;
}

?>