<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (media/media_function_build.php)             # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

function build_thumbnail($thumbnail, $mediaID)
{
	global $vbulletin;

	require_once(DIR . '/includes/class_vurl.php');
	$vurl = new vB_vURL($vbulletin);
	$vurl->set_option(VURL_URL, $thumbnail);
	$vurl->set_option(VURL_RETURNTRANSFER, 1);
	$vurl->set_option(VURL_FOLLOWLOCATION, 1);
	$vurl->set_option(VURL_TIMEOUT, 30);
	$result = $vurl->exec();

	$target = DIR.'/'.$vbulletin->options['media_thumb_dir'].'/thumbs/'.$mediaID.'.jpg';

	$file = fopen($target, 'wb');
	fwrite($file, $result);
	fclose($file);

	$newRatio = 90 / 160;
	$newWidth = 160;
	$newHeight = $newRatio * $newWidth;
	$quality = $vbulletin->options['media_thumb_quality'];

	if ($vbulletin->options['imagetype'] == 'GD')
	{
		list($oldWidth, $oldHeight) = getimagesize($target);
		$oldRatio = $oldHeight / $oldWidth;
		$tmpHeight = $oldRatio * $newWidth;
		$offHeight = ($oldHeight - ($newRatio * $oldWidth)) / 2;

		preg_match('#([\w]+)$#i',$thumbnail,$filetype);

		switch ($filetype[1])
		{
			case "png":		$oldImage = imagecreatefrompng($target);		break;
			case "gif":		$oldImage = imagecreatefromgif($target);		break;
			case "jpg":
			default:		$oldImage = imagecreatefromjpeg($target);		break;
		}

		$newImage = imagecreatetruecolor(160, 90);
		imagecopyresampled($newImage, $oldImage, 0, 0, 0, $offHeight, $newWidth, $tmpHeight, $oldWidth, $oldHeight);
		imagejpeg($newImage, $target, $quality);
	}
/*
	if ($vbulletin->options['imagetype'] == 'Magick')
	{
		$thumb = new Imagick($target);
		$thumb->cropThumbnailImage($newWidth,$newHeight);
		$thumb->writeImage($target);
		$thumb->destroy();
	}
*/
}

function build_favorite_count()
{
	global $vbulletin;

	$users = $vbulletin->db->query_read("SELECT mediafaves FROM " . TABLE_PREFIX . "user");

	while ($user = $vbulletin->db->fetch_array($users))
	{
		$faves = explode(",",$user['mediafaves']);
		foreach ($faves as $key => $value)
		{
			$count[$value]++;
		}
	}

	foreach ($count as $key => $value)
	{
		$media = array('mediaID' => $key);
		$dm =& datamanager_init('Media', $vbulletin);
		$dm->set_existing($media);
		$dm->setr('favorites', $value);
		$dm->save();
	}
}

function build_comment_count($mediaID)
{
	global $vbulletin;

	$count = $vbulletin->db->query_first("
		SELECT COUNT(*) AS count
		FROM " . TABLE_PREFIX . "media_comment
		WHERE mediaID = '" . $mediaID . "' AND state = 'visible'
		GROUP BY mediaID
	");

	$media = array('mediaID' => $mediaID);
	$dm =& datamanager_init('Media', $vbulletin);
	$dm->set_existing($media);
	$dm->setr('comments', $count['count']);
	$dm->save();
}

function build_ratings($mediaID)
{
	global $vbulletin;

	$ratings = $vbulletin->db->query_first("
		SELECT SUM(ratingVAL) AS total, COUNT(*) AS count
		FROM " . TABLE_PREFIX . "media_rating
		WHERE mediaID = '" . $mediaID . "'
		GROUP BY mediaID
	");

	if ($ratings['count'])
	{
		$rating = $ratings['total'] / $ratings['count'];
	}

	$media = array('mediaID' => $mediaID);
	$dm =& datamanager_init('Media', $vbulletin);
	$dm->set_existing($media);
	$dm->setr('ratingTotal', $ratings['total']);
	$dm->setr('ratingCount', $ratings['count']);
	$dm->setr('rating', $rating);
	$dm->save();
}

function build_tags($tags)
{
	global $vbulletin;

	$taglist = explode(',',$tags);

	foreach ($taglist AS $tag)
	{
		$dm =& datamanager_init('Media_Tag', $vbulletin, 'ERRTYPE_SILENT');
		$dm->set('tagText', $tag);
		$dm->save();
	}
}

function build_tags_content($tags, $mediaID)
{
	global $vbulletin;

	$tags = preg_replace('#[\#\$\?\&\@\%\+\=\^\|\:\;\/\\\<\>\{\}\[\]\'\"]#', '', html_entity_decode($tags));
	$taglist = explode(',',$tags);
	$taglist = array_map(trim, $taglist);
	$taglist = array_map(strtolower, $taglist);
	$tagcontent = array();

	$tagids = $vbulletin->db->query_read("
		SELECT tagID
		FROM " . TABLE_PREFIX . "media_tag
		WHERE tagText IN ('" . implode("', '", $taglist) . "')
	");

	while ($tag = $vbulletin->db->fetch_array($tagids))
	{
		$dm =& datamanager_init('Media_Tag_Content', $vbulletin, 'ERRTYPE_SILENT');
		$dm->set('tagID', $tag['tagID']);
		$dm->set('mediaID', $mediaID);
		$dm->save();
	}
}

function build_tags_cache($mediaID)
{
	global $vbulletin;

	$tagcache = array();

	$tags = $vbulletin->db->query_read("
		SELECT media_tag_content.*, media_tag.tagText
		FROM " . TABLE_PREFIX . "media_tag_content AS media_tag_content
		LEFT JOIN " . TABLE_PREFIX . "media_tag AS media_tag ON(media_tag.tagID = media_tag_content.tagID)
		WHERE media_tag_content.mediaID = '".$mediaID."'
		ORDER BY media_tag.tagText ASC
	");

	while ($tag = $vbulletin->db->fetch_array($tags))
	{
		$tagcache[] = $tag['tagText'];
	}

	$tagcache = implode(",",$tagcache);

	$media = array('mediaID' => $mediaID);

	$dm =& datamanager_init('Media', $vbulletin);
	$dm->set_existing($media);
	$dm->setr('tagcache', $tagcache);
	$dm->save();
}

function build_faves_cache($userID, &$faves, $add = 0, $rem = 0)
{
	global $vbulletin;

	$faves = explode(",", $faves);

	foreach ($faves as $key => $value)
	{
		if (!intval($value)) { unset($faves[$key]); }
	}

	if (($add) && (!in_array($add, $faves)))
	{
		$faves[] = $add;
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "media SET favorites = favorites+1 WHERE mediaID = '".$add."'");
	}

	if (($rem) && (in_array($rem, $faves)))
	{
		foreach ($faves as $key => $mediaid)
		{
			if ($mediaid == $rem) { unset($faves[$key]); }
		}
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "media SET favorites = favorites-1 WHERE mediaID = '".$rem."'");
	}

	sort($faves);
	$faves = implode(",", $faves);

	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET mediafaves = '".$faves."' WHERE userid = '".$userID."'");
}

function build_subs_cache($mediaID, &$subs, $add = 0, $rem = 0)
{
	global $vbulletin;

	$subs = explode(",", $subs);

	foreach ($subs as $key => $value)
	{
		if (!intval($value)) { unset($subs[$key]); }

		if ((!$add) && (!$rem))
		{
			if (!$vbulletin->db->query_first("SELECT * FROM ".TABLE_PREFIX."user WHERE userid = '".$value."'"))
			{
				unset($subs[$key]);
			}
		}
	}

	if (($add) && (!in_array($add, $subs)))
	{
		$subs[] = $add;
	}

	if (($rem) && (in_array($rem, $subs)))
	{
		foreach ($subs as $key => $userid)
		{
			if ($userid == $rem) { unset($subs[$key]); }
		}
	}

	sort($subs);
	$subs = implode(",", $subs);

	$media = array('mediaID' => $mediaID);

	$dm =& datamanager_init('Media', $vbulletin);
	$dm->set_existing($media);
	$dm->setr('subscriptions', $subs);
	$dm->save();
}

function build_sitemap()
{
	global $vbulletin;
	require_once(DIR . '/includes/class_xml.php');

	$count = $vbulletin->db->query_first("SELECT COUNT(mediaID) AS count FROM " . TABLE_PREFIX . "media AS media");
	$count = $count['count'];

	for ($start = 1; $start <= $count; $start += 1000)
	{
		$loops++;
		$output = '<?xml version="1.0" encoding="UTF-8"?>' . "\r\n";

		$xml = new vB_XML_Builder($vbulletin);
		$urltag = array('xmlns' => 'http://www.sitemaps.org/schemas/sitemap/0.9', 'xmlns:video' => 'http://www.google.com/schemas/sitemap-video/1.1');

		$xml->add_group('urlset', $urltag);
			$medias = $vbulletin->db->query_read("
				SELECT media.*, media_category.*, media_service.*
				FROM " . TABLE_PREFIX . "media AS media
				LEFT JOIN " . TABLE_PREFIX . "media_category AS media_category ON(media_category.categoryID = media.categoryID)
				LEFT JOIN " . TABLE_PREFIX . "media_service AS media_service ON(media_service.serviceID = media.serviceID)
				ORDER BY media.mediaID ASC
				LIMIT $start, 1000
			");

			$loctag = array('allow_embed' => 'yes');

			while ($media = $vbulletin->db->fetch_array($medias))
			{
				$media['svcMovie'] = str_replace('{serviceVAL}', $media['serviceVAL'], $media['svcMovie']);
				$media['svcMovie'] = str_replace('{serviceVAL2}', $media['serviceVAL2'], $media['svcMovie']);
				$media['svcMovie'] = str_replace('{bburl}', $vbulletin->options['bburl'], $media['svcMovie']);
				$media['svcMovie'] = str_replace('{local}', $vbulletin->options['bburl']."/".$vbulletin->options['media_thumb_dir'], $media['svcMovie']);
				$media['svcMovie'] = str_replace("{ap10}", "1", $media['svcMovie']);
				$media['svcMovie'] = str_replace("{apYN}", "yes", $media['svcMovie']);
				$media['svcMovie'] = str_replace("{apTF}", "true", $media['svcMovie']);

				$xml->add_group('url');
					$xml->add_tag('loc', $vbulletin->options['bburl']."/".construct_href_details($media));
					$xml->add_group('video:video');
						$xml->add_tag('video:player_loc', $media['svcMovie'], $loctag);
						$xml->add_tag('video:thumbnail_loc', $vbulletin->options['bburl']."/".$vbulletin->options['media_thumb_dir']."/thumbs/". $media['mediaID'] .".jpg");
						$xml->add_tag('video:title', fetch_trimmed_title($media['title'], 100));

						$media['description'] = strip_bbcode($media['description'], true, false, false, true);
						$xml->add_tag('video:description', fetch_trimmed_title($media['description'], 2048));

						$xml->add_tag('video:duration', $media['length']);
						$xml->add_tag('video:rating', $media['rating']);
						$xml->add_tag('video:view_count', $media['views']);
						$xml->add_tag('video:publication_date', date("c", $media['dateline']));

						$tags = explode(",",$media['tagcache']);
						foreach ($tags as $tag)
						{
							if ($tag) { $xml->add_tag('video:tag', $tag); }
						}

						$xml->add_tag('video:category', $media['catName']);
					$xml->close_group('video:video');
				$xml->close_group('url');
			}
		$xml->close_group('urlset');

		$output .= $xml->output();

		$target = DIR.'/'.$vbulletin->options['media_thumb_dir'].'/sitemap/media_'.str_pad($loops, 3, "0", STR_PAD_LEFT).'.xml';

		$file = fopen($target, 'w');
		fwrite($file, $output);
		fclose($file);
	}

	$output = '<?xml version="1.0" encoding="UTF-8"?>' . "\r\n";

	$xml = new vB_XML_Builder($vbulletin);
	$maptag = array('xmlns' => 'http://www.sitemaps.org/schemas/sitemap/0.9');

	$xml->add_group('sitemapindex', $maptag);
		for ($sitemap = 1; $sitemap <= $loops; $sitemap++)
		{
			$xml->add_group('sitemap');
			$xml->add_tag('loc', $vbulletin->options['bburl']."/".$vbulletin->options['media_thumb_dir']."/sitemap/media_".str_pad($sitemap, 3, "0", STR_PAD_LEFT).".xml");
			$xml->add_tag('lastmod', date("c", TIMENOW));
			$xml->close_group('sitemap');
		}
	$xml->close_group('sitemapindex');

	$output .= $xml->output();

	$target = DIR.'/'.$vbulletin->options['media_thumb_dir'].'/sitemap/media.xml';

	$file = fopen($target, 'w');
	fwrite($file, $output);
	fclose($file);
}

?>