<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (media/media_details.php)                    # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

if (!$perms['details'])
{
	print_no_permission();
}

if ($do == "details")
{
	if (!$media = $vbulletin->db->query_first("
		SELECT media.*, media_service.*, media_category.*, IF(NOT ISNULL(user.userid), user.username, media.username) AS username
		FROM " . TABLE_PREFIX . "media AS media
		LEFT JOIN " . TABLE_PREFIX . "media_service AS media_service ON(media_service.serviceID = media.serviceID)
		LEFT JOIN " . TABLE_PREFIX . "media_category AS media_category ON(media_category.categoryID = media.categoryID)
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = media.userID)
		WHERE media.mediaID = '".$mid."'
	"))
	{
		eval(standard_error(fetch_error('media_details_invalid')));
	}

	if (!fetch_bbarray_cookie('mediaviews', $media['mediaID']))
	{
		$vbulletin->db->shutdown_query("UPDATE ".TABLE_PREFIX."media SET views = views+1 WHERE mediaID = '".$media['mediaID']."'");
		$media['views']++;
	}
	set_bbarray_cookie('mediaviews', $media['mediaID'], 1, false);

	$media['date'] = vbdate($vbulletin->options['dateformat'], $media['dateline']);
	$media['time'] = vbdate($vbulletin->options['timeformat'], $media['dateline']);
	$media['tags'] = construct_tag_bits($media);

	require_once(DIR . '/includes/class_bbcode.php');
	$bbcode = new vB_BbCodeParser($vbulletin, fetch_tag_list());
 	$media['description'] = $bbcode->do_parse($media['description']);

	if ($media['length'] == 0)
	{
		$media['length'] = "???";
	}
	else
	{
		$duration = $media['length'];
		$minutes = floor($duration / 60);
		$seconds = $duration % 60;
		$seconds = str_pad($seconds, 2, "0", STR_PAD_LEFT); 
		$media['length'] = "$minutes $vbphrase[media_min] $seconds $vbphrase[media_sec]";
	}

	if ($media['svcStream'] != 'null')
	{
		$templater = vB_Template::create('8WR_media_embed_stream');
			$templater->register('media', $media);
		$media['embed_stream'] = $templater->render();

		$media['embed_stream'] = str_replace('{serviceVAL}', $media['serviceVAL'], $media['embed_stream']);
		$media['embed_stream'] = str_replace('{serviceVAL2}', $media['serviceVAL2'], $media['embed_stream']);
	}

	$templater = vB_Template::create('8WR_media_embed');
		$templater->register('media', $media);
	$media['embed'] = $templater->render();

	$media['embed'] = str_replace('{serviceVAL}', $media['serviceVAL'], $media['embed']);
	$media['embed'] = str_replace('{serviceVAL2}', $media['serviceVAL2'], $media['embed']);
	$media['embed'] = str_replace('{bburl}', $vbulletin->options['bburl'], $media['embed']);
	$media['embed'] = str_replace('{local}', $vbulletin->options['bburl']."/".$vbulletin->options['media_thumb_dir'], $media['embed']);

	if ($vbulletin->options['media_autoplay'])
	{
		$media['embed'] = str_replace("{ap10}", "1", $media['embed']);
		$media['embed'] = str_replace("{apYN}", "yes", $media['embed']);
		$media['embed'] = str_replace("{apTF}", "true", $media['embed']);
	}
	else
	{
		$media['embed'] = str_replace("{ap10}", "0", $media['embed']);
		$media['embed'] = str_replace("{apYN}", "no", $media['embed']);
		$media['embed'] = str_replace("{apTF}", "false", $media['embed']);
	}

	if ($pid)
	{
		$playlist = $vbulletin->db->query_first("SELECT * FROM ".TABLE_PREFIX."media_playlist WHERE playlistID = '".$pid."'");
		$playlist['mediaIDs'] = explode(',',$playlist['mediaIDs']);
		$playlist['href'] = construct_href_playlist($playlist);

		if (in_array($mid,$playlist['mediaIDs']))
		{
			$now = array_search($mid,$playlist['mediaIDs']);
			$playlist['count'] = count($playlist['mediaIDs']); 

			if ($prev = $vbulletin->db->query_first("SELECT * FROM ".TABLE_PREFIX."media WHERE mediaID = '".$playlist['mediaIDs'][$now-1]."'"))
			{
				$prev['pos'] = $now;
				$prev['href'] = construct_href_details($prev, $playlist);
			}
			if ($next = $vbulletin->db->query_first("SELECT * FROM ".TABLE_PREFIX."media WHERE mediaID = '".$playlist['mediaIDs'][$now+1]."'"))
			{
				$next['pos'] = $now+2;
				$next['href'] = construct_href_details($next, $playlist);
			}
		}
		else
		{
			$playlist = false;
		}
	}

	$href['details'] = $vbulletin->options['bburl'].'/'.construct_href_details($media, $playlist);
	$href['details_tags'] = construct_href_details_tags($media);
	$href['details_edit'] = construct_href_details_edit($media);
	$href['details_report'] = construct_href_details_report($media);
	$href['category'] = construct_href_category($media);
	$href['user'] = construct_href_user($media);

	if ($perms['comment'])
	{
		require_once(DIR . '/includes/functions_editor.php');
		$editorid = construct_edit_toolbar('',0,'nonforum',1,1,0,'qr');
	}

	$mediarating = construct_media_rating($media);
	$mediafaves = construct_media_faves($media, $playlist);
	$mediasubs = construct_media_subs($media);

	$pagenav = construct_pagenav_bits($media);
	$commentbits = construct_comment_bits($media,1);

	if ($vbulletin->userinfo['userid'] == $media['userID'])
	{
		$perms['edit'] = true;
	}

	if ($playlist)
	{
		$navbits[construct_href_playlists()] = $vbphrase['media_playlists'];
		$navbits[$playlist[href]] = $playlist['plName'];
	}
	else
	{
		$navbits[construct_href_category($media)] = $media['catName'];
	}

	$navbits[''] = $media['title'];

	$templater = vB_Template::create('8WR_media_details');
		$templater->register('media', $media);
		$templater->register('playlist', $playlist);
		$templater->register('prev', $prev);
		$templater->register('next', $next);
		$templater->register('commentbits', $commentbits);
		$templater->register('mediarating', $mediarating);
		$templater->register('mediafaves', $mediafaves);
		$templater->register('mediasubs', $mediasubs);
		$templater->register('href', $href);
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
		$templater->register('perms', $perms);
		$templater->register('pagenav', $pagenav);
		$templater->register('pagenumber', $pagenumber);
		$templater->register('perpage', $perpage);
	$mediaHTML = $templater->render();
}

if ($do == "details_faves")
{
	$media = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media WHERE mediaID = '".$mid."'");
	$playlist = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media_playlist WHERE playlistID = '".$pid."'");

	$mediafaves = construct_media_faves($media, $playlist);

	$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
	$xml->add_group('response');
	$xml->add_tag('mediafaves', $mediafaves);
	$xml->close_group();
	$xml->print_xml();
}

if ($do == "details_subs")
{
	$media = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media WHERE mediaID = '".$mid."'");
	$playlist = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media_playlist WHERE playlistID = '".$pid."'");

	$mediasubs = construct_media_subs($media, $playlist);

	$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
	$xml->add_group('response');
	$xml->add_tag('mediasubs', $mediasubs);
	$xml->close_group();
	$xml->print_xml();
}

if ($do == "details_pagenav")
{
	$media = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media WHERE mediaID = '".$mid."'");
	$playlist = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media_playlist WHERE playlistID = '".$pid."'");

	$pagenav = construct_pagenav_bits($media, $playlist);

	$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
	$xml->add_group('response');
	$xml->add_tag('pagenav', $pagenav);
	$xml->close_group();
	$xml->print_xml();
}

if ($do == "details_comments")
{
	$media = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media WHERE mediaID = '".$mid."'");
	$playlist = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media_playlist WHERE playlistID = '".$pid."'");

	$pagenav = construct_pagenav_bits($media, $playlist);
	$commentbits = construct_comment_bits($media);

	$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
	$xml->add_group('response');
	$xml->add_tag('pagenav', $pagenav);
	$xml->add_tag('commentbits', $commentbits);
	$xml->close_group();
	$xml->print_xml();
}

if ($do == "details_edit")
{
	$media = $vbulletin->db->query_first("
		SELECT media.*, media_category.*
		FROM " . TABLE_PREFIX . "media AS media
		LEFT JOIN " . TABLE_PREFIX . "media_category AS media_category ON(media_category.categoryID = media.categoryID)
		WHERE media.mediaID = '".$mid."'
	");

	if (($vbulletin->userinfo['userid'] != $media['userID']) AND !$perms['modedit'])
	{
		print_no_permission();
	}

	$catselect = construct_cat_bits($media['categoryID']);

	if ($media['length'] == 0)
	{
		$media['minutes'] = "0";
		$media['seconds'] = "00";
	}
	else
	{
		$media['minutes'] = floor($media['length'] / 60);
		$media['seconds'] = $media['length'] % 60;
		$media['seconds'] = str_pad($media['seconds'], 2, "0", STR_PAD_LEFT);
	}

	$media['thumbnail'] = $vbulletin->options['media_thumb_dir']."/thumbs/". $media['mediaID'] .".jpg";

	require_once(DIR . '/includes/functions_editor.php');
	$editorid = construct_edit_toolbar($media['description'],0,'nonforum',1,1,0,'fe');

	$navbits[construct_href_category($media)] = $media['catName'];
	$navbits[construct_href_details($media)] = $media['title'];
	$navbits[''] = $vbphrase['media_details_edit']; 

	$templater = vB_Template::create('8WR_media_details_edit');
		$templater->register('media', $media);
		$templater->register('catselect', $catselect);
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
	$mediaHTML = $templater->render();
}

if ($do == "details_data")
{
	$vbulletin->input->clean_array_gpc('p', array(
		'category'		=> TYPE_UINT,
		'title'			=> TYPE_STR,
		'message'		=> TYPE_STR,
		'minutes'		=> TYPE_UINT,
		'seconds'		=> TYPE_UINT,
		'custom1'		=> TYPE_STR,
		'custom2'		=> TYPE_STR,
		'custom3'		=> TYPE_STR,
		'custom4'		=> TYPE_STR,
		'custom5'		=> TYPE_STR,
		'custom6'		=> TYPE_STR,
		'custom7'		=> TYPE_STR,
		'custom8'		=> TYPE_STR,
		'custom9'		=> TYPE_STR,
		'action'		=> TYPE_STR,
		'wysiwyg'		=> TYPE_BOOL,
	));

	$media = array('mediaID' => $mid);

	$categoryID = $vbulletin->GPC['category'];
	$title = $vbulletin->GPC['title'];
	$description = $vbulletin->GPC['message'];
	$minutes = $vbulletin->GPC['minutes'] * 60;
	$seconds = $vbulletin->GPC['seconds'];
	$length = $minutes + $seconds;
	$custom1 = $vbulletin->GPC['custom1'];
	$custom2 = $vbulletin->GPC['custom2'];
	$custom3 = $vbulletin->GPC['custom3'];
	$custom4 = $vbulletin->GPC['custom4'];
	$custom5 = $vbulletin->GPC['custom5'];
	$custom6 = $vbulletin->GPC['custom6'];
	$custom7 = $vbulletin->GPC['custom7'];
	$custom8 = $vbulletin->GPC['custom8'];
	$custom9 = $vbulletin->GPC['custom9'];

	$action = $vbulletin->GPC['action'];
	$wysiwig = $vbulletin->GPC['wysiwyg'];

	$dm =& datamanager_init('Media', $vbulletin);
	$dm->set_existing($media);

	if ($action == "delete")
	{
		$vbulletin->db->query_write("
			DELETE FROM " . TABLE_PREFIX . "media_tag_content
			WHERE mediaID = '".$media['mediaID']."'
		");

		$vbulletin->db->query_write("
			DELETE FROM " . TABLE_PREFIX . "media_comment
			WHERE mediaID = '".$media['mediaID']."'
		");

		$vbulletin->db->query_write("
			DELETE FROM " . TABLE_PREFIX . "media_rating
			WHERE mediaID = '".$media['mediaID']."'
		");

		$thumbnail = DIR.'/'.$vbulletin->options['media_thumb_dir']."/thumbs/". $media['mediaID'] .".jpg";
		if (file_exists($thumbnail)) { unlink($thumbnail); }

		$dm->delete();

		$vbulletin->url = construct_href_main();
		eval(print_standard_redirect('media_details_deleted'));
	}
	else
	{
		if ($wysiwyg)
		{
			require_once(DIR . '/includes/functions_wysiwyg.php');
			$description = convert_wysiwyg_html_to_bbcode($description, false);
		}

		$dm->setr('title', $title);
		$dm->setr('description', $description);
		$dm->setr('length', $length);
		$dm->setr('categoryID', $categoryID);
		$dm->setr('custom1', $custom1);
		$dm->setr('custom2', $custom2);
		$dm->setr('custom3', $custom3);
		$dm->setr('custom4', $custom4);
		$dm->setr('custom5', $custom5);
		$dm->setr('custom6', $custom6);
		$dm->setr('custom7', $custom7);
		$dm->setr('custom8', $custom8);
		$dm->setr('custom9', $custom9);
		$dm->save();

		$media = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media WHERE mediaID = '".$mid."'");

		$vbulletin->url = construct_href_details($media);
		eval(print_standard_redirect('media_details_saved'));
	}
}

if ($do == "details_thumb")
{
	$vbulletin->input->clean_array_gpc('f', array(
		'upload'	=> TYPE_FILE,
	));

	require_once('./includes/class_upload.php'); 
	require_once('./includes/class_image.php'); 

	$upload = new vB_Upload_Image($vbulletin); 
	$upload->image =& vB_Image::fetch_library($vbulletin); 
	$upload->path = DIR.'/'.$vbulletin->options['media_thumb_dir'].'/thumbs';

	$vbulletin->GPC['upload']['name'] = "temp.jpg";

	$thumbnail = $vbulletin->options['bburl']."/".$vbulletin->options['media_thumb_dir']."/thumbs/".$vbulletin->GPC['upload']['name'];

	if (!$upload->process_upload($vbulletin->GPC['upload']))
	{ 
   		eval(standard_error(fetch_error('there_were_errors_encountered_with_your_upload'))); 
	}

	$media = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "media WHERE mediaID = '".$mid."'");

	build_thumbnail($thumbnail, $media['mediaID']);

	$vbulletin->url = construct_href_details_edit($media);
	eval(print_standard_redirect('media_details_thumb'));
}

?>