<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (media/media_category.php)                   # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

if ($do == "category")
{
	if (!$category = $vbulletin->db->query_first("
		SELECT media_category.*, COUNT(media.mediaID) AS count
		FROM " . TABLE_PREFIX . "media_category AS media_category 
		LEFT JOIN " . TABLE_PREFIX . "media AS media ON(media.categoryID = media_category.categoryID)
		WHERE media_category.categoryID = '".$cid."'
			AND media_category.catOrder != '0'
		GROUP BY media_category.categoryID
	"))
	{
		eval(standard_error(fetch_error('media_category_invalid')));
	}

	sanitize_pageresults($category['count'], $pagenumber, $perpage, 30, $vbulletin->options['media_limit_medias']);

	if ($vbulletin->GPC['pagenumber'] < 1)
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}
	else if ($vbulletin->GPC['pagenumber'] > ceil(($category['count'] + 1) / $perpage))
	{
		$vbulletin->GPC['pagenumber'] = ceil(($category['count'] + 1) / $perpage);
	}

	$pagenav = construct_page_nav($vbulletin->GPC['pagenumber'], $perpage, $category['count'], construct_href_category($category, $sort)); 

	$limitlower = ($vbulletin->GPC['pagenumber'] - 1) * $perpage;
	$limitupper = ($vbulletin->GPC['pagenumber']) * $perpage;

	$medias = $vbulletin->db->query_read("
		SELECT media.*, media_service.*, media_category.*, IF(NOT ISNULL(user.userid), user.username, media.username) AS username
		FROM " . TABLE_PREFIX . "media AS media
		LEFT JOIN " . TABLE_PREFIX . "media_service AS media_service ON(media_service.serviceID = media.serviceID)
		LEFT JOIN " . TABLE_PREFIX . "media_category AS media_category ON(media_category.categoryID = media.categoryID)
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = media.userID)
		WHERE media.categoryID = '".$cid."'
		ORDER BY ".$sortQuery." media.dateline DESC
		LIMIT $limitlower, $perpage
	");

	while ($media = $vbulletin->db->fetch_array($medias))
	{
		$mediabits .= construct_media_bit($media, $vbulletin->options['media_select_bit']);
	}

	if ($perms['submit'])
	{
		$submitsmall = construct_submit_small($cid);
	}

	$sidebar = construct_sidebar();

	require_once(DIR . '/includes/class_bbcode.php');
	$bbcode = new vB_BbCodeParser($vbulletin, fetch_tag_list());
 	$category['catDesc'] = $bbcode->do_parse($category['catDesc']);

	$href['sort'] = $sort;
	$href['dateline'] = construct_href_category($category, 'dateline');
	$href['rating'] = construct_href_category($category, 'rating');
	$href['favorites'] = construct_href_category($category, 'favorites');
	$href['comments'] = construct_href_category($category, 'comments');
	$href['views'] = construct_href_category($category, 'views');

	$title = $category['catName'];
	$description = $category['catDesc'];

	$navbits[''] = $category['catName'];

	$templater = vB_Template::create('8WR_media_browse');
		$templater->register('title', $title);
		$templater->register('description', $description);
		$templater->register('category', $category);
		$templater->register('mediabits', $mediabits);
		$templater->register('href', $href);
		$templater->register('pagenav', $pagenav);
		$templater->register('pagenumber', $pagenumber);
		$templater->register('perpage', $perpage);
		$templater->register('submitsmall', $submitsmall);
		$templater->register('sidebar', $sidebar);
	$mediaHTML = $templater->render();
}

?>