/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (media/media_ajax_rating.js)                 # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

function rating_init(mid)
{
	if (AJAX_Compatible && (typeof vb_disable_ajax == 'undefined' || vb_disable_ajax < 2))
	{
		if (fetch_object('ratingsubmit'))
		{
			var sbutton = document.getElementById('ratingsubmit');
			var button = document.createElement('input');
			button.type      = 'button';
			button.className = sbutton.className;
			button.name      = sbutton.name;
			button.id        = sbutton.id;
			button.value     = sbutton.value;
			button.onclick   = function() { post_rating(mid); };
			sbutton.parentNode.insertBefore(button, sbutton);
			sbutton.parentNode.removeChild(sbutton);
		}
	}
}

function post_rating(mid)
{
	for (i = 0; i < 5; i++) {
		if (document.mediarate.vote[i].checked) {
			var vote = document.mediarate.vote[i].value;
		}
	}

	if (!vote)
	{
		return false;
	}

	YAHOO.vBulletin.vBPopupMenu.close_all();

	YAHOO.util.Connect.asyncRequest("POST", "media_ajax.php?do=rating", {
		success: send_rating,
		failure: vBulletin_AJAX_Error_Handler,
		timeout: 15000
	}, SESSIONURL + 'securitytoken=' + SECURITYTOKEN + "&mid=" + mid + "&vote=" + vote);

	return false;
}

function send_rating(ajax)
{
	if (ajax.responseXML)
	{
		var error = ajax.responseXML.getElementsByTagName('error');
		if (error.length)
		{
			alert(error[0].firstChild.nodeValue);
		}
		else
		{
			var success = ajax.responseXML.getElementsByTagName('success');

			try
			{
				var mediarating = ajax.responseXML.getElementsByTagName('mediarating')[0].firstChild.nodeValue;
				fetch_object('mediarating').innerHTML = mediarating;
			}
			catch (e) { }

			alert(success[0].firstChild.nodeValue);
		}
	}
}