<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (includes/class_dm_media_tag.php)            # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager')) { exit; }  

class vB_DataManager_Media_Tag extends vB_DataManager
{
	var $validfields = array(
		'tagID'		=> array(TYPE_UINT,	REQ_INCR),
		'tagText'	=> array(TYPE_STR,	REQ_YES,	VF_METHOD),
		'dateline'	=> array(TYPE_STR,	REQ_YES),
	);

	var $table = 'media_tag';
	var $condition_construct = array('tagID = %1$d', 'tagID');

	function vB_DataManager_Media_Tag(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);
	}

	function verify_tagText(&$tagText)
	{
		$tagText = preg_replace('#[\#\$\?\&\@\%\+\=\^\|\:\;\/\\\<\>\{\}\[\]\'\"]#', '', html_entity_decode($tagText));
		$tagText = strtolower(trim($tagText));

		return true;
	}

	function pre_save($doquery = true)
	{
		if (!$this->condition)
		{
			$this->set('dateline', TIMENOW);
		}

		if ($this->registry->options['tagmaxlen'] && (vbstrlen($this->fetch_field('tagText')) > $this->registry->options['tagmaxlen']))
		{
			$this->error('media_tag_long', vbstrlen($this->fetch_field('tagText')), $this->registry->options['tagmaxlen']);
			return false;
		}

		if ($this->registry->options['tagminlen'] && (vbstrlen($this->fetch_field('tagText')) < $this->registry->options['tagminlen']))
		{
			$this->error('media_tag_short', vbstrlen($this->fetch_field('tagText')), $this->registry->options['tagminlen']);
			return false;
		}

		if ($tag = $this->dbobject->query_first("SELECT * FROM ".TABLE_PREFIX."media_tag AS media_tag WHERE tagText = '".$this->fetch_field('tagText')."'"))
		{
			$this->error('media_tag_exists');
			return false;
		}

		return parent::pre_save($doquery);
	}
}

?>