<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (includes/class_dm_media_rating.php)         # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager')) { exit; }  

class vB_DataManager_Media_Rating extends vB_DataManager
{
	var $validfields = array(
		'ratingID'		=> array(TYPE_UINT,	REQ_INCR),
		'ratingVAL'		=> array(TYPE_UINT,	REQ_YES, VF_METHOD),
		'mediaID'		=> array(TYPE_UINT,	REQ_YES),
		'userID'		=> array(TYPE_UINT,	REQ_YES),
		'ipaddress'		=> array(TYPE_STR,	REQ_YES),
	);

	var $table = 'media_rating';
	var $condition_construct = array('ratingID = %1$d', 'ratingID');

	function vB_DataManager_Media_Rating(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);
	}

	function verify_ratingVAL($ratingVAL)
	{
		if ($ratingVAL == "0")
		{
			$this->error('media_rating_empty');
			return false;
		}

		return true;
	}

	function post_save_once()
	{
		build_ratings($this->fetch_field('mediaID'));
		return true;
	}

	function pre_save($doquery = true)
	{
		if (!$this->condition)
		{
			$this->set('userID', $this->registry->userinfo['userid']);
			$this->set('ipaddress', IPADDRESS);
		}

		$mediaID = $this->fetch_field('mediaID');
		$userID = $this->fetch_field('userID');

		if ($media = $this->dbobject->query_first("
			SELECT * FROM " . TABLE_PREFIX . "media_rating AS media_rating
			WHERE mediaID = '" . $mediaID . "'
				AND userID = '" . $userID . "'
		"))
		{
			$this->error('media_rating_exists');
			return false;
		}

		return parent::pre_save($doquery);
	}
}

?>