<?php
/*======================================================================*\
|| #################################################################### ||
|| # Media Library 4.0.0 (includes/class_dm_media_category.php)       # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 Jason Axelrod. All Rights Reserved.              # ||
|| # This file may not be redistributed without permission.           # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager')) { exit; }  

class vB_DataManager_Media_Category extends vB_DataManager
{
	var $validfields = array(
		'categoryID'	=> array(TYPE_UINT,	REQ_INCR),
		'catName'		=> array(TYPE_STR,	REQ_YES,	VF_METHOD),
		'catDesc'		=> array(TYPE_STR,	REQ_YES,	VF_METHOD),
		'catOrder'		=> array(TYPE_UINT,	REQ_YES),
		'catDepth'		=> array(TYPE_UINT,	REQ_YES),
	);

	var $table = 'media_category';
	var $condition_construct = array('categoryID = %1$d', 'categoryID');

	function vB_DataManager_Media_Category(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);
	}

	function verify_catName(&$catName)
	{
		$catName = trim(strip_tags($catName));

		if ($this->registry->options['titlemaxchars'] && (vbstrlen($catName) > $this->registry->options['titlemaxchars']))
		{
			$this->error('media_category_long', vbstrlen($catName), $this->registry->options['titlemaxchars']);
			return false;
		}

		if (vbstrlen($catName) < 5)
		{
			$this->error('media_category_short', vbstrlen($catName), 5);
			return false;
		}

		return true;
	}

	function verify_catDesc(&$catDesc)
	{
		$catDesc = trim(strip_tags($catDesc));

		return true;
	}
}

?>