<?php
#################################################################################### ITRADER CREDITS
#  EOC_Jason from EXTREME Overclocking -2008
#  iTrader Front page extension, by Giovanni Martinez, aka Gio~logist, http://www.provb.org/ -2008
#    vbEnhancer.com 2008-

// 'ir' = rateid
// 'ic' = commentid

################################################################################ BASIC CONFIGURATION
error_reporting(E_ALL & ~E_NOTICE);

######################################################################### DEFINE IMPORTANT CONSTANTS
define('ITAB', true);
define('THIS_SCRIPT', 'itrader_main');
define('CSRF_PROTECTION', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('itrader','posting','user');

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array(
'itrader_main',
'itrader_topbits',
'itrader_shamebits',
'itrader_recentbits',
'itrader_search',
'itrader_search_bits',
'itrader_search_head'
);

$actiontemplates = array(
'options' => array(
	'USERCP_SHELL',
	'usercp_nav_folderbit',
	'itrader_options'
	),
);

################################################################################### REQUIRE BACK-END
require_once('./global.php');
require_once(DIR . '/itrader_global.php');
require_once(DIR . '/includes/functions_user.php');

################################################################################## START MAIN SCRIPT
if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'main';
}

################################################################################## DISPLAY MAIN PAGE
if ($_REQUEST['do'] == 'main')
{
	$viewuser['rateid'] = $vbulletin->input->clean_gpc('r', 'ir', TYPE_UINT);
	$viewuser['pagenumber'] = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
	$viewuser['perpage'] = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_UINT);
	$viewuser['viewtype'] = $vbulletin->input->clean_gpc('r', 'iv', TYPE_UINT);

	$mainpagelimit = $vbulletin->options['itrader_ext_mainpagelimit'];

	# First Column
	itrader_user($userinfo);

	# Second Column
	itrader_second_column($userinfo);

	# Query The Ratings Now.
	$query_field = $query_where = '';

	$counttotal = $vbulletin->db->query_first_slave("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "itrader
	");

	$countmembers = $vbulletin->db->query_first_slave("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "user
		WHERE itrader_total != '0'
	");

	$counttoday = $vbulletin->db->query_first_slave("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "itrader
		WHERE dateline >= " . mktime(0,0,0,date('m'),date('d'),date('Y')) . "
	");
	

	if ($vbulletin->options['itrader_main_display'] & 2)
	{
		# iTrader Top Traders
		$itrader_top_get = $vbulletin->db->query_read_slave("
			SELECT itrader_total, itrader_pcnt, username, userid, joindate
			FROM " . TABLE_PREFIX . "user
			WHERE itrader_total > 0
			ORDER BY itrader_total DESC
			LIMIT $mainpagelimit
		");
		while ($itrader_top = $vbulletin->db->fetch_array($itrader_top_get))
		{
			$itrader_top['datejoined'] = vbdate($vbulletin->options['dateformat'], $itrader_top['joindate']);
			$templater = vB_Template::create('itrader_topbits');
				$templater->register('itrader_top', $itrader_top);
			$itrader_topbits .= $templater->render();
		}
	}

	if ($vbulletin->options['itrader_main_display'] & 4)
	{
		# iTrader Hall Of Shame
		$itrader_shame_get = $vbulletin->db->query_read_slave("
			SELECT itrader_total, itrader_pcnt, username, userid, joindate
			FROM " . TABLE_PREFIX . "user
			WHERE itrader_total < 0
			ORDER BY itrader_total ASC
			LIMIT $mainpagelimit
		");
		while ($itrader_shame = $vbulletin->db->fetch_array($itrader_shame_get))
		{
			$itrader_shame['datejoined'] = vbdate($vbulletin->options['dateformat'], $itrader_shame['joindate']);
			$templater = vB_Template::create('itrader_shamebits');
				$templater->register('itrader_shame', $itrader_shame);
			$itrader_shamebits .= $templater->render();
		}
	}

	if ($vbulletin->options['itrader_main_display'] & 1)
	{
		# Recent Ratings
		$itrader_recent_get = $vbulletin->db->query_read_slave("
			SELECT itrader.*, user.username, user.itrader_total, user.itrader_pcnt,
				rated.userid AS rated_userid, rated.username as rated_username, rated.itrader_total AS rated_total,
				itrader.rating AS itrader_rating, itrader.buyselltrade AS itrader_buyselltrade
			FROM " . TABLE_PREFIX . "itrader as itrader
			LEFT JOIN " . TABLE_PREFIX . "user as user ON " . ($viewuser['viewtype'] == 4 ? 'itrader.rateduserid' : 'itrader.userid') . " = user.userid
			LEFT JOIN " . TABLE_PREFIX . "user AS rated ON (itrader.rateduserid = rated.userid)
			ORDER BY itrader.dateline DESC
			LIMIT $mainpagelimit
		");


		while ($itrader_recent = $vbulletin->db->fetch_array($itrader_recent_get))
		{
			$itrader_recent['datejoined'] = vbdate($vbulletin->options['dateformat'], $itrader_recent['joindate']);

			$templater = vB_Template::create('itrader_recentbits');
				$templater->register('itrader_recent', $itrader_recent);
			$itrader_recentbits .= $templater->render();
		}
	}

		
	$navbits = construct_navbits(array("itrader_main.php?" . $vbulletin->session->vars['sessionurl'] . "do=search" => $vbphrase['itrader']));

	$navbar = render_navbar_template($navbits);
	
	$templater = vB_Template::create('itrader_main');
		$templater->register_page_templates();
		$templater->register('countmembers', $countmembers);
		$templater->register('counttoday', $counttoday);
		$templater->register('counttotal', $counttotal);
		$templater->register('itrader', $itrader);
		$templater->register('itrader_recentbits', $itrader_recentbits);
		$templater->register('itrader_shamebits', $itrader_shamebits);
		$templater->register('itrader_topbits', $itrader_topbits);
		$templater->register('navbar', $navbar);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('userinfo', $userinfo);
	print_output($templater->render());
}

################################################################################ DISPLAY SEARCH PAGE
if ($_REQUEST['do'] == 'search')
{
	$search['pagenumber'] = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
	$search['perpage'] = $vbulletin->options['itrader_ext_resultslimit'];
	$search['viewtype'] = $vbulletin->input->clean_gpc('r', 'iv', TYPE_UINT);
	$searcher_date['datejoined'] = vbdate($vbulletin->options['dateformat'], $bbuserinfo['joindate']);

	$countresults = $vbulletin->db->query_first_slave("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "user AS user
		WHERE user.itrader_buy != '' OR user.itrader_sell != ''
	");

	$search['perpage'] = sanitize_maxposts($search['perpage']);

	if (!$search['pagenumber'])
	{
		$search['pagenumber'] = 1;
	}

	$limitlower = ($search['pagenumber'] - 1) * $search['perpage'];
	$limitupper = $search['pagenumber'] * $search['perpage'];

	if ($limitupper > $countresults['total'])
	{
		$limitupper = $countresults['total'];
		if ($limitlower > $countresults['total'])
		{
			$limitlower = ($countresults['total'] - $search['perpage']) - 1;
		}
	}

	$pagenav = construct_page_nav($search['pagenumber'], $search['perpage'], $countresults['total'], "itrader_main.php?" . $vbulletin->session->vars['sessionurl'] . "do=search" . (!empty($search['perpage']) ? "&amp;pp=" . $search['perpage'] : ""));

	$search_results = $vbulletin->db->query_read_slave("
		SELECT user.userid, user.username, user.itrader_total, user.itrader_pcnt, user.itrader_buy,
		user.itrader_sell, user.joindate, user.avatarrevision,
		avatar.avatarpath,NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline AS avatardateline, customavatar.width AS avwidth, customavatar.height AS avheight
		FROM " . TABLE_PREFIX . "user AS user
		LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON(avatar.avatarid = user.avatarid)
		LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON(customavatar.userid = user.userid)
		WHERE user.itrader_buy != '' OR user.itrader_sell != ''
		ORDER BY user.itrader_total DESC
		LIMIT $limitlower, " . $search['perpage'] . "
	");

	while ($search = $vbulletin->db->fetch_array($search_results))
	{
		$avwidth = '';
		$avheight = '';
		if ($search['avatarid'])
		{
			$avatarurl = $search['avatarpath'];
		}
		else
		{
			if ($search['hascustomavatar'] AND $vbulletin->options['avatarenabled'])
			{
				if ($vbulletin->options['usefileavatar'])
				{
					$avatarurl = $vbulletin->options['avatarurl'] . "/avatar$search[userid]_$search[avatarrevision].gif";
				}
				else
				{
					$avatarurl = 'image.php?' . $vbulletin->session->vars['sessionurl'] . "u=$search[userid]&amp;dateline=$search[avatardateline]";
				}
				if ($search['avheight'] AND $search['avwidth'])
				{
					$avheight = "height=\"$search[avheight]\"";
					$avwidth = "width=\"$search[avwidth]\"";
				}
			}
			else
			{
				$avatarurl = 'images/misc/unknown.gif';
			}
		}
		if ($avatarurl == '')
		{
			$show['avatar'] = false;
		}
		else
		{
			$show['avatar'] = true;
		}

		$search['datejoined'] = vbdate($vbulletin->options['dateformat'], $search['joindate']);
		$templater = vB_Template::create('itrader_search_bits');
			$templater->register('avatarurl', $avatarurl);
			$templater->register('search', $search);
		$result_bits .= $templater->render();
	}

	if(empty($result_bits))
	{
		eval(standard_error(fetch_error('itrader_error_no_user'), '', false));
	}

	$navbits = construct_navbits(array("itrader_main.php?" . $vbulletin->session->vars['sessionurl'] => $vbphrase['itrader'], '' => $vbphrase['itrader_ext_search']));

	$navbar = render_navbar_template($navbits);
	
	$search_head .= vB_Template::create('itrader_search_head')->render();

	$templater = vB_Template::create('itrader_search');
		$templater->register_page_templates();
		$templater->register('countresults', $countresults);
		$templater->register('navbar', $navbar);
		$templater->register('pagenav', $pagenav);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('result_bits', $result_bits);
		$templater->register('search_head', $search_head);
	print_output($templater->render());
}

//  ######################### DO RULES #########################
if ($_GET['do'] == 'rules')
{
$impressum_title = $vbphrase['eimpressum_nav_haftung'];
$vbphrase['eimpressum_text_haftung'] = $parser->do_parse($vbphrase['eimpressum_text_haftung'], 1, 1, 1, 1, 1); 

	if ($vbulletin->options['ehaftung_active'])
	{
		$navbits = construct_navbits(array(
			'' => $vbphrase['eimpressum_nav_haftung']
		));

		$navbar = render_navbar_template($navbits);
		$impressum_content = $vbphrase['eimpressum_text_haftung'];

		$templater = vB_Template::create('eimpressum');
			$templater->register_page_templates();
			$templater->register('navbar', $navbar);
		print_output($templater->render());
	}
	else
	{
		eval(standard_error(fetch_error('invalidid', $vbphrase['eimpressum_not_active'], $vbulletin->options['contactuslink'])));
	}
}

###################################################################################### FIND CUSTOMER
if ($_REQUEST['do'] == 'findcustomer')
{
	if (!$vbulletin->GPC['userid']) print_no_permission();

	# Get info for user we are viewing / rating.
	$userinfo = verify_id('user', $vbulletin->GPC['userid'], 1, 1, 0);

	$search['pagenumber'] = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
	$search['perpage'] = $vbulletin->options['itrader_ext_resultslimit'];
	$search['viewtype'] = $vbulletin->input->clean_gpc('r', 'iv', TYPE_UINT);
	$sellerproducts = $vbulletin->input->clean_gpc('r', 'itrader_sell', TYPE_NOHTML);

	
	# Get What Seller Is Selling
	$searcherinfo = $vbulletin->db->query_read_slave("
		SELECT itrader_sell, itrader_buy
		FROM " . TABLE_PREFIX . "user
		WHERE userid = " . $userinfo['userid'] . "
	");

	$searcher_get = $vbulletin->db->fetch_array($searcherinfo);

	$searcher_date['datejoined'] = vbdate($vbulletin->options['dateformat'], $bbuserinfo['joindate']);
	$sellerproducts = strtolower($sellerproducts);
	$sellerproducts = str_replace(" ", "%' OR user.itrader_buy LIKE '%",$sellerproducts);

	$countresults = $vbulletin->db->query_first_slave("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "user AS user
		WHERE user.itrader_buy != '' AND user.itrader_buy LIKE  '%$sellerproducts%'
	");

	$search['perpage'] = sanitize_maxposts($search['perpage']);

	if (!$search['pagenumber']) $search['pagenumber'] = 1;

	$limitlower = ($search['pagenumber'] - 1) * $search['perpage'];
	$limitupper = $search['pagenumber'] * $search['perpage'];

	if ($limitupper > $countresults['total'])
	{
		$limitupper = $countresults['total'];
		if ($limitlower > $countresults['total'])
		{
			$limitlower = ($countresults['total'] - $search['perpage']) - 1;
		}
	}

	$pagenav = construct_page_nav($search['pagenumber'], $search['perpage'], $countresults['total'], "itrader_main.php?" . $vbulletin->session->vars['sessionurl'] . "do=search" . (!empty($search['perpage']) ? "&amp;pp=" . $search['perpage'] : ""));

	$search_results = $vbulletin->db->query_read_slave("
		SELECT user.itrader_buy, user.itrader_sell, user.userid, user.username, user.itrader_total, user.itrader_pcnt, user.joindate, user.avatarrevision,
		avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline AS avatardateline, customavatar.width AS avwidth, customavatar.height AS avheight
		FROM " . TABLE_PREFIX . "user AS user
		LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON(avatar.avatarid = user.avatarid)
		LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON(customavatar.userid = user.userid)
		WHERE user.itrader_buy != '' AND user.itrader_buy LIKE  '%$sellerproducts%'
		ORDER BY user.itrader_total DESC
		LIMIT $limitlower, " . $search['perpage'] . "
	");
	while ($search = $vbulletin->db->fetch_array($search_results))
	{
		$avwidth = '';
		$avheight = '';
		if ($search['avatarid'])
		{
			$avatarurl = $search['avatarpath'];
		}
		else
		{
			if ($search['hascustomavatar'] AND $vbulletin->options['avatarenabled'])
			{
				if ($vbulletin->options['usefileavatar'])
				{
					$avatarurl = $vbulletin->options['avatarurl'] . "/avatar$search[userid]_$search[avatarrevision].gif";
				}
				else
				{
					$avatarurl = 'image.php?' . $vbulletin->session->vars['sessionurl'] . "u=$search[userid]&amp;dateline=$search[avatardateline]";
				}
				if ($search['avheight'] AND $search['avwidth'])
				{
					$avheight = "height=\"$search[avheight]\"";
					$avwidth = "width=\"$search[avwidth]\"";
				}
			}
			else
			{
				$avatarurl = 'images/misc/unknown.gif';
			}
		}
		if ($avatarurl == '')
		{
			$show['avatar'] = false;
		}
		else
		{
			$show['avatar'] = true;
		}

		$search['datejoined'] = vbdate($vbulletin->options['dateformat'], $search['joindate']);
		$templater = vB_Template::create('itrader_search_bits');
			$templater->register('avatarurl', $avatarurl);
			$templater->register('search', $search);
			$templater->register('userinfo', $userinfo);
		$result_bits .= $templater->render();
	}
	if(empty($result_bits))
	{
		eval(standard_error(fetch_error('itrader_error_no_customer'), '', false));
	}
	$navbits = construct_navbits(array("itrader_main.php?" . $vbulletin->session->vars['sessionurl'] => $vbphrase['itrader'], '' => $vbphrase['itrader_ext_findcustomer']));



	$navbar = render_navbar_template($navbits);
	
	$search_head .= vB_Template::create('itrader_search_head')->render();

	$templater = vB_Template::create('itrader_search');
		$templater->register_page_templates();
		$templater->register('countresults', $countresults);
		$templater->register('navbar', $navbar);
		$templater->register('pagenav', $pagenav);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('result_bits', $result_bits);
		$templater->register('search_head', $search_head);
	print_output($templater->render());
}

######################################################################################## FIND SELLER
if ($_REQUEST['do'] == 'findseller')
{
	if (!$vbulletin->GPC['userid']) print_no_permission();

	# Get info for user we are viewing / rating.
	$userinfo = verify_id('user', $vbulletin->GPC['userid'], 1, 1, 0);
	$search['pagenumber'] = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
	$search['perpage'] = $vbulletin->options['itrader_ext_resultslimit'];
	$search['viewtype'] = $vbulletin->input->clean_gpc('r', 'iv', TYPE_UINT);
	$buyerwants = $vbulletin->input->clean_gpc('r', 'itrader_buy', TYPE_NOHTML);


	# Get What Seller Is Selling
	$searcherinfo = $vbulletin->db->query_read("
		SELECT itrader_buy, itrader_sell
		FROM " . TABLE_PREFIX . "user
		WHERE userid = " . $userinfo['userid'] . "
	");

	$searcher_get = $vbulletin->db->fetch_array($searcherinfo);

	$searcher_date['datejoined'] = vbdate($vbulletin->options['dateformat'], $bbuserinfo['joindate']);
	//$buyerwants = $searcher_get['itrader_buy'];
	$buyerwants = strtolower($buyerwants);
	$buyerwants = str_replace(" ", "%' OR user.itrader_sell LIKE '%",$buyerwants);

	$countresults = $vbulletin->db->query_first("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "user AS user
		WHERE user.itrader_sell != '' AND user.itrader_sell LIKE '%$buyerwants%'
	");

	$search['perpage'] = sanitize_maxposts($search['perpage']);

	if (!$search['pagenumber']) $search['pagenumber'] = 1;

	$limitlower = ($search['pagenumber'] - 1) * $search['perpage'];
	$limitupper = $search['pagenumber'] * $search['perpage'];

	if ($limitupper > $countresults['total'])
	{
		$limitupper = $countresults['total'];
		if ($limitlower > $countresults['total'])
		{
			$limitlower = ($countresults['total'] - $search['perpage']) - 1;
		}
	}

	$pagenav = construct_page_nav($search['pagenumber'], $search['perpage'], $countresults['total'], "itrader_main.php?" . $vbulletin->session->vars['sessionurl'] . "do=search" . (!empty($search['perpage']) ? "&amp;pp=" . $search['perpage'] : ""));

	$search_results = $vbulletin->db->query_read_slave("
		SELECT user.itrader_buy, user.itrader_sell, user.userid, user.username, user.itrader_total, user.itrader_pcnt, user.joindate, user.avatarrevision,
		avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline AS avatardateline, customavatar.width AS avwidth, customavatar.height AS avheight
		FROM " . TABLE_PREFIX . "user AS user
		LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON(avatar.avatarid = user.avatarid)
		LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON(customavatar.userid = user.userid)
		WHERE user.itrader_sell != '' AND user.itrader_sell LIKE '%$buyerwants%'
		ORDER BY user.itrader_total DESC
		LIMIT $limitlower, " . $search['perpage'] . "
	");
	while ($search = $vbulletin->db->fetch_array($search_results))
	{
		$avwidth = '';
		$avheight = '';
		if ($search['avatarid'])
		{
			$avatarurl = $search['avatarpath'];
		}
		else
		{
			if ($search['hascustomavatar'] AND $vbulletin->options['avatarenabled'])
			{
				if ($vbulletin->options['usefileavatar'])
				{
					$avatarurl = $vbulletin->options['avatarurl'] . "/avatar$search[userid]_$search[avatarrevision].gif";
				}
				else
				{
					$avatarurl = 'image.php?' . $vbulletin->session->vars['sessionurl'] . "u=$search[userid]&amp;dateline=$search[avatardateline]";
				}
				if ($search['avheight'] AND $search['avwidth'])
				{
					$avheight = "height=\"$search[avheight]\"";
					$avwidth = "width=\"$search[avwidth]\"";
				}
			}
			else
			{
				$avatarurl = 'images/misc/unknown.gif';
			}
		}
		if ($avatarurl == '')
		{
			$show['avatar'] = false;
		}
		else
		{
			$show['avatar'] = true;
		}

		$search['datejoined'] = vbdate($vbulletin->options['dateformat'], $search['joindate']);
		$templater = vB_Template::create('itrader_search_bits');
			$templater->register('avatarurl', $avatarurl);
			$templater->register('search', $search);
		$result_bits .= $templater->render();
	}
	if(empty($result_bits))
	{
		eval(standard_error(fetch_error('itrader_error_no_seller'), '', false));
	}
	$navbits = construct_navbits(array("itrader_main.php?" . $vbulletin->session->vars['sessionurl'] => $vbphrase['itrader'], '' => $vbphrase['itrader_ext_findseller']));

	$navbar = render_navbar_template($navbits);

	if($show['member']) $search_head .= vB_Template::create('itrader_search_head')->render();

	$templater = vB_Template::create('itrader_search');
		$templater->register_page_templates();
		$templater->register('countresults', $countresults);
		$templater->register('navbar', $navbar);
		$templater->register('pagenav', $pagenav);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('result_bits', $result_bits);
		$templater->register('search_head', $search_head);
	print_output($templater->render());
}

########################################################################## DISPLAY OPTIONS IN USERCP
if ($_REQUEST['do'] == 'options')
{
	if ($vbulletin->userinfo['userid'] == 0)
	{
		print_no_permission();
	}

	// build the cp nav
	require_once(DIR . '/includes/functions_user.php');
	construct_usercp_nav('itrader_options');

	# build navbar
	$navbits = construct_navbits(array(
		"usercp.php?" . $vbulletin->session->vars['sessionurl'] => $vbphrase['user_control_panel'],
		'' => $vbphrase['itrader_ext_youroptions']
	));
	
	$navbar = render_navbar_template($navbits);
	
	# Get info for user we are viewing / rating.
	$userinfo = verify_id('user', $vbulletin->GPC['userid'], 1, 1, 0);
	$userinfo = $vbulletin->db->query_first_slave("
		SELECT itrader_buy, itrader_sell, userid
		FROM " . TABLE_PREFIX . "user
		WHERE userid = " . $userinfo['userid'] . "
	");
	
	$page_templater = vB_Template::create('itrader_options');
	$page_templater->register('userinfo', $userinfo);
	
	$templater = vB_Template::create('USERCP_SHELL');
		$templater->register_page_templates();
		$templater->register('cpnav', $cpnav);
		$templater->register('HTML', $page_templater->render());
		$templater->register('navbar', $navbar);
		$templater->register('navclass', $navclass);
		$templater->register('onload', $onload);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('includecss', $includecss);
		$templater->register('userinfo', $userinfo);
	print_output($templater->render());
}

########################################################################## UPDATE OPTIONS FOM USERCP
if ($_REQUEST['do'] == 'update')
{
	if ($vbulletin->userinfo['userid'] == 0)
	{
		print_no_permission();
	}

	$update['update_buy'] = $vbulletin->input->clean_gpc('p', 'update_buy', TYPE_NOHTML);
	$update['update_sell'] = $vbulletin->input->clean_gpc('p', 'update_sell', TYPE_NOHTML);

	# Get info for user we are viewing / rating.
	$userinfo = verify_id('user', $vbulletin->GPC['userid'], 1, 1, 0);

	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "user
		SET
		itrader_buy = '" . $vbulletin->db->escape_string($update['update_buy']) . "',
		itrader_sell = '" . $vbulletin->db->escape_string($update['update_sell']) . "'
		WHERE userid = " . $userinfo['userid'] . "
	");

	eval(print_standard_redirect('redirect_updatethanks', 1, 1));
}


?>
