<?php
#################################################################################### ITRADER CREDITS
#  EOC_Jason from EXTREME Overclocking -2008
#    vbEnhancer.com 2008-

################################################################################ BASIC CONFIGURATION
error_reporting(E_ALL & ~E_NOTICE);

######################################################################### DEFINE IMPORTANT CONSTANTS
define('ITAB', true);
define('THIS_SCRIPT', 'itrader_detail');
define('CSRF_PROTECTION', true);
define('GET_EDIT_TEMPLATES', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('itrader','posting');

// get special data templates from the datastore
$specialtemplates = array('bbcodecache');

// pre-cache templates used by all actions
$globaltemplates = array('itrader_detail',
	'itrader_detail_commentbits',
	'itrader_detail_feedback',
	'itrader_userbits',
	'itrader_user_sidebar'
);

################################################################################### REQUIRE BACK-END
require_once('./global.php');
require_once(DIR . '/itrader_global.php');

################################################################################## START MAIN SCRIPT
if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'viewdetail';
}

if (empty($userinfo['userid']))
{
    print_no_permission();
}

################################################################################# VIEW MEMBER DETAIL
if ($_REQUEST['do'] == 'viewdetail')
{
	$viewdetail['rateid'] = $vbulletin->input->clean_gpc('r', 'ir', TYPE_UINT);

	# First Column
	itrader_user($userinfo);

	# Second Column
	itrader_second_column($userinfo);

	# Sidebar
	$show['lastactivity'] = true;
	$userinfo['lastactivitydate'] = vbdate($vbulletin->options['dateformat'], $userinfo['lastactivity'], true);
	$userinfo['lastactivitytime'] = vbdate($vbulletin->options['timeformat'], $userinfo['lastactivity'], true);

	$userinfo['datejoined'] = vbdate($vbulletin->options['dateformat'], $userinfo['joindate']);

	$show['email'] = ($vbulletin->options['enableemail'] AND $vbulletin->options['displayemails'] ? true : false);
	$show['pm'] = ($userinfo['receivepm'] AND $userperms['pmquota'] > 0 ? true : false);

	# Query The Ratings Now.
	$query_field = $query_where = '';

	# Various View Types For Filtering Comments
	switch ($viewuser['viewtype'])
	{
	case 1:
		# From Buyers Only
		$query_field = 'itrader.rateduserid';
		$query_where = 'AND itrader.buyselltrade = 2';
		break;
	case 2:
		# From Sellers Only
		$query_field = 'itrader.rateduserid';
		$query_where = 'AND itrader.buyselltrade = 1';
		break;
	case 3:
		# From Trades Only
		$query_field = 'itrader.rateduserid';
		$query_where = 'AND itrader.buyselltrade = 3';
		break;
	case 4:
		# Feedback Left For Others
		$query_field = 'itrader.userid';
		break;
	default:
		# All Feedback From Other People
		$query_field = 'itrader.rateduserid';
	}

	$countposts = $vbulletin->db->query_first_slave("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "itrader AS itrader
		WHERE $query_field = " . $userinfo['userid'] . "
		$query_where
	");
	$itraders = $vbulletin->db->query_read_slave("
		SELECT itrader.*, user.username, user.itrader_total, user.itrader_pcnt, B.userid AS b_userid
		FROM " . TABLE_PREFIX . "itrader as itrader
		LEFT JOIN " . TABLE_PREFIX . "user as user ON itrader.userid = user.userid
		LEFT JOIN " . TABLE_PREFIX . "itrader AS B ON (itrader.rateid = B.rateid AND itrader.userid != B.userid)
		WHERE itrader.rateid = " . $viewdetail['rateid'] . "
		ORDER BY itrader.dateline
	");

	while ($itrader = $vbulletin->db->fetch_array($itraders))
	{
		# Checking to make sure the viewing person is one of the two in the deal.
		itrader_checkperms(256, false, $itrader);

		# Check for edit time.
		if (itrader_checkperms(22, true, $itrader)) $itrader['allowedit'] = true;

		$itrader['dateline'] = vbdate($vbulletin->options['dateformat'],$itrader['dateline']);
		$itrader['subject'] = htmlspecialchars_uni($itrader['subject']);
		$templater = vB_Template::create('itrader_userbits');
			$templater->register('itrader', $itrader);
			$templater->register('userinfo', $userinfo);
		$itrader_userbits .= $templater->render();
	}

	$viewdetail['pagenumber'] = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
	$viewdetail['perpage'] = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_UINT);

	$countposts = $vbulletin->db->query_first("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "itrader_comments
		WHERE rateid = " . $viewdetail['rateid'] . "
	");

	$viewdetail['perpage'] = sanitize_maxposts($viewdetail['perpage']);
	
	if (!$viewdetail['pagenumber']) $viewdetail['pagenumber'] = 1;
	
	$limitlower = ($viewdetail['pagenumber'] - 1) * $viewdetail['perpage'];
	$limitupper = $viewdetail['pagenumber'] * $viewdetail['perpage'];

	if ($limitupper > $countposts['total'])
	{
		$limitupper = $countposts['total'];
		if ($limitlower > $countposts['total'])
		{
			$limitlower = ($countposts['total'] - $viewdetail['perpage']) - 1;
		}
	}

	if ($limitlower < 0) $limitlower = 0;

	$pagenav = construct_page_nav($viewdetail['pagenumber'], $viewdetail['perpage'], $countposts['total'], "itrader_detail.php?" . $vbulletin->session->vars['sessionurl'] . "ir=" . $viewdetail['rateid'],(!empty($viewdetail['perpage']) ? "&amp;pp=" . $viewdetail['perpage'] : ""));

	$itraders = $vbulletin->db->query_read_slave("
		SELECT itrader_comments.*, user.username, user.itrader_total, user.itrader_pcnt
		FROM " . TABLE_PREFIX . "itrader_comments as itrader_comments
		LEFT JOIN " . TABLE_PREFIX . "user as user ON itrader_comments.userid = user.userid
		WHERE rateid = " . $viewdetail['rateid'] . " 
		ORDER BY dateline ASC
		LIMIT $limitlower, " . $viewdetail['perpage'] . "
	");

	require_once(DIR . '/includes/class_postbit.php');
	require_once(DIR . '/includes/class_bbcode.php');

	$parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());
	
	# Trader Ratings Member Feedback
	while ($itrader = $vbulletin->db->fetch_array($itraders))
	{
		++$postcount;
		$itrader['postdate'] = vbdate($vbulletin->options['dateformat'],$itrader['dateline']);
		$itrader['posttime'] = vbdate($vbulletin->options['timeformat'], $itrader['dateline']);
		$itrader['comment'] = $parser->do_parse($itrader['comment'],0,1,1,0,1,0); 

		if (itrader_checkperms(512,true)) $itrader['showip'] = true;

		if (itrader_checkperms(22,true,$itrader)) $itrader['allowedit'] = true;

		$templater = vB_Template::create('itrader_detail_commentbits');
			$templater->register('itrader', $itrader);
			$templater->register('userinfo', $userinfo);
		$itrader_detail_commentbits .= $templater->render();
	}

	$navbits = construct_navbits(array(
		"itrader.php?$session[sessionurl]u=$userinfo[userid]" => $vbphrase['itrader'],
		'' => $vbphrase['itrader_comments'] . ' #' . vb_number_format($viewdetail['rateid'],0)
	));
	$navbar = render_navbar_template($navbits);

	$templater = vB_Template::create('itrader_user_sidebar');
		$templater->register('countposts', $countposts);
		$templater->register('itrader', $itrader);
		$templater->register('userinfo', $userinfo);
	$itrader_usersidebar .= $templater->render();

	$templater = vB_Template::create('itrader_detail');
		$templater->register_page_templates();
		$templater->register('itrader', $itrader);
		$templater->register('itrader_detail_commentbits', $itrader_detail_commentbits);
		$templater->register('itrader_userbits', $itrader_userbits);
		$templater->register('itrader_usersidebar', $itrader_usersidebar);
		$templater->register('navbar', $navbar);
		$templater->register('pagenav', $pagenav);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('userinfo', $userinfo);
		$templater->register('viewdetail', $viewdetail);
	print_output($templater->render());
}

############################################################################## SUBMIT EDITED COMMENT
if ($_REQUEST['do'] == 'submiteditcomment')
{
	$itrader['commentid'] = $vbulletin->input->clean_gpc('r', 'ic', TYPE_UINT);
	$itrader['delete'] = $vbulletin->input->clean_gpc('r', 'delete', TYPE_INT);
	
	$check = $vbulletin->db->query_first_slave("
		SELECT userid, rateid, dateline
		FROM " . TABLE_PREFIX . "itrader_comments
		WHERE commentid = " . $itrader['commentid'] . " 
	");

	# A person can only edit their own comments + edit time check.
	itrader_checkperms(22, false, $check);

	if($itrader['delete'] == 1)
	{
		$vbulletin->db->query_write("
			DELETE FROM " . TABLE_PREFIX . "itrader_comments
			WHERE commentid = " . $itrader['commentid'] . "
		");
		
		# Redirect to the detail page.
		$vbulletin->url = "itrader_detail.php?".$vbulletin->session->vars['sessionurl']."ir=" . $check['rateid'] . "&amp;u=".$userinfo['userid'];
		eval(print_standard_redirect('redirect_postthanks'));
	}
	else
	{
		$show['editcomment'] = true;
		$_REQUEST['do'] = 'submitcomment';
	}
}

################################################################## SUBMIT A COMMENT, REPORT TO EMAIL
if ($_REQUEST['do'] == 'submitcomment')
{
	$itrader['rateid'] = $vbulletin->input->clean_gpc('r', 'ir', TYPE_UINT);
	$itrader['message'] = $vbulletin->input->clean_gpc('r', 'message', TYPE_STR);
	$itrader['wysiwyg'] = $vbulletin->input->clean_gpc('r', 'wysiwyg', TYPE_BOOL);
	
	// Don't run this unless it is a new blank comment.
	if (!$show['editcomment'])
	{
		// Just a sanity check.
		$check = $vbulletin->db->query_first_slave("
			SELECT userid, rateduserid
			FROM " . TABLE_PREFIX . "itrader
			WHERE rateid = " . $itrader['rateid'] . "
		");
		itrader_checkperms(258, false, $check);
	}
	
	if($vbulletin->options['templateversion'] > '4.1.3')
	{
		if ($itrader['wysiwyg'])
		{
			require_once(DIR . '/includes/class_wysiwygparser.php');
			$html_parser = new vB_WysiwygHtmlParser($vbulletin);
			$itrader['message'] = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 0);
		}
		else
		{
			$itrader['message'] =& $itrader['message'];
		}
	}else{
		if ($itrader['wysiwyg'])
		{
			require_once(DIR . '/includes/functions_wysiwyg.php');
			$itrader['message'] = convert_wysiwyg_html_to_bbcode($itrader['message']);
		}
	}
	
	$dataman =& datamanager_init('iTrader', $vbulletin);
	$dataman->set_info('parseurl', 1);
	$dataman->itrader_verify_pagetext($itrader['message']);

	if ($dataman->errors OR !$itrader['message'])
	{
		$errormessage = $vbphrase['itrader_error_details'];
		$errorlist .= vB_Template::create('newpost_errormessage')->render();
	}

	if ($errorlist)
	{
		# We had an error so lets go back to the comment page so they can fix it.
		$show['errors'] = true;
		$_REQUEST['do'] = 'newcomment';
	}
	else
	{
		if ($show['editcomment'])
		{
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "itrader_comments
				SET comment = '" . $vbulletin->db->escape_string($itrader['message']) . "'
				WHERE commentid = " . $itrader['commentid'] . "
			");
		}
		else
		{
			$vbulletin->db->query_write("
				INSERT INTO " . TABLE_PREFIX . "itrader_comments
				SET rateid = " . $itrader['rateid'] . ",
				dateline = " . TIMENOW . ",
				userid = " . $vbulletin->userinfo['userid'] . ",
				comment = '" . $vbulletin->db->escape_string($itrader['message']) . "',
				ipaddress = '" . IPADDRESS . "'
			");
			# Just a quick check so we don't PM ourself.
			if ($vbulletin->userinfo['userid'] == $userinfo['userid'])
			{
				if ($vbulletin->userinfo['userid'] != $check['userid'])
				{
					$userinfo = verify_id('user', $check['userid'], 1, 1, 0);
					$userperms = cache_permissions($userinfo, false);
				}
				elseif ($vbulletin->userinfo['userid'] != $check['rateduserid'])
				{
					$userinfo = verify_id('user', $check['rateduserid'], 1, 1, 0);
					$userperms = cache_permissions($userinfo, false);
				}
				else
				{
					print_no_permission();
				}
			}

			if ($userinfo['receivepm'] AND $userperms['pmquota'] > 0)
			{
				# Send a PM to the rated user.
				$vbphrase['itrader_pm_message_x'] = construct_phrase($vbphrase['itrader_pm_message'], $vbulletin->userinfo['username'], $vbulletin->options['bburl'], $itrader['rateid'], $userinfo['userid']);
				$cantrackpm = $permissions['pmpermissions'] & $vbulletin->bf_ugp_pmpermissions['cantrackpm'];

				$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY); 
				$pmdm->set('fromuserid', $vbulletin->userinfo['userid']); 
				$pmdm->set('fromusername', $vbulletin->userinfo['username']); 
				$pmdm->set('title', $vbphrase['itrader_pm_subject']); 
				$pmdm->set('message', $vbphrase['itrader_pm_message_x']); 
				$pmdm->set_recipients($userinfo['username'], $permissions); 
				$pmdm->set('dateline', TIMENOW);  
				$pmdm->set_info('receipt',1);
				$pmdm->set_info('cantrackpm', $cantrackpm);
				$pmdm->pre_save();
			
				if (empty($pmdm->errors)) $pmdm->save();
			}				
		}
		
		# Redirect back to the comment detail page
		$vbulletin->url = "itrader_detail.php?".$vbulletin->session->vars['sessionurl']."ir=" . $itrader['rateid'] . "&amp;u=" . $userinfo['userid'];
		eval(print_standard_redirect('redirect_postthanks'));
		
	}

}

############################################################## EDIT EXISTING COMMENT WHEN PERMISSION
if ($_REQUEST['do'] == 'editcomment')
{
	$itrader['commentid'] = $vbulletin->input->clean_gpc('r', 'ic', TYPE_UINT);

	//Get the info to edit.
	$itrader = $vbulletin->db->query_first("
		SELECT * FROM " . TABLE_PREFIX . "itrader_comments
		WHERE commentid = " . $itrader['commentid'] . " 
	");

	// A person can only edit their own feedback + edit time check.
	itrader_checkperms(22, false, $itrader);

	$itrader['message'] = $itrader['comment'];

	$show['editcomment'] = true;
	$_REQUEST['do'] = 'newcomment';
}

################################################################################# POST A NEW COMMENT
if ($_REQUEST['do'] == 'newcomment')
{
	// Don't run this unless it is a new blank comment.
	if (!$show['errors'] AND !$show['editcomment'])
	{
		$itrader['rateid'] = $vbulletin->input->clean_gpc('r', 'ir', TYPE_UINT);

		# Just a sanity check.
		$check = $vbulletin->db->query_first("
			SELECT userid, rateduserid
			FROM " . TABLE_PREFIX . "itrader
			WHERE rateid = " . $itrader['rateid'] . "
		");
		itrader_checkperms(258, false, $check);
	}
	
	require_once(DIR . '/includes/functions_editor.php');
	$show['wysiwyg'] = is_wysiwyg_compatible();
	$editorid = construct_edit_toolbar($itrader['message'], 0, 0, 0, 1);

	$navbits = construct_navbits(array(
		"itrader.php?$session[sessionurl]u=$userinfo[userid]" => $vbphrase['itrader'],
		'' => $userinfo['username']
	));

	$navbar = render_navbar_template($navbits);

	$templater = vB_Template::create('itrader_detail_commentbits');
		$templater->register('itrader', $itrader);
		$templater->register('userinfo', $userinfo);
	$itrader_detail_commentbits .= $templater->render();
	
	$templater = vB_Template::create('itrader_detail_feedback');
		$templater->register_page_templates();
		$templater->register('editorid', $editorid);
		$templater->register('itrader', $itrader);
		$templater->register('itrader_detail_commentbits', $itrader_detail_commentbits);
		$templater->register('messagearea', $messagearea);
		$templater->register('navbar', $navbar);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('userinfo', $userinfo);
		$templater->register('viewdetail', $viewdetail);
	print_output($templater->render());
}

?>
