<?php
#################################################################################### ITRADER CREDITS
#  EOC_Jason from EXTREME Overclocking -2008
#    vbEnhancer.com 2008-


####################################################################### GENERATES ITRADER SCORE INFO
function itrader_user(&$userinfo, $calcscore = false)
{
	global $vbulletin;

	# This is the first column's data, but also can be used to update a user's score

	$userinfo['tradepos'] = $userinfo['tradeneu'] = $userinfo['tradeneg'] = $userinfo['tradeposall'] = 0;

	if (THIS_SCRIPT == 'itrader_main')
	{
		$itraders = $vbulletin->db->query_read("
			SELECT COUNT(" . ($vbulletin->options['itrader_ratestyle'] ? 'DISTINCT(userid)' : 'userid') . ") AS usercount, COUNT(*) AS usercountall, rating
			FROM " . TABLE_PREFIX . "itrader
			GROUP BY rating
		");
	}
	else
	{
		$itraders = $vbulletin->db->query_read("
			SELECT COUNT(" . ($vbulletin->options['itrader_ratestyle'] ? 'DISTINCT(userid)' : 'userid') . ") AS usercount, COUNT(*) AS usercountall, rating
			FROM " . TABLE_PREFIX . "itrader
			WHERE rateduserid = " . $userinfo['userid'] . "
			GROUP BY rating
		");
	}

	while ($itrader = $vbulletin->db->fetch_array($itraders))
	{
		switch ($itrader['rating'])
		{
			case 1:
			   $userinfo['tradepos'] = $itrader['usercount'];
			   $userinfo['tradeposall'] = $itrader['usercountall'];
			   break;
			case 0:
			   $userinfo['tradeneu'] = $itrader['usercount'];
			   break;
			case -1:
			   $userinfo['tradeneg'] = $itrader['usercount'];
			   break;
		}
	}

	$dbupdate['itrader_total'] = $userinfo['tradescore'] = $userinfo['tradepos'] - $userinfo['tradeneg'];

	$userinfo['tradescore'] = vb_number_format($userinfo['tradescore']);

	$tradeall = $userinfo['tradepos'] + $userinfo['tradeneu'] + $userinfo['tradeneg'];

	if($tradeall)
	{
		@$userinfo['tradepcnt'] = (1 - ($userinfo['tradeneg'] / $tradeall) ) * 100;
		$dbupdate['itrader_pcnt'] = round($userinfo['tradepcnt'],0);
		$userinfo['tradepcnt'] = vb_number_format($userinfo['tradepcnt'],1);
	}
	else
	{
		$userinfo['tradepcnt'] = 0.0;
		$dbupdate['itrader_pcnt'] = round($userinfo['tradepcnt'],0);
	}

		
	if (THIS_SCRIPT != 'itrader_main' AND $calcscore)
	{
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "user
			SET itrader_total = " . $dbupdate['itrader_total'] . ",
			itrader_pcnt = " . $dbupdate['itrader_pcnt'] . "
			WHERE userid = " . $userinfo['userid'] . "
		");
	}
	return;
}

#################################################################### GENERATE SECOND COLUMN OF STATS
function itrader_second_column(&$userinfo)
{
	global $vbulletin;

	if (THIS_SCRIPT == 'itrader_main')
	{
		$itraders = $vbulletin->db->query_read("
			SELECT COUNT(*) AS usercount, rating
			FROM " . TABLE_PREFIX . "itrader
			WHERE dateline >= " . mktime(0,0,0,date('m')-1,date('d'),date('Y')) . "
			GROUP BY rating
		");
	}
	else
	{
		$itraders = $vbulletin->db->query_read("
			SELECT COUNT(*) AS usercount, rating
			FROM " . TABLE_PREFIX . "itrader
			WHERE rateduserid = " . $userinfo['userid'] . "
			AND dateline >= " . mktime(0,0,0,date('m')-1,date('d'),date('Y')) . "
			GROUP BY rating
		");
	}
	while ($itrader = $vbulletin->db->fetch_array($itraders))
	{
		switch ($itrader['rating'])
		{
			case 1:
			   $userinfo['tradepos30'] = $itrader['usercount'];
			   break;
			case 0:
			   $userinfo['tradeneu30'] = $itrader['usercount'];
			   break;
			case -1:
			   $userinfo['tradeneg30'] = $itrader['usercount'];
			   break;
			default:
			   break;
		}
	}

	if (THIS_SCRIPT == 'itrader_main')
	{
		$itraders = $vbulletin->db->query_read("
			SELECT COUNT(*) AS usercount, rating
			FROM " . TABLE_PREFIX . "itrader
			WHERE dateline >= " . mktime(0,0,0,date('m')-6,date('d'),date('Y')) . "
			GROUP BY rating
		");
	}
	else
	{
		$itraders = $vbulletin->db->query_read("
			SELECT COUNT(*) AS usercount, rating
			FROM " . TABLE_PREFIX . "itrader
			WHERE rateduserid = " . $userinfo['userid'] . "
			AND dateline >= " . mktime(0,0,0,date('m')-6,date('d'),date('Y')) . "
			GROUP BY rating
		");
	}

	while ($itrader = $vbulletin->db->fetch_array($itraders))
	{
		switch ($itrader['rating'])
		{
			case 1:
			   $userinfo['tradepos180'] = $itrader['usercount'];
			   break;
			case 0:
			   $userinfo['tradeneu180'] = $itrader['usercount'];
			   break;
			case -1:
			   $userinfo['tradeneg180'] = $itrader['usercount'];
			   break;
			default:
			   break;
		}
	}

	if (THIS_SCRIPT == 'itrader_main')
	{
		$itraders = $vbulletin->db->query_read("
			SELECT COUNT(*) AS usercount, rating
			FROM " . TABLE_PREFIX . "itrader
			WHERE dateline >= " . mktime(0,0,0,date('m')-12,date('d'),date('Y')) . "
			GROUP BY rating
		");
	}
	else
	{
		$itraders = $vbulletin->db->query_read("
			SELECT COUNT(*) AS usercount, rating
			FROM " . TABLE_PREFIX . "itrader
			WHERE rateduserid = " . $userinfo['userid'] . "
			AND dateline >= " . mktime(0,0,0,date('m')-12,date('d'),date('Y')) . "
			GROUP BY rating
		");
	}

	while ($itrader = $vbulletin->db->fetch_array($itraders))
	{
		switch ($itrader['rating'])
		{
			case 1:
			   $userinfo['tradepos365'] = $itrader['usercount'];
			   break;
			case 0:
			   $userinfo['tradeneu365'] = $itrader['usercount'];
			   break;
			case -1:
			   $userinfo['tradeneg365'] = $itrader['usercount'];
			   break;
			default:
			   break;
		}
	}
	return;
}

########################################################################## EMAIL ADMIN ON SITUATIONS
function itrader_email_admins($info, $template = 'itrader_reportsuspicious')
{
	global $vbulletin, $userinfo;

	if ($vbulletin->options['enableemail'])
	{
		$moderators = $vbulletin->db->query_read("
			SELECT user.email, user.languageid, user.username, user.userid
			FROM " . TABLE_PREFIX . "user AS user
			INNER JOIN " . TABLE_PREFIX . "usergroup AS usergroup USING (usergroupid)
			WHERE usergroup.itraderpermissions & " . $vbulletin->bf_ugp['itraderpermissions']['canadmin'] . "
		");
		$mods = array();
		while ($moderator = $vbulletin->db->fetch_array($moderators))
		{
			$mods[] = $moderator;
		}
		foreach ($mods AS $index => $moderator)
		{
			if (!empty($moderator['email']))
			{
				$email_langid = ($moderator['languageid'] > 0 ? $moderator['languageid'] : $vbulletin->options['languageid']);
				eval(fetch_email_phrases($template, $email_langid));
				vbmail($moderator['email'], $subject, $message, true);
			}
		}
	}
	return;
}

######################################################################## CHECK PERMISSIONS OF MEMBER
function itrader_checkperms($bitfield = 0, $silent = false, $data = null)
{
	global $vbulletin, $permissions, $vbphrase;

	/*
	1 = Can view iTrader - executed in itrader_global.php so you don't need to use it again.
	2 = Can rate iTrader
	4 = Must match same userid
	8 = Must NOT Match same userid
	16 = Check edit time
	32 = Check dupe rating time
	64 = Check max ratings
	128 = Cross-check IPs - Always Silent Checking
	256 = 'userid' or 'rateduserid' must match the userid viewing
	512 = Can admin iTrader - If not set, then admin's bypass all checks
	*/

	if (!$data['userid']) $data['userid'] = $vbulletin->GPC['userid'];

	# If explicity checking admin permissions then other checks are performed too, otherwise admin will bypass everything.
	if (($bitfield & 512) AND !($permissions['itraderpermissions'] & $vbulletin->bf_ugp['itraderpermissions']['canadmin']))
	{
		if ($silent) { return false; } else { print_no_permission(); }
	}
	elseif ($permissions['itraderpermissions'] & $vbulletin->bf_ugp['itraderpermissions']['canadmin'])
	{
		return true;
	}

	if (($bitfield & 1) AND !($permissions['itraderpermissions'] & $vbulletin->bf_ugp['itraderpermissions']['canview']))
	{
		if ($silent) { return false; } else { print_no_permission(); }
	}

	if (($bitfield & 2) AND !($permissions['itraderpermissions'] & $vbulletin->bf_ugp['itraderpermissions']['canrate']))
	{
		if ($silent) { return false; } else { print_no_permission(); }
	}

	if (($bitfield & 4) AND $data['userid'] != $vbulletin->userinfo['userid'])
	{
		if ($silent) { return false; } else { print_no_permission(); }
	}

	if (($bitfield & 8) AND $data['userid'] == $vbulletin->userinfo['userid'])
	{
		if ($silent) { return false; } else { print_no_permission(); }
	}

	if (($bitfield & 16) AND $data['dateline'] AND (TIMENOW - ($vbulletin->options['itrader_uedit'] * 60) > $data['dateline']))
	{
		if ($silent) { return false; } else { eval(standard_error(fetch_error('itrader_uedit'))); }
	}

	if ($bitfield & 32)
	{
		$check = $vbulletin->db->query_first("
			SELECT rateid, dateline
			FROM " . TABLE_PREFIX . "itrader
			WHERE userid = " . $vbulletin->userinfo['userid'] . "
			AND rateduserid = " . $data['userid'] . "
			AND dateline >= " . (TIMENOW - ($vbulletin->options['itrader_dupeuser'] * 3600)) . "
		");

		if ($check['rateid'])
		{
			$datenow = vbdate($vbulletin->options['dateformat'], $check['dateline'] + $vbulletin->options['itrader_dupeuser']*3600);
			$timenow = vbdate($vbulletin->options['timeformat'], $check['dateline'] + $vbulletin->options['itrader_dupeuser']*3600);
			if ($silent) { return false; } else { eval(standard_error(fetch_error('itrader_dupeuser',$datenow,$timenow))); }
		}
	}

	if (($bitfield & 64) AND $vbulletin->options['itrader_new_ratelimit'] AND $vbulletin->userinfo['itrader_total'] <= $vbulletin->options['itrader_newtrader'])
	{
		$check = $vbulletin->db->query_first("
			SELECT count(*) AS total
			FROM " . TABLE_PREFIX . "itrader
			WHERE userid = " . $vbulletin->userinfo['userid'] . "
			AND dateline >= " . (TIMENOW - 86400) . "
		");

		if ($check['total'] >= $vbulletin->options['itrader_new_ratelimit'])
		{
			itrader_email_admins($vbphrase['itrader_new_exceedlimit']);
			if ($silent) { return false; } else { eval(standard_error(fetch_error('itrader_new_ratelimit'))); }
		}
	}

	if (($bitfield & 128) AND $vbulletin->userinfo['itrader_total'] <= $vbulletin->options['itrader_newtrader'])
	{
		$check = $vbulletin->db->query_first("
			SELECT * FROM " . TABLE_PREFIX . "itrader
			WHERE userid != " . $vbulletin->userinfo['userid'] . "
			AND ipaddress = '" . IPADDRESS . "'
		");

		if ($check['ipaddress'])
		{
			$reason = construct_phrase($vbphrase['itrader_ip_match'], IPADDRESS, $vbulletin->options['bburl'], $check['rateid'], $check['userid']);
			itrader_email_admins($reason);
			return false;
		}

		$check = $vbulletin->db->query_first("
			SELECT * FROM " . TABLE_PREFIX . "itrader_comments
			WHERE userid != " . $vbulletin->userinfo['userid'] . "
			AND ipaddress = '" . IPADDRESS . "'
		");

		if ($check['ipaddress'])
		{
			$reason = construct_phrase($vbphrase['itrader_ip_match'], IPADDRESS, $vbulletin->options['bburl'], $check['rateid'], $check['userid']);
			itrader_email_admins($reason);
			return false;
		}
	}

	if (($bitfield & 256) AND $data['userid'] != $vbulletin->userinfo['userid'] AND $data['rateduserid'] != $vbulletin->userinfo['userid'])
	{
		if ($silent) { return false; } else { print_no_permission(); }
	}

	# Everything Passed
	return true;
}

?>
