<?php
#################################################################################### ITRADER CREDITS
#  EOC_Jason from EXTREME Overclocking -2008
#    vbEnhancer.com 2008-

################################################################################ BASIC CONFIGURATION
error_reporting(E_ALL & ~E_NOTICE);

######################################################################### DEFINE IMPORTANT CONSTANTS
define('CVS_REVISION', '$RCSfile: itrader_misc.php,v $ - $Revision: 2.1.0 $');
define('NOZIP', 1);

####################################################################### PRE-CACHE TEMPLATES AND DATA
$phrasegroups = array('itrader','maintenance');
$specialtemplates = array();

################################################################################### REQUIRE BACK-END
require_once('./global.php');

require_once(DIR . '/includes/functions_itrader.php');

############################################################################ CHECK ADMIN PERMISSIONS
if (!can_administer('canadminusers'))
{
	print_cp_no_permission();
}

################################################################################## START MAIN SCRIPT

print_cp_header($vbphrase['itrader'] . ' ' . $vbulletin->options['itrader_version']);

if (empty($_REQUEST['do'])) $_REQUEST['do'] = 'chooser';

$vbulletin->input->clean_array_gpc('r', array(
	'perpage' => TYPE_UINT,
	'startat' => TYPE_UINT
));

################################################################################## START USER UPDATE

if ($_REQUEST['do'] == 'chooser')
{
	print_form_header('itrader_misc', 'updateuser');
	print_table_header($vbphrase['itrader_update_user_scores'], 2, 0);
	print_input_row($vbphrase['number_of_users_to_process_per_cycle'], 'perpage', 1000);
	print_submit_row($vbphrase['itrader_update_user_scores']);
}

################################################################################## PROCEED TO UPDATE

if ($_REQUEST['do'] == 'updateuser')
{
	if (empty($vbulletin->GPC['perpage'])) $vbulletin->GPC['perpage'] = 1000;

	$finishat = $vbulletin->GPC['startat'] + $vbulletin->GPC['perpage'];

	echo '<p>' . $vbphrase['updating_user_info'] . '</p>';
	$tmp_usergroup_cache = array();

	$users = $db->query_read("
		SELECT userid
		FROM " . TABLE_PREFIX . "user
		WHERE userid >= " . $vbulletin->GPC['startat'] . "
		AND userid < $finishat
		ORDER BY userid
	");

	while ($user = $db->fetch_array($users))
	{
		itrader_user($user, true);
		echo construct_phrase($vbphrase['processing_x'], $user['userid']) . "<br />\n";
		vbflush();
	}

	if ($checkmore = $db->query_first("
		SELECT userid FROM " . TABLE_PREFIX . "user
		WHERE userid >= $finishat LIMIT 1
	"))
	{
		print_cp_redirect("itrader_misc.php?" . $vbulletin->session->vars['sessionurl'] . "do=updateuser&startat=$finishat&pp=" . $vbulletin->GPC['perpage']);
		echo "<p><a href=\"itrader_misc.php?" . $vbulletin->session->vars['sessionurl'] . "do=updateuser&amp;startat=$finishat&amp;pp=" . $vbulletin->GPC['perpage'] . "\">" . $vbphrase['click_here_to_continue_processing'] . "</a></p>";
	}
	else
	{
		define('CP_REDIRECT', 'itrader_misc.php');
		print_stop_message('itrader_updated_users_successfully');
	}
}

print_cp_footer();

?>