<?php
#################################################################################### ITRADER CREDITS
#  EOC_Jason from EXTREME Overclocking -2008
#    vbEnhancer.com 2008-

################################################################################ BASIC CONFIGURATION
error_reporting(E_ALL & ~E_NOTICE);

######################################################################### DEFINE IMPORTANT CONSTANTS
define('ITAB', true);
define('THIS_SCRIPT', 'itrader_feedback');
define('CSRF_PROTECTION', true);
define('GET_EDIT_TEMPLATES', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('itrader','posting');

// get special data templates from the datastore
$specialtemplates = array('bbcodecache');

// pre-cache templates used by all actions
$globaltemplates = array('itrader_feedback');

################################################################################### REQUIRE BACK-END
require_once('./global.php');
require_once(DIR . '/itrader_global.php');

################################################################################## START MAIN SCRIPT
if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'feedback';
}

# Just do all thest now, even though they might all be used or overwritten later.
$itrader['buyselltrade'] = $vbulletin->input->clean_gpc('r', 'buyselltrade', TYPE_UINT);
$itrader['rateid'] = $vbulletin->input->clean_gpc('r', 'ir', TYPE_UINT);
$itrader['rating'] = $vbulletin->input->clean_gpc('r', 'rating', TYPE_INT);
$itrader['subject'] = $vbulletin->input->clean_gpc('r', 'subject', TYPE_STR);
$itrader['dealurl'] = $vbulletin->input->clean_gpc('r', 'dealurl', TYPE_NOHTML);
$itrader['message'] = $vbulletin->input->clean_gpc('r', 'message', TYPE_STR);

###################################################################################### EDIT FEEDBACK
if ($_REQUEST['do'] == 'editfeedback')
{
	//Get the info to edit.
	$itrader = $vbulletin->db->query_first("
		SELECT * FROM " . TABLE_PREFIX . "itrader
		WHERE rateduserid = " . $userinfo['userid'] . "
		AND rateid = " . $itrader['rateid'] . "
	");

	# A person can only edit their own feedback + edit time check.
	itrader_checkperms(22, false, $itrader);

	$show['editfeedback'] = true;
	$_REQUEST['do'] = 'feedback';
}

############################################################################# SUBMIT EDITED FEEDBACK
if ($_REQUEST['do'] == 'submiteditfeedback')
{
	$itrader['delete'] = $vbulletin->input->clean_gpc('r', 'delete', TYPE_INT);

	$check = $vbulletin->db->query_first_slave("
		SELECT * FROM " . TABLE_PREFIX . "itrader
		WHERE rateduserid = " . $userinfo['userid'] . "
		AND rateid = " . $itrader['rateid'] . "
	");

	// A person can only edit their own feedback + edit time check.
	itrader_checkperms(22, false, $check);

	if($itrader['delete'] == 1)
	{
		$vbulletin->db->query_write("
			DELETE FROM " . TABLE_PREFIX . "itrader
			WHERE userid = " . $check['userid'] . "
			AND rateid = " . $check['rateid'] . "
		");

		$vbulletin->db->query_write("
			DELETE FROM " . TABLE_PREFIX . "itrader_comments
			WHERE userid = " . $check['userid'] . "
			AND rateid = " . $check['rateid'] . "
		");

		# Update rated user's score in user table.
		itrader_user($userinfo, true);

		# Redirect to the rated user's feedback page.
		$vbulletin->url = "itrader.php?".$vbulletin->session->vars['sessionurl']."u=".$userinfo['userid'];
		eval(print_standard_redirect('redirect_postthanks'));
	}
	else
	{
		$show['editfeedback'] = true;
		$_REQUEST['do'] = 'submitfeedback';
	}
}

#################################################################################### SUBMIT FEEDBACK
if ($_REQUEST['do'] == 'submitfeedback')
{
	if (!$show['editfeedback'])
	{
		# A person can not submit feedback for themself. - Check Dupe IPs here too
		itrader_checkperms(234, false, $itrader);
	}

	# This is for returning feedback linked to an existing rating.
	if ($itrader['rateid'] AND !$show['editfeedback'])
	{
		// We need to double check this just incase.
		$check = $vbulletin->db->query_first_slave("
			SELECT itrader.rateduserid, B.userid AS b_userid
			FROM " . TABLE_PREFIX . "itrader as itrader
			LEFT JOIN " . TABLE_PREFIX . "itrader AS B ON (itrader.rateid = B.rateid AND itrader.userid != B.userid)
			WHERE itrader.userid = " . $userinfo['userid'] . "
			AND itrader.rateid = " . $itrader['rateid'] . "
		");

		if ($vbulletin->userinfo['userid'] !=  $check['rateduserid'] OR $check['b_userid'])
		{
			print_no_permission();
		}
	}

	if (in_array($itrader['buyselltrade'],array(0,255)))
	{
		$errors[] = $vbphrase['itrader_error_transaction_type'];
	}

	if (!$vbulletin->GPC_exists['rating'] OR !in_array($itrader['rating'],array(-1,0,1)))
	{
		$errors[] = $vbphrase['itrader_error_rating'];
	}

	if (!$itrader['subject'])
	{
		$errors[] = $vbphrase['itrader_error_short_comment'];
	}

	if ($vbulletin->options['itrader_requrl'] == '1' AND !$itrader['dealurl'])
	{
		$errors[] = $vbphrase['itrader_error_url_required'];
	}

	if($itrader['dealurl'])
	{
		require_once(DIR . '/includes/functions_itrader_urlcheck.php');

		# We have a URL so perform a check to see if it passes the test(s).
		if ($vbulletin->options['friendlyurl'] == '0')
		{
			if (itrader_checkurl0($itrader['dealurl']) == false)
			{
				$errors[] = $vbphrase['itrader_error_invalid_url'];
			}
		}
		else
		{
			if (itrader_checkurl123($itrader['dealurl']) == false)
			{
				$errors[] = $vbphrase['itrader_error_invalid_url'];
			}
		}
	}

	$itrader['wysiwyg'] = $vbulletin->input->clean_gpc('r', 'wysiwyg', TYPE_BOOL);

	if($vbulletin->options['templateversion'] > '4.1.3')
	{
		if ($itrader['wysiwyg'])
		{
			require_once(DIR . '/includes/class_wysiwygparser.php');
			$html_parser = new vB_WysiwygHtmlParser($vbulletin);
			$itrader['message'] = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 0);
		}
		else
		{
			$itrader['message'] =& $itrader['message'];
		}
	}else{
		if ($itrader['wysiwyg'])
		{
			require_once(DIR . '/includes/functions_wysiwyg.php');
			$itrader['message'] = convert_wysiwyg_html_to_bbcode($itrader['message']);
		}
	}
	
	if (!$show['editfeedback'])
	{
		$dataman =& datamanager_init('iTrader', $vbulletin);
		$dataman->set_info('parseurl', 1);
		$dataman->itrader_verify_pagetext($itrader['message']);


		if ($dataman->errors OR strlen($itrader['message']) < $vbulletin->options['itrader_reqcomment'])
		{
			$errors[] = $vbphrase['itrader_error_details'];
		}
	}


	if (!empty($errors))
	{
		# We had an error so lets go back to the feedback page so they can fix it.
		$show['errors'] = true;
		
			$templater = vB_Template::create('newpost_errormessage');
				$templater->register('errors', $errors);
			$errorlist .= $templater->render();
	
		$_REQUEST['do'] = 'feedback';
	}
	else
	{
		if (!$show['editfeedback'])
		{
			$vbulletin->db->query_write("
				INSERT INTO " . TABLE_PREFIX . "itrader
				SET rateid = " . $itrader['rateid'] . ",
				userid = ".$vbulletin->userinfo['userid'].",
				rateduserid = " . $userinfo['userid'] . ",
				rating = " . $itrader['rating'] . ",
				buyselltrade = " . $itrader['buyselltrade'].",
				subject = '" . $vbulletin->db->escape_string($itrader['subject']) . "',
				dealurl = '" . $vbulletin->db->escape_string($itrader['dealurl']) . "',
				dateline = " . TIMENOW . ",
				ipaddress = '" . IPADDRESS . "'
			");

			if (!$itrader['rateid'])
			{
				$itrader['rateid'] = $vbulletin->db->insert_id();
			}

			if ($itrader['message'])
			{
				$vbulletin->db->query_write("
					INSERT INTO " . TABLE_PREFIX . "itrader_comments
					SET rateid = " . $itrader['rateid'] . ",
					dateline = " . TIMENOW . ",
					userid = " . $vbulletin->userinfo['userid'] . ",
					comment = '" . $vbulletin->db->escape_string($itrader['message']) . "',
					ipaddress = '" . IPADDRESS . "'
				");
			}

			if ($userinfo['receivepm'] AND $userperms['pmquota'] > 0)
			{
				// Send a PM to the rated user.
				if ($itrader['rating'] == 1)
				{
					$itrader['phrase_rating'] = $vbphrase['itrader_positive'];
				}
				elseif  ($itrader['rating'] == -1)
				{
					$itrader['phrase_rating'] = $vbphrase['itrader_negative'];
				}
				else
				{
					$itrader['phrase_rating'] = $vbphrase['itrader_neutral'];
				}

				$vbphrase['itrader_pm_message_x'] = construct_phrase($vbphrase['itrader_pm_message'], $itrader['phrase_rating'], $vbulletin->userinfo['username'], $vbulletin->options['bburl'], $userinfo['userid']);

				$cantrackpm = $permissions['pmpermissions'] & $vbulletin->bf_ugp_pmpermissions['cantrackpm'];
				$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
				$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
				$pmdm->set('fromusername', $vbulletin->userinfo['username']);
				$pmdm->set('title', $vbphrase['itrader_pm_subject']);
				$pmdm->set('message', $vbphrase['itrader_pm_message_x']);
				$pmdm->set_recipients($userinfo['username'], $permissions);
				$pmdm->set('dateline', TIMENOW);
				$pmdm->set_info('receipt',1);
				$pmdm->set_info('cantrackpm', $cantrackpm);
				$pmdm->pre_save();
				if (empty($pmdm->errors))
				{
					$pmdm->save();
				}
			}

			if ($itrader['rating'] == -1 AND $vbulletin->options['itrader_contact_negative'])
			{
				itrader_email_admins($itrader, 'itrader_reportnegative');
			}

		}
		else
		{
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "itrader
				SET rating = " . $itrader['rating'] . ",
				buyselltrade = " . $itrader['buyselltrade'].",
				subject = '" . $vbulletin->db->escape_string($itrader['subject']) . "',
				dealurl = '" . $vbulletin->db->escape_string($itrader['dealurl']) . "'
				WHERE rateid = " . $itrader['rateid'] . "
				AND rateduserid = " . $userinfo['userid'] . "
				LIMIT 1
			");

			if ($check['rating'] != -1 AND $itrader['rating'] == -1 AND $vbulletin->options['itrader_contact_negative'])
			{
				itrader_email_admins($itrader, 'itrader_reportnegative');
			}
		} # insert or edit

		# Update rated user's score in user table.
		itrader_user($userinfo, true);

		# Redirect to the rated user's feedback page.
		$vbulletin->url = "itrader.php?".$vbulletin->session->vars['sessionurl']."u=".$userinfo['userid'];
		eval(print_standard_redirect('redirect_postthanks'));
	} # errorlist
}

########################################################################################### FEEDBACK
if ($_REQUEST['do'] == 'feedback')
{
	if (!$show['editfeedback'])
	{
		# A person can not submit feedback for themself.
		itrader_checkperms(106, false, $itrader);
	}

	# Don't run this unless it is a new blank feedback submission. (This code runs initial checks & preps some fields)
	if (!$show['errors'] AND !$show['editfeedback'])
	{
		if ($itrader['rateid'])
		{
			# Just a sanity check.
			$check = $vbulletin->db->query_first("
				SELECT * FROM " . TABLE_PREFIX . "itrader
				WHERE rateduserid = " . $vbulletin->userinfo['userid'] . "
				AND rateid = " . $itrader['rateid'] . "
			");

			if ($vbulletin->userinfo['userid'] !=  $check['rateduserid'])
			{
				print_no_permission();
			}
			else
			{
				# Pre-fill in some data to help the user.
				$itrader['dealurl'] = $check['dealurl'];

				switch ($check['buyselltrade'])
				{
				case 1:
					$itrader['buyselltrade'] = 2;
					break;
				case 2:
					$itrader['buyselltrade'] = 1;
					break;
				case 3:
					$itrader['buyselltrade'] = 3;
					break;
				default:
					$itrader['buyselltrade'] = 255;
				}
			}
		} # if rateid

	}# if errors

	if (($vbulletin->options['itrader_rate_trade'] == '1') OR ($vbulletin->options['itrader_rate_trade'] == '2'))
	{
		require_once(DIR . '/includes/functions_itrader_urlcheck.php');

		$threadurl = $vbulletin->url;
		if ($vbulletin->options['friendlyurl'] == '0')
		{
			if (itrader_checkurl0($threadurl) == true)
			{
				$itrader['dealurl'] = $vbulletin->url;
			}
		}
		else
		{
			if (itrader_checkurl123($threadurl) == true)
			{
				$itrader['dealurl'] = $vbulletin->url;
			}
		}
	}

	$itrader['subject'] = htmlspecialchars_uni($itrader['subject']);

	require_once(DIR . '/includes/functions_editor.php');
	$show['wysiwyg'] = is_wysiwyg_compatible();
	$editorid = construct_edit_toolbar($itrader['message'], 0, 0, 0, 1);

	$navbits = construct_navbits(array("itrader.php?$session[sessionurl]u=$userinfo[userid]" => $vbphrase['itrader'],'' => $userinfo['username']));
	$navbar = render_navbar_template($navbits);
	
	$templater = vB_Template::create('itrader_feedback');
		$templater->register_page_templates();
		$templater->register('bbuserinfo', $bbuserinfo);
		$templater->register('editorid', $editorid);
		$templater->register('errorlist', $errorlist);
		$templater->register('itrader', $itrader);
		$templater->register('messagearea', $messagearea);
		$templater->register('navbar', $navbar);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('userinfo', $userinfo);
	print_output($templater->render());
}

?>
