<?php
#################################################################################### ITRADER CREDITS
#  EOC_Jason from EXTREME Overclocking -2008
#    vbEnhancer.com 2008-

// 'ir' = rateid
// 'ic' = commentid

################################################################################ BASIC CONFIGURATION
error_reporting(E_ALL & ~E_NOTICE);

######################################################################### DEFINE IMPORTANT CONSTANTS
define('ITAB', true);
define('THIS_SCRIPT', 'itrader');
define('CSRF_PROTECTION', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('itrader');

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array(
	'itrader_user',
	'itrader_userbits',
	'itrader_user_sidebar'
);

################################################################################### REQUIRE BACK-END
require_once('./global.php');
require_once(DIR . '/itrader_global.php');

################################################################################## START MAIN SCRIPT
if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'viewuser';
}

if (empty($userinfo['userid']))
{
    print_no_permission();
}

################################################################################# VIEW SELECTED USER
if ($_REQUEST['do'] == 'viewuser')
{
	$viewuser['rateid'] = $vbulletin->input->clean_gpc('r', 'ir', TYPE_UINT);
	$viewuser['pagenumber'] = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
	$viewuser['perpage'] = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_UINT);
	$viewuser['viewtype'] = $vbulletin->input->clean_gpc('r', 'iv', TYPE_UINT);

	# First Column
	itrader_user($userinfo);

	# Second Column
	itrader_second_column($userinfo);

	# Sidebar
	$show['lastactivity'] = true;
	$userinfo['lastactivitydate'] = vbdate($vbulletin->options['dateformat'], $userinfo['lastactivity'], true);
	$userinfo['lastactivitytime'] = vbdate($vbulletin->options['timeformat'], $userinfo['lastactivity'], true);

	$userinfo['datejoined'] = vbdate($vbulletin->options['dateformat'], $userinfo['joindate']);

	$show['email'] = ($vbulletin->options['enableemail'] AND $vbulletin->options['displayemails'] ? true : false);
	$show['pm'] = ($userinfo['receivepm'] AND $userperms['pmquota'] > 0 ? true : false);

	# Query The Ratings Now.
	$query_field = $query_where = '';

	# Various View Types For Filtering Comments
	switch ($viewuser['viewtype'])
	{
	case 1:
		# From Buyers Only
		$query_field = 'itrader.rateduserid';
		$query_where = 'AND itrader.buyselltrade = 2';
		break;
	case 2:
		# From Sellers Only
		$query_field = 'itrader.rateduserid';
		$query_where = 'AND itrader.buyselltrade = 1';
		break;
	case 3:
		# From Trades Only
		$query_field = 'itrader.rateduserid';
		$query_where = 'AND itrader.buyselltrade = 3';
		break;
	case 4:
		# Feedback Left For Others
		$query_field = 'itrader.userid';
		break;
	default:
		# All Feedback From Other People
		$query_field = 'itrader.rateduserid';
	}

	$countposts = $vbulletin->db->query_first_slave("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "itrader AS itrader
		WHERE $query_field = " . $userinfo['userid'] . "
		$query_where
	");

	$viewuser['perpage'] = sanitize_maxposts($viewuser['perpage']);

	if (!$viewuser['pagenumber']) $viewuser['pagenumber'] = 1;

	$limitlower = ($viewuser['pagenumber'] - 1) * $viewuser['perpage'];
	$limitupper = $viewuser['pagenumber'] * $viewuser['perpage'];

	if ($limitupper > $countposts['total'])
	{
		$limitupper = $countposts['total'];
		if ($limitlower > $countposts['total'])
		{
			$limitlower = ($countposts['total'] - $viewuser['perpage']) - 1;
		}
	}
		
	if ($limitlower < 0) { $limitlower = 0; }
		
	$pagenav = construct_page_nav($viewuser['pagenumber'], $viewuser['perpage'], $countposts['total'], "itrader.php?" . $vbulletin->session->vars['sessionurl'] . "u=" . $userinfo['userid'] . ($viewuser['viewtype'] ? "&amp;iv=" . $viewuser['viewtype'] : ''),(!empty($viewuser['perpage']) ? "&amp;pp=" . $viewuser['perpage'] : ""));


	// If !b_userid then the other person has not returned the rating for the deal.
	$itraders = $vbulletin->db->query_read_slave("
		SELECT itrader.*, user.username, user.itrader_total, user.itrader_pcnt, B.userid AS b_userid
		FROM " . TABLE_PREFIX . "itrader as itrader
		LEFT JOIN " . TABLE_PREFIX . "user as user ON " . ($viewuser['viewtype'] == 4 ? 'itrader.rateduserid' : 'itrader.userid') . " = user.userid
		LEFT JOIN " . TABLE_PREFIX . "itrader AS B ON (itrader.rateid = B.rateid AND itrader.userid != B.userid)
		WHERE $query_field = " . $userinfo['userid'] . " 
		$query_where
		ORDER BY itrader.dateline DESC
		LIMIT $limitlower, " . $viewuser['perpage'] . "
	");

	// Trader Ratings Member Feedback
	while ($itrader = $vbulletin->db->fetch_array($itraders))
	{
		$show['itrader_detail'] = (itrader_checkperms(256,true,$itrader) ? true : false);
		$show['itrader_allowedit'] = (itrader_checkperms(22, true, $itrader) ? true : false);
		$show['itrader_allowreturn'] = ($itrader['dateline'] >= TIMENOW - ($vbulletin->options['itrader_maxreturn'] * 86400) ? true : false);

		if(!$itrader['username'])
		{
			$itrader['username'] = $vbphrase['guest'];
			$itrader['itrader_total'] = 'N/A';
		}
	
		$itrader['dateline'] = vbdate($vbulletin->options['dateformat'],$itrader['dateline']);
		$itrader['subject'] = htmlspecialchars_uni($itrader['subject']);

		$templater = vB_Template::create('itrader_userbits');
			$templater->register('itrader', $itrader);
			$templater->register('userinfo', $userinfo);
			$templater->register('viewuser', $viewuser); 
		$itrader_userbits .= $templater->render();
	}

	$navbits = construct_navbits(array("itrader.php?" . $vbulletin->session->vars['sessionurl'] . "u=" . $userinfo['userid'] => $vbphrase['itrader'], '' => $userinfo['username']));
	$navbar = render_navbar_template($navbits);
	
	$templater = vB_Template::create('itrader_user_sidebar');
		$templater->register('countposts', $countposts);
		$templater->register('itrader', $itrader);
		$templater->register('userinfo', $userinfo);
	$itrader_usersidebar .= $templater->render();

	$templater = vB_Template::create('itrader_user');
		$templater->register_page_templates();		
		$templater->register('countposts', $countposts);
		$templater->register('itrader', $itrader);
		$templater->register('itrader_userbits', $itrader_userbits);
		$templater->register('itrader_usersidebar', $itrader_usersidebar);
		$templater->register('navbar', $navbar);
		$templater->register('pagenav', $pagenav);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('userinfo', $userinfo);
		$templater->register('viewuser', $viewuser);
	print_output($templater->render());
}

?>
