<?php

class EWRmedio_Model_Playlists extends XenForo_Model
{
	public function getPlaylists()
	{
		if (!$playlists = $this->_getDb()->fetchAll("
			SELECT EWRmedio_playlists.*, xf_user.*
				FROM EWRmedio_playlists
				LEFT JOIN xf_user ON (xf_user.user_id = EWRmedio_playlists.user_id)
			ORDER BY playlist_name
		"))
		{
			return false;
		}

		foreach ($playlists AS &$playlist)
		{
			$playlist['count'] = 0;
			if ($playlist['playlist_media'])
			{
				$count = explode(",", $playlist['playlist_media']);
				$playlist['count'] = count($count);
			}
		}

        return $playlists;
	}

	public function getPlaylistByID($playID)
	{
		if (!$playlist = $this->_getDb()->fetchRow("
			SELECT EWRmedio_playlists.*, xf_user.*
				FROM EWRmedio_playlists
				LEFT JOIN xf_user ON (xf_user.user_id = EWRmedio_playlists.user_id)
			WHERE EWRmedio_playlists.playlist_id = ?
		", $playID))
		{
			return false;
		}

        return $playlist;
	}

	public function getPlaylistsByIDs($playIDs)
	{
		if (!$playlists = $this->fetchAllKeyed("
			SELECT *
				FROM EWRmedio_playlists
			WHERE playlist_id IN (" . $this->_getDb()->quote($playIDs) . ")
		", 'playlist_id'))
		{
			return array();
		}

        return $playlists;
	}

	public function getPlaylistByUserID($userID = 0)
	{
		$userID = $userID ? $userID : XenForo_Visitor::getUserId();

		if (!$playlists = $this->_getDb()->fetchAll("
			SELECT *
				FROM EWRmedio_playlists
			WHERE user_id = ?
			ORDER BY playlist_name
		", $userID))
		{
			return false;
		}

        return $playlists;
	}

	public function getMediaByPlaylist($playlist)
	{
		if (!$playlist['playlist_media']) { return false; }

		$medias = $this->_getDb()->fetchAll("
			SELECT EWRmedio_media.*, EWRmedio_categories.*, EWRmedio_services.*, xf_user.*,
				IF(NOT ISNULL(xf_user.user_id), xf_user.username, EWRmedio_media.username) AS username
				FROM EWRmedio_media
				LEFT JOIN EWRmedio_categories ON (EWRmedio_categories.category_id = EWRmedio_media.category_id)
				LEFT JOIN EWRmedio_services ON (EWRmedio_services.service_id = EWRmedio_media.service_id)
				LEFT JOIN xf_user ON (xf_user.user_id = EWRmedio_media.user_id)
			WHERE EWRmedio_media.media_id IN (".$playlist['playlist_media'].")
			ORDER BY FIELD(EWRmedio_media.media_id, ".$playlist['playlist_media'].")
		");

		foreach ($medias AS &$media)
		{
			$media = $this->getModelFromCache('EWRmedio_Model_Media')->getDuration($media);
		}

        return $medias;
	}

	public function getPlaylistWithMedia($playlist, $media)
	{
		$mediaIDs = explode(',',$playlist['playlist_media']);

		if (in_array($media['media_id'], $mediaIDs))
		{
			$medias = $this->_getDb()->fetchAll("
				SELECT *
					FROM EWRmedio_media
				WHERE media_id IN (".$playlist['playlist_media'].")
				ORDER BY FIELD(media_id, ".$playlist['playlist_media'].")
			");

			foreach ($medias AS $key => $exists)
			{
				if ($exists['media_id'] == $media['media_id'])
				{
					$now = $key;
					break;
				}
			}
			$playlist['count'] = count($medias);

			if (!empty($medias[$now-1]))
			{
				$playlist['prev'] = $medias[$now-1];
				$playlist['prev'] = $this->getModelFromCache('EWRmedio_Model_Media')->getDuration($playlist['prev']);
			}

			if (!empty($medias[$now+1]))
			{
				$playlist['next'] = $medias[$now+1];
				$playlist['next'] = $this->getModelFromCache('EWRmedio_Model_Media')->getDuration($playlist['next']);
			}
		}
		else
		{
			return false;
		}

		return $playlist;
	}

	public function updatePlaylist($input)
	{
		$dw = XenForo_DataWriter::create('EWRmedio_DataWriter_Playlists');

		if (!empty($input['playlist_id']) && $playlist = $this->getPlaylistByID($input['playlist_id']))
		{
			$dw->setExistingData($playlist);
		}
		$dw->bulkSet(array(
			'playlist_name' => $input['playlist_name'],
			'playlist_description' => XenForo_Helper_String::autoLinkBbCode($input['playlist_description']),
		));
		$dw->save();
		$input['playlist_id'] = $dw->get('playlist_id');
		$input['playlist_media'] = $dw->get('playlist_media');

		if (!empty($input['media_id']))
		{
			$input['action'] = "add";
			$this->movePlaylist($input, $input);
		}

		return $input;
	}

	public function deletePlaylist($input)
	{
		$dw = XenForo_DataWriter::create('EWRmedio_DataWriter_Playlists');
		$dw->setExistingData($input);
		$dw->delete();

		return true;
	}

	public function movePlaylist($playlist, $input)
	{
		$playlist['mediaIDs'] = explode(',',$playlist['playlist_media']);

		$mediaIDs = array();
		foreach ($playlist['mediaIDs'] as $key => $value)
		{
			$mediaIDs[$key*2+1] = $playlist['mediaIDs'][$key];
		}

		if ($now = array_search($input['media_id'], $mediaIDs))
		{
			switch ($input['action'])
			{
				case "top": $mediaIDs[000000] = $mediaIDs[$now]; unset($mediaIDs[$now]); break;
				case "btm": $mediaIDs[999999] = $mediaIDs[$now]; unset($mediaIDs[$now]); break;
				case "upp": $mediaIDs[$now-3] = $mediaIDs[$now]; unset($mediaIDs[$now]); break;
				case "dwn": $mediaIDs[$now+3] = $mediaIDs[$now]; unset($mediaIDs[$now]); break;
				case "rem": unset($mediaIDs[$now]); break;
			}
			ksort($mediaIDs);
		}
		else
		{
			if ($input['action'] = "add")
			{
				$mediaIDs[999999] = $input['media_id'];
			}
		}

		foreach ($mediaIDs AS $key => $mediaID)
		{
			if (!$this->getModelFromCache('EWRmedio_Model_Media')->getMediaByID($mediaID))
			{
				unset($mediaIDs[$key]);
			}
		}

		$playlist['playlist_media'] = implode(',',$mediaIDs);

		$dw = XenForo_DataWriter::create('EWRmedio_DataWriter_Playlists');
		$dw->setExistingData($playlist);
		$dw->set('playlist_media', $playlist['playlist_media']);
		$dw->save();

		return $playlist;
	}
}