<?php

function imdm_prepare()
{
	global $vbulletin, $vbphrase;
	// get the cookies values
	$vbulletin->input->clean_array_gpc('c', array(
		'fcresult' => TYPE_UINT,
		'clastpost' => TYPE_UINT,
		'ctop_1' => TYPE_STR,
		'ctop_2' => TYPE_STR,
		'ctop_3' => TYPE_STR,
		'ctop_4' => TYPE_STR,
	));

	////////////////// GET LATEST POST SELECTION /////////////
	$imdmset = array();
	$tabarr = array();

	if (is_array($value = unserialize($vbulletin->options['imdmstats_customforum'])))
	{
		$def_lp = iif($vbulletin->GPC['clastpost'] >= 0, $vbulletin->GPC['clastpost'], $value['def']);
		for ($i = 0; $i <= count($value['values']) - 1; $i++)
		{
			$title = $vbphrase["imdmlp_$i"];
			$listforumid = $value['values'][$i]['varname'];
			$tabarr[] = $listforumid;
	
			if ($i == $def_lp)
			{
				$deflist = $listforumid;
				$imdmset['def_lp'] = $title;
			}
			$optionbit = 'id="clp' . $i . '"' . iif($i == $def_lp, ' class="chsel"');

			$imdmset['selectlp'] .= imdm_option($title, $optionbit);
		}
	}

	$imdmset['listtab'] = "['" . implode("', '", $tabarr) . "']";

	/////////////// GET RESULT MENU ///////////////
	$resultlist = explode(",", $vbulletin->options['imdmstats_chooseresult']);
	$defres = iif($vbulletin->GPC['fcresult'] > 0, $vbulletin->GPC['fcresult'], $resultlist[0]);
	for ($i = 0; $i < count($resultlist); $i++)
	{
		$resultvalue = $resultlist[$i];
		$imdmset['results'] .= imdm_option($resultvalue, ' type="1"' . iif($resultvalue == $defres, ' class="chsel"'));
	}

	///////////// LIST CHOOSE OPTION TOP ////////////////////
	if ($vbulletin->options['imdmstats_top_turn'])
	{
		$topselect = unserialize($vbulletin->options['imdmstats_top_choose']);
		if (!$topselect[0] AND !$topselect[1])
		{
			$topselect[0] = $topselect[2];
			$topselect[1] = $topselect[3];
			$topselect[2] = $topselect[3] = '';		
		}
		for ($i = 1; $i < 5; $i++)
		{
			if (!empty($topselect[$i-1]))
			{
				$keys = explode('#', $topselect[$i-1]);
				$def = $keys[0];
				if ($cook = $vbulletin->GPC['ctop_' . $i])
				{
					$def = substr($cook, 0, strpos($cook, ':'));
				}

				$imdmset['top_t' . $i] = $vbphrase["imdmtop_$def"] ? $vbphrase["imdmtop_$def"] : $vbphrase['imdmerror'];
				foreach ($keys AS $optionbit)
				{
					$title = $vbphrase["imdmtop_$optionbit"] ? $vbphrase["imdmtop_$optionbit"] : $vbphrase['imdmerror'];
	
					$optionbit = 'id="ctop' . $i . "_" . $optionbit . '"' . iif($def == $optionbit, ' class="chsel"');
	
					$imdmset['top_o' . $i] .= imdm_option($title, $optionbit);
				}
				$imdmset['top_' . $i] = imdm_top($def, $defres);
			}
		}
		$imdmset['topselect'] = $topselect;
	}

	$imdmset['imdmlp'] = imdm_lp($deflist, $defres);

	return $imdmset;
}

// function to get latest post
function imdm_lp($forumlist = -1, $result = 10)
{
	global $vbulletin;
	// TODO - change this permissions
	$imdmstatsforumperms = array();
	foreach ($vbulletin->forumcache AS $imdmtsforum)
	{
		$imdmstatsforumperms[$imdmtsforum["forumid"]] = fetch_permissions($imdmtsforum['forumid']);
		if ((!($imdmstatsforumperms[$imdmtsforum["forumid"]] & $vbulletin->bf_ugp_forumpermissions['canview'])) 
			OR (!($imdmtsforum['options'] & $vbulletin->bf_misc_forumoptions['active']) 
			AND !$vbulletin->options['showprivateforums'] AND !in_array($vbulletin->userinfo['usergroupid'], array(5, 6, 7))))
		{
			$limitfids .= ',' . $imdmtsforum['forumid'];
		}
	}
	unset($imdmtsforum);
	$hiddenforum = $limitfids;

	if ($vbulletin->options['imdmstats_hiddenforum'])
	{
		$hiddenforum .= ',' . $vbulletin->options['imdmstats_hiddenforum'];
	}

	$utrim = $vbulletin->options['imdmstats_trim_username']; // username trim
	$ttrim = $vbulletin->options['imdmstats_trim_threadtitle']; // thread title trim
	$ftrim = $vbulletin->options['imdmstats_trim_forumtitle']; // forum title trim
	$bgclass = "alt2";
	$vlastvisit = $vbulletin->userinfo['lastvisit']; // get lastvisit of logged user

	$latestpostq = $vbulletin->db->query_read("
		SELECT thread.threadid, thread.title, " . iif($vbulletin->options['top_lpshowprefix'], ' thread.prefixid,') . " thread.lastpost, thread.lastpostid, thread.forumid, thread.replycount, thread.views, thread.lastposter, thread.postusername AS threadstarter, thread.dateline, thread.visible, thread.open, user.username, user.userid, user.usergroupid, IF(user.displaygroupid=0, user.usergroupid, user.displaygroupid) AS displaygroupid
		FROM " . TABLE_PREFIX . "thread AS thread
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.username = thread.lastposter)
		WHERE NOT ISNULL(thread.threadid)
		AND thread.visible = '1'
		AND thread.open != '10'
		" . iif($forumlist > 0, "AND thread.forumid IN (" . $vbulletin->db->escape_string($forumlist) . ")", "") . "
		AND thread.forumid NOT IN (0$hiddenforum)
		AND thread.lastpostid > 0
		ORDER BY lastpost DESC
		LIMIT $result
	");

	while ($latestpost = $vbulletin->db->fetch_array($latestpostq))
	{
		$latestpost['bgclass'] = exec_switch_bg();
		$latestpost['fulltitle'] = $latestpost['title'];
		$latestpost['fullposter'] = $latestpost['lastposter'];
		if ($vbulletin->options['imdmstats_lpshowprefix'] AND $latestpost['prefixid'])
		{
			$latestpost['prefixplain'] = $vbphrase['prefix_' . $latestpost['prefixid'] . '_title_plain'];
			$latestpost['prefixrich'] = $vbphrase['prefix_' . $latestpost['prefixid'] . '_title_rich'];
		}

		// show new folder?
		$pstatus = 'old';
		if ($latestpost['lastpost'] > $vlastvisit)
		{
			if ($vbulletin->options['threadmarking'] AND $latestpost['threadread'])
			{
				$threadview = $latestpost['threadread'];
			}
			else
			{
				$threadview = intval(fetch_bbarray_cookie('thread_lastview', $latestpost['threadid']));
			}

			if ($latestpost['lastpost'] > $threadview)
			{
				$pstatus = 'new';
			}
			else
			{
				$pstatus = 'old';
			}
		}

		// imdme time format
		$latestpost['lastposttime_alt'] = vbdate($vbulletin->options['dateformat'], $latestpost['lastpost'], 1) . ' ' . vbdate($vbulletin->options['timeformat'], $latestpost['lastpost']);
		$latestpost['lastpost'] = vbdate($vbulletin->options['imdmstats_formatlatestpost'], $latestpost['lastpost']);
		$latestpost['threadstarttime'] = vbdate($vbulletin->options['dateformat'], $latestpost['dateline'],	1) . ' ' . vbdate($vbulletin->options['timeformat'], $latestpost['dateline']);

		// trim thread title
		$latestpost['full_title'] = $latestpost['title'];
		if ($ttrim > 0)
		{
			$latestpost['title'] = imdm_trim($latestpost['title'], $ttrim - strlen($latestpost['prefixplain']));
		}

		// get forum title store thread and trim
		$latestpost['forumname'] = strip_tags($vbulletin->forumcache["{$latestpost['forumid']}"]['title_clean']); // remove html tag
		$latestpost['forumnamefull'] = $latestpost['forumname']; // get full orum title
		$latestpost['forumname'] = imdm_trim($latestpost['forumname'], $ftrim);

		$latestpost['lastposterid'] = $latestpost['userid'];
		$latestpost['lastposter'] = fetch_musername($latestpost);
		$latestpost['lastposter_alt'] = $latestpost['lastposter'];
		$latestpost['full_lastposter'] = $latestpost['username'];
		$latestpost['username'] = imdm_trim($latestpost['username'], $utrim);
		$latestpost['lastposter'] = fetch_musername($latestpost);

		$bit = vB_Template::create('imdmstat_latestpost_bit');
		$bit->register('latestpost', $latestpost);
		$bit->register('pstatus', $pstatus);
		$imdm_lastpost_bit .= $bit->render();
	}

	$tpl = vB_Template::create('imdmstat_latestpost_head');
	$tpl->register('imdm_lastpost_bit', $imdm_lastpost_bit);
	$vbulletin->db->free_result($latestpostq);

	return $tpl->render();
}

// function to get top
function imdm_top($keyword, $result)
{
	global $vbulletin, $vbphrase;
	$bgclass = "alt2";
	$point_field = $vbulletin->options['imdmstats_pointfield'];

	$cache = $vbulletin->imdmstat;

	$topselect = unserialize($vbulletin->options['imdmstats_top_choose']);

 	$vertical = (($topselect[0] OR $topselect[1]) AND ($topselect[2] OR $topselect[3])) ? true : false;

	if ($vertical)
	{
		$result = floor($result / 3);
	}

	switch ($keyword)
	{
		case 'newmember':
			$head1 = $vbphrase['username'];
			$head2 = $vbphrase['join_date'];
			break;
		case 'topposter':
			$head1 = $vbphrase['username'];
			$head2 = $vbphrase['posts'];
			break;
		case 'toprich':
			$head1 = $vbphrase['username'];
			$head2 = $vbphrase['imdmamount'];
			break;
		case 'topthank':
			$head1 = $vbphrase['username'];
			$head2 = $vbphrase['imdmamount'];
			break;
		case 'banneduser':
			$head1 = $vbphrase['username'];
			$head2 = $vbphrase['date'];
			break;
		case 'threadstarter':
			$head1 = $vbphrase['username'];
			$head2 = $vbphrase['threads'];
			break;
		case 'mostreplythread':
			$head1 = $vbphrase['thread'];
			$head2 = $vbphrase['replies'];
			break;
		case 'mostviewthread':
			$head1 = $vbphrase['thread'];
			$head2 = $vbphrase['views'];
			break;
		case 'mostpopularforum':
			$head1 = $vbphrase['forum'];
			$head2 = $vbphrase['replies'];
			break;
		case 'newpoll':
			$head1 = $vbphrase['thread'];
			$head2 = $vbphrase['imdmamount'];
			break;
		case 'mostvotepoll':
			$head1 = $vbphrase['thread'];
			$head2 = $vbphrase['votes'];
			break;
	}
    
	($hook = vBulletinHook::fetch_hook('imdmtopstats_top_start')) ? eval($hook) : false;

	for ($i = 0; $i <= $result - 1; $i++)
	{
		$bgclass = exec_switch_bg();
		// build columns
		$top = $cache["$keyword"]["$i"];
		if (!is_array($top))
		{
			continue;
		}
		if (in_array($keyword, array('newmember', 'topposter', 'toprich', 'topthank', 'banneduser', 'threadstarter')))
		{
			$top['username'] = imdm_trim($top['username'], $utrim);
			$column1 = "<a href='member.php?u=" . $top['c1'][0] . "' title='" . $top['c1'][1] . "'>" . $top['c1'][2] . "</a>";
		} else
			if (in_array($keyword, array('mostreplythread', 'mostviewthread', 'newpoll', 'mostvotepoll')))
			{
				$column1 = "<a href='showthread.php?t=" . $top['c1'][0] . "' title='" . $top['c1'][1] . "'>" . $top['c1'][2] . "</a>";
			}
			else
			{
				$column1 = "<a href='forumdisplay.php?f=" . $top['c1'][0] . "' title='" . $top['c1'][1] . "'>" . $top['c1'][2] . "</a>";
			}

		$column2 = $top['c2'];

		$bit = vB_Template::create('imdmstat_top_bit');
		$bit->register('bgclass', $bgclass);
		if ($keyword == 'toprich' AND !is_array($cache['toprich']))
		{
			$bit->register('column1', "Column $point_field is not exist!");
			$bit->register('column2', '');
			$topbit .= $bit->render();
			break;
		}
        
		($hook = vBulletinHook::fetch_hook('imdmtopstats_top_complete')) ? eval($hook) : false;

		$bit->register('column1', $column1);
		$bit->register('column2', $column2);
		$topbit .= $bit->render();
	}
	$tpl = vB_Template::create('imdmstat_top_head');
	$tpl->register('head1', $head1);
	$tpl->register('head2', $head2);
	$tpl->register('topbit', $topbit);
	$vbulletin->db->free_result($top_query);

	return $tpl->render();
}

// function to get top
function imdm_buildtop()
{
	global $vbulletin;
	// Trim Value
	$utrim = $vbulletin->options['imdmstats_topusertrim'];
	$ttrim = $vbulletin->options['imdmstats_topthreadtrim'];
	$ftrim = $vbulletin->options['imdmstats_topforumtrim'];

	$point_field = $vbulletin->options['imdmstats_pointfield'];

	// TOP
	$cache = array();

	$resultlist = explode(",", $vbulletin->options['imdmstats_chooseresult']);
	$result = $resultlist[count($resultlist)-1];

	foreach(imdm_topkeys() AS $keyword)
	{
		// collect tops
		// check for existing $point_field column in user table
		if ($keyword == 'toprich')
		{
			if (!$vbulletin->db->query_first("SHOW COLUMNS FROM " . TABLE_PREFIX . "user LIKE '$point_field'"))
			{
				$cache['toprich'] = '';
				continue;
			}
		}

		switch ($keyword)
		{
			case 'newmember':
				$q_select = 'userid,username,joindate,usergroupid,displaygroupid';
				$q_from = 'user';
				$q_order = 'userid DESC';
				break;
			case 'topposter':
				$q_select = 'userid,username,posts,usergroupid,displaygroupid';
				$q_from = 'user';
				$q_order = 'posts DESC';
				break;
			case 'toprich':
				$q_select = "userid,username,$point_field,usergroupid,displaygroupid";
				$q_from = 'user';
				$q_order = "$point_field DESC";
				break;
			case 'topthank':
				$q_select = 'userid,username,post_thanks_thanked_times,usergroupid,displaygroupid';
				$q_from = 'user';
				$q_order = 'post_thanks_thanked_times DESC';
				break;
			case 'banneduser':
				$q_select = 'userban.userid,userban.bandate,user.usergroupid, user.displaygroupid,user.username';
				$q_from = "userban AS userban
						LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = userban.userid)";
				$q_order = 'userban.bandate DESC';
				break;
			case 'threadstarter':
				$q_select = 'COUNT(thread.threadid) AS threads, thread.postuserid, thread.dateline, user.userid, user.usergroupid, user.displaygroupid, user.username';
				$q_from = "thread AS thread
						LEFT JOIN " . TABLE_PREFIX . "user AS user ON (thread.postuserid = user.userid)
						LEFT JOIN " . TABLE_PREFIX . "forum AS forum ON (forum.forumid = thread.forumid)
						WHERE thread.visible = 1
						GROUP BY thread.postuserid";
				$q_order = 'threads DESC';
				break;
			case 'mostreplythread':
				$q_select = 'threadid,title,replycount';
				$q_from = 'thread';
				$q_order = 'replycount DESC';
				break;
			case 'mostviewthread':
				$q_select = 'threadid,title,views';
				$q_from = 'thread';
				$q_order = 'views DESC';
				break;
			case 'mostpopularforum':
				$q_select = 'forumid,title,replycount';
				$q_from = 'forum';
				$q_order = 'replycount DESC';
				break;
			case 'newpoll':
				$q_select = 'poll.pollid,poll.question,thread.pollid,thread.threadid,thread.title';
				$q_from = "poll AS poll
						LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON (thread.pollid = poll.pollid)
						WHERE poll.active = 1";
				$q_order = 'poll.pollid DESC';
				break;
			case 'mostvotepoll':
				$q_select = 'poll.pollid,poll.question,poll.voters,thread.pollid,thread.threadid,thread.title';
				$q_from = "poll AS poll
						LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON (thread.pollid = poll.pollid)
						WHERE poll.active = 1";
				$q_order = 'poll.voters DESC';
				break;
			default:
				($hook = vBulletinHook::fetch_hook('imdmtopstats_buildtop_start')) ? eval($hook) : false;
				break;
		}
	
		$top_query = $vbulletin->db->query_read("
			SELECT $q_select 
			FROM " . TABLE_PREFIX . "$q_from 
			ORDER BY $q_order 
			LIMIT $result
		");

		while ($top = $vbulletin->db->fetch_array($top_query))
		{
			if (in_array($keyword, array('newmember', 'topposter', 'toprich', 'topthank', 'banneduser', 'threadstarter')))
			{
				$top['username'] = imdm_trim($top['username'], $utrim);
				$column1 = array($top['userid'], $top['username'], fetch_musername($top));
			} else
				if (in_array($keyword, array('mostreplythread', 'mostviewthread', 'newpoll', 'mostvotepoll')))
				{
					$column1 = array($top['threadid'], $top['title'], imdm_trim($top['title'], $ttrim));
				}
	
			switch ($keyword)
			{
				case 'newmember':
					$column2 = vbdate($vbulletin->options['imdmstats_userdate'], $top['joindate']);
					break;
				case 'topposter':
					$column2 = $top['posts'];
					break;
				case 'toprich':
					$column2 = round($top["$point_field"]);
					break;
				case 'topthank':
					$column2 = $top['post_thanks_thanked_times'];
					break;
				case 'banneduser':
					break;
					$column2 = vbdate($vbulletin->options['imdmstats_userdate'], $top['bandate']);
				case 'threadstarter':
					$column2 = $top['threads'];
					break;
				case 'mostreplythread':
					$column2 = $top['replycount'];
					break;
				case 'mostviewthread':
					$column2 = $top['views'];
					break;
				case 'mostpopularforum':
					$column1 = array($top['forumid'], $top['title'], imdm_trim($top['title'], $ttrim));
					$column2 = $top['replycount'];
					break;
				case 'newpoll':
					$column2 = '- ';
					break;
				case 'mostvotepoll':
					$column2 = $top['voters'];
					break;
				default:
					($hook = vBulletinHook::fetch_hook('imdmtopstats_buildtop_complete')) ? eval($hook) : false;
					break;
			}

			$cache["$keyword"][] = array('c1' => $column1, 'c2' => $column2);
		}
	}


	build_datastore('imdmstat', serialize($cache), 1);
	unset($cache);
}

// function to get tip
function imdm_tip($threadid = 0)
{
	global $vbulletin;
	$tips = $vbulletin->db->query_read("
		SELECT thread.threadid, thread.title, " . iif($vbulletin->options['top_lpshowprefix'], ' thread.prefixid,') . " thread.lastpost, thread.lastpostid, thread.forumid, thread.replycount, thread.views, thread.lastposter, thread.postusername AS threadstarter, thread.dateline, thread.visible, thread.open, user.username, user.userid, user.usergroupid, IF(user.displaygroupid=0, user.usergroupid, user.displaygroupid) AS displaygroupid
		FROM " . TABLE_PREFIX . "thread AS thread
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.username = thread.lastposter)
		WHERE thread.threadid = " . intval($threadid) . "
		LIMIT 1
	");

	while ($tip = $vbulletin->db->fetch_array($tips))
	{
		// get threadstarter and markup
		$tip['lastposter'] = fetch_musername($tip);
		$tip['threadstarttime'] = vbdate($vbulletin->options['dateformat'], $tip['ateline'], 1) . ' ' . vbdate($vbulletin->options['timeformat'], $tip['dateline']);

		// get forum title store thread and trim
		$tip['forumname'] = strip_tags($vbulletin->forumcache["$tip[forumid]"]['title_clean']); // remove html tag

		if ($vbulletin->options['imdmstats_lpshowprefix'] AND $tip['prefixid'])
		{
			$tip['prefixplain'] = $vbphrase['prefix_' . $tip['prefixid'] . '_title_plain'];
			$tip['prefixrich'] = $vbphrase['prefix_' . $tip['prefixid'] . '_title_rich'];
		}

		// imdme time format
		$tip['lastposttime'] = vbdate($vbulletin->options['dateformat'], $tip['lastpost'], 1) . ' ' . vbdate($vbulletin->options['timeformat'], $tip['lastpost']);
		$tpl = vB_Template::create('imdmstat_detail');
		$tpl->register('tip', $tip);
		$vbulletin->db->free_result($tips);
	
		return $tpl->render();
	}
}

// function navigation
function imdm_postnav($postid, $direct)
{
	global $vbulletin;
	$postinfo = verify_id('post', $postid, 1, 1);
	$threadid = $postinfo['threadid'];
	$dateline = (($direct == 'nextpost') ? '> ' : '< ') . $postinfo['dateline'];
	$forumperms = fetch_permissions($threadid);

	if ($getnavprev = $vbulletin->db->query_first_slave("
		SELECT threadid, postid, dateline
		FROM " . TABLE_PREFIX . "post
		WHERE threadid = $threadid AND visible = 1
		AND dateline $dateline
		ORDER BY dateline " . iif(($direct == 'prevpost'), 'DESC') . "
		LIMIT 1
	"))
	{
		$postid = $getnavprev['postid'];
	} else
	{
		$threadinfo = verify_id('thread', $threadid, 1, 1);
		$postid = $threadinfo['lastpostid'];
		unset($threadinfo);
	}
	unset($postinfo);

	return $postid;
}

// function to trimm title
function imdm_trim($title, $num)
{
	if ($num > 0 AND strlen($title) > $num)
	{
		$title = fetch_trimmed_title($title, $num);
	}
	return $title;
}

function imdm_topkeys()
{
	global $vbulletin;

	$toplist = array();
	$deftops = unserialize($vbulletin->options['imdmstats_top_choose']);

	foreach($deftops AS $top)
	{
		foreach(explode('#', $top) AS $k)
		{
			$toplist[] = $k;
		}
	}
	return $toplist;
}

function imdm_option($title, $opt = '')
{
	return "<li $opt><a href=\"javascript://\">$title</a></li>";
}

?>