<?php
// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('GET_EDIT_TEMPLATES', true);
define('THIS_SCRIPT', 'ajaximdmstat');
define('CSRF_PROTECTION', true);
define('LOCATION_BYPASS', 1);
define('NOPMPOPUP', 1);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array('imdmstat');

// pre-cache templates used by all actions
$globaltemplates = array(
	'imdmstat_latestpost_head',
	'imdmstat_latestpost_bit',
	'imdmstat_top_head',
	'imdmstat_top_bit',
	'imdmstat_delail'
);

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once (DIR . '/includes/functions_imdmstat.php');
require_once (DIR . '/includes/class_xml.php');

if ($vbulletin->options['imdmstats_turn'])
{
	// get result value
	$vbulletin->input->clean_array_gpc('p', array(
 		'listforumid' => TYPE_NOHTML,		
		'result' => TYPE_UINT
	));
	$result = intval($vbulletin->GPC['result']);

	$results = explode(",", $vbulletin->options['imdmstats_chooseresult']);
	if (in_array($result, $results))
	{
		// latest posts
		if ($_POST['do'] == 'latestposts')
		{
			$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
			$xml->add_group('imdmstat');
			
			$forumids = $vbulletin->GPC['listforumid'] OR -1;
			$imdmlp = imdm_lp($forumids, $result);

			$xml->add_tag('imdmlp', $imdmlp);
			$xml->close_group();
			$xml->print_xml();
		}


		// tops
		if ($vbulletin->options['imdmstats_top_turn'] AND in_array($_POST['do'], imdm_topkeys()))
		{
			$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
			$xml->add_group('imdmstat');

			$imdmtop = imdm_top($_POST['do'], $result);

			$xml->add_tag('imdmtop', $imdmtop);
			$xml->close_group();
			$xml->print_xml();
		}
	}

	// tip
	if ($_POST['do'] == 'tip')
	{
		$vbulletin->input->clean_array_gpc('p', array('t' => TYPE_UINT));

		$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
		$xml->add_group('imdmstat');

		$tooltip = imdm_tip($vbulletin->GPC['t']);

		$xml->add_tag('tooltip', $tooltip);
		$xml->close_group();
		$xml->print_xml();
	}

	// post navigation
	if (in_array($_POST['do'], array('prevpost', 'nextpost')))
	{
		$vbulletin->input->clean_array_gpc('p', array('p' => TYPE_UINT));

		echo imdm_postnav($vbulletin->GPC['p'], $_POST['do']);
		exit;
	}

	// enable-disable statistics
	if (in_array($_REQUEST['do'], array('enable', 'disable')))
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET imdmstat = " . iif($_REQUEST['do'] == 'enable', 1, 0) . " WHERE userid = " . $vbulletin->userinfo['userid']);
		exec_header_redirect($vbulletin->options['forumhome'].'.php');
		exit;
	}
}
?>