/**
 * @author mad@Max
 * Advanced Statistics by mad@Max
 * Version 1.0.2
 */
function imDMStat(intr, arel){
    this.store = new Array();
    this.listtab = null;
    this.uid = null;
    this.timer = null;
    this.topOn = false;
    this.pl = false;
    
    this.intr = intr;
    this.aRel = arel;
    this.bb = this.checkbb(BBURL);
    
    this.lpSel = fetch_object('clp_select');
    this.rel = fetch_object('cas_rel');
    this.cookieRes = fetch_cookie('fcresult');
    this.tab = fetch_cookie('clastpost');
}

/**
 *  init
 *   
 */
imDMStat.prototype.init = function(){
    if (typeof(MDMPL) != 'undefined') {
        this.pl = new MDMPL('imDMStat', this.bb, this.uid);
    }
    this.tippost();
    
    if (this.rel) {
        //   
        YAHOO.util.Event.on(this.rel, "click", this.mouseEvent, this, true);
    }
    
    this.regEvents('res');
    this.regEvents('sellp');
    if (fetch_object('imdmtops')) {
        this.regEvents('tops');
        this.topOn = true;
    }
    
    if (this.cookieRes) {
        this.store[5] = this.cookieRes;
    }
    
    if (this.aRel) {
        var that = this;
        var timer = setInterval(function(){
            that.posts(that.store[0]);
        }, 1000 * this.intr);
    }
};

/**
 *  posts
 *      ( )
 */
imDMStat.prototype.posts = function(order){
    if (this.lpSel) {
        this.lpSel.innerHTML = fetch_object('clp' + order).firstChild.innerHTML;
    }
    
    if (this.tab != order) {
        set_cookie('clastpost', order);
    }
    this.store[0] = order;
    var postload = fetch_object('cprogress_post');
    postload.className = "chshow";
    YAHOO.util.Connect.asyncRequest("POST", this.bb + '/ajaximdmstat.php?do=latestposts', {
        success: function(o){
            if (o.responseXML) {
                fetch_object('imdmstats_latestposts').innerHTML = o.responseXML.getElementsByTagName('imdmlp')[0].firstChild.nodeValue;
                postload.className = "hidden";
                this.tippost();
            }
        },
        failure: vBulletin_AJAX_Error_Handler,
        timeout: vB_Default_Timeout,
        scope: this
    }, SESSIONURL + '&securitytoken=' + SECURITYTOKEN + '&do=latestposts&listforumid=' + this.listtab[order] + '&result=' + this.store[5]);
};

/**
 *  top
 *    
 */
imDMStat.prototype.top = function(type, title, num){
    var topval = type + ':' + title;
    if (fetch_cookie('ctop_' + num) != topval) {
        set_cookie('ctop_' + num, topval);
    }
    var topload = fetch_object('cprogress_top');
    var topout = fetch_object('ctop_title_' + num);
    
    topload.className = "chshow";
    topout.innerHTML = vbphrase['imdmwait'];
    this.store[num] = [type, title];
    
    YAHOO.util.Connect.asyncRequest("POST", this.bb + '/ajaximdmstat.php?do=' + type, {
        success: function(o){
            if (o.responseXML) {
                topout.innerHTML = title;
                fetch_object('imdmstats_topbox_' + num).innerHTML = o.responseXML.getElementsByTagName('imdmtop')[0].firstChild.nodeValue;
                topload.className = "hidden";
            }
        },
        failure: vBulletin_AJAX_Error_Handler,
        timeout: vB_Default_Timeout,
        scope: this
    }, SESSIONURL + '&securitytoken=' + SECURITYTOKEN + '&do=' + type + '&result=' + this.store[5]);
};

/**
 *  rechooseTop
 *     
 */
imDMStat.prototype.rechooseTop = function(){
    for (var i = 1; i <= 4; i++) {
        if (typeof(this.store[i]) != 'undefined') {
            this.top(this.store[i][0], this.store[i][1], i);
        }
    }
};

/**
 *  regEvent
 *    
 */
imDMStat.prototype.regEvents = function(type){
    //        
    var match, item, items = fetch_tags(fetch_object('imdm' + type), 'li');
    for (var i = 0; typeof items[i] != 'undefined'; i++) {
        item = items[i];
        if (type == 'tops' && item.id.match(/ctop(.*)/) == null || type == 'res' && item.type != 1) {
            if (item.type != 'i') {
                continue;
            }
        }
        YAHOO.util.Event.on(item, "click", this.mouseEvent, this, true);
        if (YAHOO.util.Dom.hasClass(item, 'chsel')) {
            switch (type) {
                case 'sellp':{
                    this.store[0] = item.id.match(/clp(\d+)/)[1];
                    break;
                }
                case 'tops':{
                    match = item.id.match(/ctop(\d+)_(.*)/);
                    this.store[match[1]] = [match[2], new String(item.firstChild.innerHTML)];
                    break;
                }
                case 'res':{
                    this.store[5] = new Number(item.firstChild.innerHTML);
                    break;
                }
            }
        }
    }
    console.log("Registred %s selectable items", i);
};

/**
 *  mouseEvent
 *     
 */
imDMStat.prototype.mouseEvent = function(e){
    e = e || window.event;
    var match, obj = YAHOO.util.Event.getTarget(do_an_e(e)), upl = obj.parentNode;
    if (obj.id == 'cas_rel') {
        this.posts(this.store[0]);
    }
    else 
        if (upl.type == 'i') {
            this.cookieDel();
            alert('Cookies is deleted');
        }
        else 
            if (upl.type == 1) {
                YAHOO.vBulletin.vBPopupMenu.close_all();
                this.store[5] = new Number(upl.firstChild.innerHTML);
                this.posts(this.store[0]);
                this.rechooseTop();
                this.select(upl);
                set_cookie("fcresult", this.store[5]);
            }
            else {
                if (match = upl.id.match(/clp(\d+)/)) {
                    YAHOO.vBulletin.vBPopupMenu.close_all();
                    this.posts(match[1]);
                    this.select(upl);
                }
                else 
                    if (match = upl.id.match(/ctop(\d+)_(.*)/)) {
                        YAHOO.vBulletin.vBPopupMenu.close_all();
                        this.top(match[2], upl.firstChild.innerHTML, match[1]);
                        this.select(upl);
                    }
                    else 
                        if (match = upl.id.match(/ch_(\d+)_(\d+)/)) {
                            switch (e.type) {
                                case 'mouseover':{
                                    if (typeof(MDMTT) == 'undefined'){break;}
                                    MDMTT.show(obj, match[1]);
                                    break;
                                }
                                case 'mouseout':{
                                    if (typeof(MDMTT) == 'undefined'){break;}
                                    MDMTT.hide();
                                    break;
                                }
                                case 'click':{
                                    if (!this.pl){break;}
                                    this.pl.showPost(match[2], match[1]);
                                    break;
                                }
                            }
                        }
            }
};

/**
 *  tippost
 *     
 *   
 */
imDMStat.prototype.tippost = function(){
    var match, item, items = fetch_tags(fetch_object('imdmstats_latestposts'), 'span');
    for (var i = 0; typeof items[i] != 'undefined'; i++) {
        item = items[i];
        if (YAHOO.util.Dom.hasClass(item, 'chtip')) {
            YAHOO.util.Event.on(item, "mouseover", this.mouseEvent, this, true);
            YAHOO.util.Event.on(item, "mouseout", this.mouseEvent, this, true);
        }
        else 
            if (YAHOO.util.Dom.hasClass(item, 'chpost')) {
                YAHOO.util.Event.on(item, "click", this.mouseEvent, this, true);
            }
        
    }
};

/**
 *  cookieDel
 *  cookies  
 */
imDMStat.prototype.cookieDel = function(){
    delete_cookie('ctop_1');
    delete_cookie('ctop_2');
    delete_cookie('ctop_3');
    delete_cookie('ctop_4');
    delete_cookie('clastpost');
    delete_cookie('fcresult');
};

/**
 *  checkbb
 *    www
 */
imDMStat.prototype.checkbb = function(bb){
    if (document.location.href.search(/www\./) != -1) {
        if (bb.search(/www\./) != -1) {
            return bb;
        }
        else {
            return 'http://www.' + ((bb.substring(0, 7) == 'http://') ? bb.substring(7) : bb);
        }
    }
    else {
        return (bb.search(/www\./) != -1) ? bb.replace(/www\./, '') : bb;
    }
};

/**
 *  select
 *   
 */
imDMStat.prototype.select = function(obj){
    var i, items = fetch_tags(obj.parentNode, 'li');
    for (i = 0; typeof items[i] != 'undefined'; i++) {
        YAHOO.util.Dom.removeClass(items[i], 'chsel');
    }
    YAHOO.util.Dom.addClass(obj, 'chsel');
};