<?php

require_once(DIR . '/includes/class_dbalter.php');
$db_alter = new vB_Database_Alter_MySQL($db);


echo '<ul>';
// New Tables

$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_thanks_entry`
	(
		`entryid` int(10) unsigned NOT NULL AUTO_INCREMENT,
		`entrytype` enum('thanks','like','dislike') NOT NULL,
		`userid` int(10) unsigned NOT NULL DEFAULT '0',
		`contenttype` enum('post') NOT NULL,
		`contentid` int(10) unsigned NOT NULL DEFAULT '0',
		`dateline` int(10) unsigned NOT NULL DEFAULT '0',
		PRIMARY KEY (`entryid`),
		KEY `userid` (`userid`),
		KEY `contentid` (`contentid`),
		KEY `dateline` (`dateline`)
	)
");
print_modification_message('<li>Created Table: <strong><em>' . TABLE_PREFIX . 'dbtech_thanks_entry</em></strong></li>');

echo '</ul><ul>';
// Altered Tables

// Add the administrator field
if ($db_alter->fetch_table_info('administrator'))
{
	$db_alter->add_field(array(
		'name'       => 'dbtech_thanksadminperms',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	print_modification_message('<li>Altered Table: <strong><em>' . TABLE_PREFIX . 'administrator</em></strong></li>');	
}

// Add the forum field
if ($db_alter->fetch_table_info('forum'))
{
	$db->hide_errors();
	$db->query_write("ALTER TABLE `" . TABLE_PREFIX . "forum`ADD `dbtech_thanks_enablethanks` ENUM( '0', '1' ) NOT NULL DEFAULT '1'");
	$db->query_write("ALTER TABLE `" . TABLE_PREFIX . "forum`ADD `dbtech_thanks_enablelike` ENUM( '0', '1' ) NOT NULL DEFAULT '1'");
	$db->query_write("ALTER TABLE `" . TABLE_PREFIX . "forum`ADD `dbtech_thanks_enabledislike` ENUM( '0', '1' ) NOT NULL DEFAULT '1'");
	$db->show_errors();
	print_modification_message('<li>Altered Table: <strong><em>' . TABLE_PREFIX . 'forum</em></strong></li>');	
}

// Add the post field
if ($db_alter->fetch_table_info('post'))
{
	$db_alter->add_field(array(
		'name'       => 'dbtech_thanks_cache',
		'type'       => 'mediumtext',
		'null'       => true,	// True = NULL, false = NOT NULL
		'default'    => NULL
	));	
	$db->hide_errors();
	$db->query_write("ALTER TABLE `" . TABLE_PREFIX . "post` ADD `dbtech_thanks_enablethanks` ENUM( '0', '1' ) NOT NULL DEFAULT '1'");
	$db->query_write("ALTER TABLE `" . TABLE_PREFIX . "post` ADD `dbtech_thanks_enablelike` ENUM( '0', '1' ) NOT NULL DEFAULT '1'");
	$db->query_write("ALTER TABLE `" . TABLE_PREFIX . "post` ADD `dbtech_thanks_enabledislike` ENUM( '0', '1' ) NOT NULL DEFAULT '1'");
	$db->query_write("ALTER TABLE `" . TABLE_PREFIX . "post` ADD `dbtech_thanks_requirethanks_content` ENUM( '0', '1' ) NOT NULL DEFAULT '0'");
	$db->query_write("ALTER TABLE `" . TABLE_PREFIX . "post` ADD `dbtech_thanks_requirethanks_attach` ENUM( '0', '1' ) NOT NULL DEFAULT '0'");
	$db->query_write("ALTER TABLE `" . TABLE_PREFIX . "post` ADD `dbtech_thanks_requirelike_content` ENUM( '0', '1' ) NOT NULL DEFAULT '0'");
	$db->query_write("ALTER TABLE `" . TABLE_PREFIX . "post` ADD `dbtech_thanks_requirelike_attach` ENUM( '0', '1' ) NOT NULL DEFAULT '0'");
	$db->show_errors();
	print_modification_message('<li>Altered Table: <strong><em>' . TABLE_PREFIX . 'post</em></strong></li>');	
}

// Add the post field
if ($db_alter->fetch_table_info('thread'))
{
	$db->hide_errors();
	$db->query_write("ALTER TABLE `" . TABLE_PREFIX . "thread` ADD `dbtech_thanks_enablethanks` ENUM( '0', '1' ) NOT NULL DEFAULT '1'");
	$db->query_write("ALTER TABLE `" . TABLE_PREFIX . "thread` ADD ADD `dbtech_thanks_enablelike` ENUM( '0', '1' ) NOT NULL DEFAULT '1'");
	$db->query_write("ALTER TABLE `" . TABLE_PREFIX . "thread` ADD ADD `dbtech_thanks_enabledislike` ENUM( '0', '1' ) NOT NULL DEFAULT '1'");
	$db->show_errors();
	print_modification_message('<li>Altered Table: <strong><em>' . TABLE_PREFIX . 'thread</em></strong></li>');	
}

// Add the usergroup field
if ($db_alter->fetch_table_info('user'))
{
	$db_alter->add_field(array(
		'name'       => 'dbtech_thanks_likes',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	$db_alter->add_field(array(
		'name'       => 'dbtech_thanks_liked',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	$db_alter->add_field(array(
		'name'       => 'dbtech_thanks_thanks',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	$db_alter->add_field(array(
		'name'       => 'dbtech_thanks_thanked',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	$db_alter->add_field(array(
		'name'       => 'dbtech_thanks_dislikes',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	$db_alter->add_field(array(
		'name'       => 'dbtech_thanks_disliked',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	$db_alter->add_field(array(
		'name'       => 'dbtech_thanks_points',
		'type'       => 'int',
		'length'     => '10',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	$db_alter->add_field(array(
		'name'       => 'dbtech_thanks_settings',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	print_modification_message('<li>Altered Table: <strong><em>' . TABLE_PREFIX . 'user</em></strong></li>');	
}

if ($db_alter->fetch_table_info('usergroup'))
{
	$db_alter->add_field(array(
		'name'       => 'dbtech_thankspermissions',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	print_modification_message('<li>Altered Table: <strong><em>' . TABLE_PREFIX . 'usergroup</em></strong></li>');	
}

echo '</ul>';
?>