<?php

/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

function prepare_entry_cache(&$entrycache)
{
	global $vbulletin;
	
	if (file_exists(DIR . '/includes/xml/bitfield_dbtech_thanks_pro.xml'))
	{
		foreach ($entrycache as $postid => $entrytypes)
		{
			foreach ($entrytypes as $entrytype => $results)
			{
				// Count how many of each result we have
				$i = 0;			
				foreach ($results['data'] as $key => $result)
				{
					// Check how many we've done
					$i++;
					
					if ($i > 5)
					{
						// Get rid of content that goes beyond the limit
						unset($entrycache["$postid"]["$entrytype"]['data']["$key"]);
						
						// Increment the "others" counter
						$entrycache["$postid"]["$entrytype"]['totals']++;					
					}
				}
			}
		}
	}
	
	foreach ($entrycache as $postid => $entrytypes)
	{
		foreach ($entrytypes as $entrytype => $results)
		{
			// Reset the array
			$entrycache["$postid"]["$entrytype"]['data'] = array();
			
			foreach ($results['data'] as $key => $result)
			{
				// Fetch musername
				fetch_musername($result);
				
				$entrycache["$postid"]["$entrytype"]['data']["$result[userid]"] = '<a href="' . (intval($vbulletin->versionnumber) == 3 ? "member.php?" . $vbulletin->session->vars['sessionurl'] . "u=$result[userid]" : fetch_seo_url('member', $result)) . '" target="_blank" title="' . vbdate($vbulletin->options['dateformat'], $result['dateline']) . ' ' . vbdate($vbulletin->options['timeformat'], $result['dateline']) . '">' . trim($result['musername']) . '</a>';
			}
		}
	}	
}
?>