// Setup the main object
Thanks_Obj = function()
{
	// Which blocks correspond to which thingy
	this.postid 	= 0;
	
	// #########################################################################
	// Initialise the Info Panels
	this.init = function(postid)
	{
		this.postid = postid;
		
		if (!AJAX_Compatible)
		{
			// AJAX won't work, this is foar srs.
			YAHOO.util.Dom.get('dbtech_thanks_status_' + this.postid).innerHTML = 'Either your browser does not support AJAX, or the forum administrator has chosen to disable AJAX. InfoPanels cannot run under these conditions.';
			// REPLACESTRING
			
			return false;
		}
	}
	
	
	
	// #########################################################################
	// Shorthand for an ajax call
	this.ajax_call = function(varname, extraparams)
	{
		return YAHOO.util.Connect.asyncRequest('POST', 'ajax.php', {
			success: this.ajax_completed,
			failure: this.handle_ajax_error,
			timeout: vB_Default_Timeout,
			scope: this
		}, SESSIONURL + 'securitytoken=' + SECURITYTOKEN + '&do=dbtech_thanks_' + varname + '&postid=' + this.postid + extraparams);
	}
	
	// #########################################################################
	// Finalise fetching of content
	this.ajax_completed = function(ajax)
	{
		if (!ajax.responseXML)
		{
			// Empty response
			YAHOO.util.Dom.get('dbtech_thanks_status_' + this.postid).innerHTML = 'Invalid response from server: ' + ajax.responseText;
			return false;
		}
		
		// check for error first
		var error = ajax.responseXML.getElementsByTagName('error');
			
		if (error.length)
		{
			// Throw the error returned
			YAHOO.util.Dom.get('dbtech_thanks_status_' + this.postid).innerHTML = error[0].firstChild.nodeValue;
			return false;
		}
		
		// Reset status
		YAHOO.util.Dom.get('dbtech_thanks_status_' + this.postid).innerHTML = '';
		
		var wrapper = ajax.responseXML.getElementsByTagName('wrapper');
		if (wrapper.length)
		{
			// Parse block 1
			YAHOO.util.Dom.get('dbtech_thanks_wrapper_' + this.postid).innerHTML = wrapper[0].firstChild.nodeValue;
		}
		
		var actions = ajax.responseXML.getElementsByTagName('actions');
		if (actions.length)
		{
			// Parse block 1
			YAHOO.util.Dom.get('dbtech_thanks_actions_' + this.postid).innerHTML = actions[0].firstChild.nodeValue;
		}
		
		var displaypost = ajax.responseXML.getElementsByTagName('displaypost');
		if (displaypost.length)
		{
			// Parse block 1
			display_post(this.postid);
		}		
	}
	
	// #########################################################################
	// This should never happen.
	this.handle_ajax_error = function(ajax)
	{
		if (ajax.statusText == 'transaction aborted' || ajax.statusText == 'communication failure')
		{
			// Try again!
			return false;
		}
		
		if (YAHOO.util.Dom.get('dbtech_thanks_status_' + this.postid))
		{
			YAHOO.util.Dom.get('dbtech_thanks_status_' + this.postid).innerHTML = ajax.statusText;
			
			// Log the error to the console
			console.error(this.timestamp() + "AJAX Error: Status = %s: %s", ajax.status, ajax.statusText);
		}
		else
		{
			// Just pop it up
			alert(ajax.statusText);
		}
	}
}