<?php

/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/


/**
* Postbit optimized for posts with no content - requires thanks
*/
class vB_Postbit_Thanks extends vB_Postbit_Post
{
	/**
	* May not be displayed.
	*/
	function process_attachments()
	{
		global $show, $vbphrase, $entrycache;
		
		if ($this->post['attachments'])
		{
			if ($this->post['dbtech_thanks_requirethanks_attach'] AND $this->post['userid'] != $this->registry->userinfo['userid'] AND !$entrycache["{$this->post[postid]}"]['thanks']['data']["{$this->registry->userinfo[userid]}"])
			{
				// We require thanks
				$show['attachments'] = true;
				$show['otherattachment'] = true;
				$this->post['otherattachments'] = '<li>' . $vbphrase['dbtech_thanks_attachment_requires_thanks'] . '</li>';
			}
			else if ($this->post['dbtech_thanks_requirelike_attach'] AND $this->post['userid'] != $this->registry->userinfo['userid'] AND !$entrycache["{$this->post[postid]}"]['like']['data']["{$this->registry->userinfo[userid]}"])
			{
				// We require like
				$show['attachments'] = true;
				$show['otherattachment'] = true;
				$this->post['otherattachments'] = $vbphrase['dbtech_thanks_attachment_requires_like'];			
			}
			else
			{
				parent::process_attachments();
			}
		}
	}
	
	/**
	* Override message
	*/
	function parse_bbcode()
	{
		global $vbphrase, $entrycache;
		
		if ($this->post['dbtech_thanks_requirethanks_content'] AND $this->post['userid'] != $this->registry->userinfo['userid'] AND !$entrycache["{$this->post[postid]}"]['thanks']['data']["{$this->registry->userinfo[userid]}"])
		{
			// We require thanks
			$this->post['message'] = $vbphrase['dbtech_thanks_post_requires_thanks'];			
		}
		else if ($this->post['dbtech_thanks_requirelike_content'] AND $this->post['userid'] != $this->registry->userinfo['userid'] AND !$entrycache["{$this->post[postid]}"]['like']['data']["{$this->registry->userinfo[userid]}"])
		{
			// We require like
			$this->post['message'] = $vbphrase['dbtech_thanks_post_requires_like'];			
		}
		else
		{
			// We're in the clear
			parent::parse_bbcode();
		}
	}
}

/**
* Postbit optimized for downranked posts
*/
class vB_Postbit_Thanks_Downranked extends vB_Postbit_Post
{
	/**
	* The name of the template that will be used to display this post.
	*
	* @var	string
	*/
	var $templatename = 'dbtech_thanks_postbit_downranked';

	/**
	* Will not be displayed. No longer does anything.
	*/
	function process_attachments()
	{
	}

	/**
	* Will not be displayed. No longer does anything.
	*/
	function process_im_icons()
	{
	}

	/**
	* Will not be displayed. No longer does anything.
	*/
	function parse_bbcode()
	{
	}
}
?>