<?php

/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

print_cp_header($vbphrase['maintenance']);

$vbulletin->input->clean_array_gpc('r', array(
	'perpage' => TYPE_UINT,
	'startat' => TYPE_UINT
));

if (empty($vbulletin->GPC['perpage']))
{
	$vbulletin->GPC['perpage'] = 1000;
}

echo '<p>' . $vbphrase['dbtech_thanks_recalculating'] . '</p>';

$users = $db->query_read_slave("
	SELECT userid,
		(
			SELECT COUNT(*) AS value
			FROM " . TABLE_PREFIX . "dbtech_thanks_entry AS entry
			WHERE entry.userid = user.userid
				AND entrytype = 'like'
		) AS dbtech_thanks_likes,
		
		(
			SELECT COUNT(*) AS value
			FROM " . TABLE_PREFIX . "dbtech_thanks_entry AS entry
			LEFT JOIN " . TABLE_PREFIX . "post AS post ON(post.postid = entry.contentid)
			WHERE post.userid = user.userid
				AND entrytype = 'like'
		) AS dbtech_thanks_liked,
		
		(
			SELECT COUNT(*) AS value
			FROM " . TABLE_PREFIX . "dbtech_thanks_entry AS entry
			WHERE entry.userid = user.userid
				AND entrytype = 'thanks'
		) AS dbtech_thanks_thanks,
		
		(
			SELECT COUNT(*) AS value
			FROM " . TABLE_PREFIX . "dbtech_thanks_entry AS entry
			LEFT JOIN " . TABLE_PREFIX . "post AS post ON(post.postid = entry.contentid)
			WHERE post.userid = user.userid
				AND entrytype = 'thanks'
		) AS dbtech_thanks_thanked,
		
		(
			SELECT COUNT(*) AS value
			FROM " . TABLE_PREFIX . "dbtech_thanks_entry AS entry
			WHERE entry.userid = user.userid
				AND entrytype = 'dislike'
		) AS dbtech_thanks_dislikes,
		
		(
			SELECT COUNT(*) AS value
			FROM " . TABLE_PREFIX . "dbtech_thanks_entry AS entry
			LEFT JOIN " . TABLE_PREFIX . "post AS post ON(post.postid = entry.contentid)
			WHERE post.userid = user.userid
				AND entrytype = 'dislike'
		) AS dbtech_thanks_disliked
	FROM " . TABLE_PREFIX . "user AS user
	WHERE userid >= " . $vbulletin->GPC['startat'] . "
	ORDER BY userid
	LIMIT " . $vbulletin->GPC['perpage']
);

$finishat = $vbulletin->GPC['startat'];

while ($user = $db->fetch_array($users))
{
	echo construct_phrase($vbphrase['processing_x'], $user['userid']) . "<br />\n";
	vbflush();
	
	// Shorthand
	$userid = intval($user['userid']);
	
	// Create the new value
	$user['dbtech_thanks_points'] = ($user['dbtech_thanks_liked'] + $user['dbtech_thanks_thanked']) - $user['dbtech_thanks_disliked'];
	
	$db->query_write("
		UPDATE " . TABLE_PREFIX . "user
		SET
			dbtech_thanks_likes = '" . intval($user['dbtech_thanks_likes']) . "',
			dbtech_thanks_liked = '" . intval($user['dbtech_thanks_liked']) . "',
			dbtech_thanks_thanks = '" . intval($user['dbtech_thanks_thanks']) . "',
			dbtech_thanks_thanked = '" . intval($user['dbtech_thanks_thanked']) . "',
			dbtech_thanks_dislikes = '" . intval($user['dbtech_thanks_dislikes']) . "',
			dbtech_thanks_disliked = '" . intval($user['dbtech_thanks_disliked']) . "',
			dbtech_thanks_points = '" . intval($user['dbtech_thanks_points']) . "'
		WHERE userid = '$userid'
	");
	
	$finishat = ($user['userid'] > $finishat ? $user['userid'] : $finishat);
}

$finishat++;

if ($checkmore = $db->query_first_slave("SELECT userid FROM " . TABLE_PREFIX . "user WHERE userid >= $finishat LIMIT 1"))
{
	print_cp_redirect("thanks.php?" . $vbulletin->session->vars['sessionurl'] . "do=recalc&startat=$finishat&pp=" . $vbulletin->GPC['perpage']);
	echo "<p><a href=\"thanks.php?" . $vbulletin->session->vars['sessionurl'] . "do=recalc&amp;startat=$finishat&amp;pp=" . $vbulletin->GPC['perpage'] . "\">" . $vbphrase['click_here_to_continue_processing'] . "</a></p>";
}
else
{	
	define('CP_REDIRECT', 'thanks.php?do=maintenance');
	print_stop_message('dbtech_thanks_recalc_successful');
}

print_cp_footer();


/*=======================================================================*\
|| ##################################################################### ||
|| # Created: 17:29, Sat Dec 27th 2008                                 # ||
|| # SVN: $RCSfile: vbshout.php,v $ - $Revision: $WCREV$ $
|| ##################################################################### ||
\*=======================================================================*/
?>