<?php

require_once(DIR . '/includes/class_dbalter.php');
$db_alter = new vB_Database_Alter_MySQL($db);

function print_modification_message($msg)
{
	echo $msg;
	vbflush();
	usleep(500000);
}

echo '<ul>';
// Reverted Tables

// Drop
if ($db_alter->fetch_table_info('administrator'))
{
	$db_alter->drop_field('dbtech_usertagadminperms');
	print_modification_message('<li>Reverted Table: <strong><em>' . TABLE_PREFIX . 'administrator</em></strong></li>');	
}

$db->query_write("
	DELETE FROM `" . TABLE_PREFIX . "datastore` WHERE `title` LIKE 'dbtech_usertag_%'
");
print_modification_message('<li>Reverted Table: <strong><em>' . TABLE_PREFIX . 'datastore</em></strong></li>');

// Drop
if ($db_alter->fetch_table_info('forum'))
{
	$db_alter->drop_field('dbtech_thanks_enablethanks');
	$db_alter->drop_field('dbtech_thanks_enablelike');
	$db_alter->drop_field('dbtech_thanks_enabledislike');
	print_modification_message('<li>Reverted Table: <strong><em>' . TABLE_PREFIX . 'forum</em></strong></li>');	
}

if ($db_alter->fetch_table_info('post'))
{
	$db_alter->drop_field('dbtech_thanks_enablethanks');
	$db_alter->drop_field('dbtech_thanks_enablelike');
	$db_alter->drop_field('dbtech_thanks_enabledislike');
	$db_alter->drop_field('dbtech_thanks_requirethanks_content');
	$db_alter->drop_field('dbtech_thanks_requirethanks_attach');
	$db_alter->drop_field('dbtech_thanks_requirelike_content');
	$db_alter->drop_field('dbtech_thanks_requirelike_attach');
	print_modification_message('<li>Reverted Table: <strong><em>' . TABLE_PREFIX . 'post</em></strong></li>');	
}

if ($db_alter->fetch_table_info('thread'))
{
	$db_alter->drop_field('dbtech_thanks_enablethanks');
	$db_alter->drop_field('dbtech_thanks_enablelike');
	$db_alter->drop_field('dbtech_thanks_enabledislike');
	print_modification_message('<li>Reverted Table: <strong><em>' . TABLE_PREFIX . 'thread</em></strong></li>');	
}

if ($db_alter->fetch_table_info('user'))
{
	$db_alter->drop_field('dbtech_thanks_likes');
	$db_alter->drop_field('dbtech_thanks_liked');
	$db_alter->drop_field('dbtech_thanks_thanks');
	$db_alter->drop_field('dbtech_thanks_thanked');
	$db_alter->drop_field('dbtech_thanks_dislikes');
	$db_alter->drop_field('dbtech_thanks_disliked');
	$db_alter->drop_field('dbtech_thanks_points');
	$db_alter->drop_field('dbtech_thanks_settings');
	print_modification_message('<li>Reverted Table: <strong><em>' . TABLE_PREFIX . 'user</em></strong></li>');	
}

if ($db_alter->fetch_table_info('usergroup'))
{
	$db_alter->drop_field('dbtech_usertagpermissions');
	print_modification_message('<li>Reverted Table: <strong><em>' . TABLE_PREFIX . 'usergroup</em></strong></li>');	
}

echo '</ul><ul>';
// Deleted Tables


foreach (array(
	'dbtech_thanks_entry',
) as $table)
{
	$db->query_write("DROP TABLE IF EXISTS `" . TABLE_PREFIX . "{$table}`");
	print_modification_message('<li>Deleted Table: <strong><em>' . TABLE_PREFIX . $table . '</em></strong></li>');
}

echo '</ul>';
?>