<?php

if ($_REQUEST['do'] == 'dbtech_thanks_statistics')
{
	// Set the limit on number of users to fetch
	$limit = (isset($vbulletin->options['dbtech_thanks_statistics_topx']) ? $vbulletin->options['dbtech_thanks_statistics_topx'] : 5);
	
	// Start SQL
	$SQL = array();
	
	$types = array('dbtech_thanks_thanks', 'dbtech_thanks_thanked', 'dbtech_thanks_likes', 'dbtech_thanks_liked');
	$types2 = array(
		'dbtech_thanks_thanks' 		=> $vbphrase['dbtech_thanks_thanks_given'],
		'dbtech_thanks_thanked' 	=> $vbphrase['dbtech_thanks_thanks_received'],
		'dbtech_thanks_likes' 		=> $vbphrase['dbtech_thanks_likes_given'],
		'dbtech_thanks_liked' 		=> $vbphrase['dbtech_thanks_likes_received'],
	);
	
	if (file_exists(DIR . '/includes/xml/bitfield_dbtech_thanks_pro.xml'))
	{
		$types[] = 'dbtech_thanks_dislikes';
		$types[] = 'dbtech_thanks_disliked';
		$types2['dbtech_thanks_dislikes'] 	= $vbphrase['dbtech_thanks_dislikes_given'];
		$types2['dbtech_thanks_disliked'] 	= $vbphrase['dbtech_thanks_dislikes_received'];
	}
	
	foreach ($types as $type)
	{
		$SQL[] = "
		(
			SELECT
				{$type} AS value,
				'$type' AS typeid,
				userid,
				username,
				user.usergroupid,
				infractiongroupid,
				displaygroupid				
			FROM " . TABLE_PREFIX . "user AS user
			LEFT JOIN " . TABLE_PREFIX . "usergroup AS usergroup ON (usergroup.usergroupid = user.usergroupid)
			WHERE (usergroup.genericoptions & " . $vbulletin->bf_ugp_genericoptions['isnotbannedgroup'] . ")
			GROUP BY userid
			ORDER BY value DESC
			LIMIT $limit
		)
		";
	}
	
	// Init this array
	$leaders = array();
	
	if (!count($SQL))
	{
		// This went wrong
		return false;
	}
	
	// Fetch rewards
	$leaders_q = $db->query_read_slave(implode(' UNION ALL ', $SQL));
			
	while ($leaders_r = $db->fetch_array($leaders_q))
	{
		// Grab the musername
		fetch_musername($leaders_r);
		
		// Store a cache of the leaders
		$leaders["$leaders_r[typeid]"][] = $leaders_r;
	}
	$db->free_result($leaders_q);
	unset($leaders_r);		
	
	// Init these
	$i = 0;
	$leaderboardbits = '';
	
	foreach ($types as $type)
	{
		// Init this
		$userbits = array();
		$xmlbits = array();
		
		foreach ((array)$leaders["$type"] as $key => $userinfo)
		{
			if ($userinfo['value'] == 0)
			{
				// We don't want to count empty users
				continue;
			}
			
			if (intval($vbulletin->versionnumber) == 3)
			{
				$link = "member.php?" . $vbulletin->session->vars['sessionurl'] . "u=$userinfo[userid]";				
			}
			else
			{
				$link = fetch_seo_url('member', $userinfo);
			}
			$userinfo['musername'] = '<a href="' . $link . '" target="_blank">' . $userinfo['musername'] . '</a>';
			
			$j = ++$key;
			$templater = vB_Template::create('dbtech_thanks_statistics_userbit');
				$templater->register('userinfo', $userinfo);
			$userbits["$j"] .= $templater->render();

			if ($_REQUEST['xml'])
			{
				$xmlbits[] = array($userinfo['username'], $link, $userinfo['value']);
			}
		}
		
		for ($k = 1; $k <= $limit; $k++)
		{
			if (!$userbits["$k"])
			{
				// Didn't have this point
				$userbits["$k"] = vB_Template::create('dbtech_thanks_statistics_userbit')->render();
			}
		}
		
		// Make sure we also got the phrase
		$phrase = construct_phrase($vbphrase['dbtech_thanks_top_x'], $limit, $types2["$type"]);
		
		if ($_REQUEST['xml'])
		{
			$this->xml[] = array(
				'phrase'	=> $phrase,
				'bits'		=> $xmlbits,
			);
		}
		
		$templater = vB_Template::create('dbtech_thanks_statistics_statisticbit');
			$templater->register('phrase', $phrase);
			$templater->register('userbits', implode('', $userbits));
		$leaderboardbits .= $templater->render();
					
		$i++;
		if ($i % 4 == 0)
		{
			// Linebreak tiem
			//$leaderboardbits .= '<br />';
		}
	}
	
	// Set page titles
	$pagetitle = $navbits[] = $vbphrase['dbtech_thanks_statistics'];
	
	if (intval($vbulletin->versionnumber) == 3)
	{
		// Create navbits
		$navbits = construct_navbits($navbits);	
		eval('$navbar = "' . fetch_template('navbar') . '";');	
	}
	else
	{
		$navbar = render_navbar_template(construct_navbits($navbits));	
	}
	
	
	// Begin the page template
	$page_templater = vB_Template::create('dbtech_thanks_statistics');
		$page_templater->register('pagetitle', $pagetitle);
		$page_templater->register('leaderboardbits', $leaderboardbits);
	$HTML = $page_templater->render();
		
	// Prepare copyright footer
	$templater = vB_Template::create('dbtech_thanks_footer');
		$templater->register('year', date('Y'));
	$HTML .= $templater->render();	
	
	// Finish the main template
	$templater = vB_Template::create('GENERIC_SHELL');
		$templater->register_page_templates();
		$templater->register('HTML', 				$HTML);
		$templater->register('navbar', 				$navbar);
		$templater->register('pagetitle', 			$pagetitle);
		$templater->register('template_hook', 		$template_hook);
		$templater->register('includecss', 			$includecss);
		$templater->register('headinclude_bottom',	$headinclude_bottom);
	print_output($templater->render());
}
?>