/*
 * vbTrends 2.0 by Catnine Software
 * Copyright 2007-2008
 *
 */

// Get cached statistics from datastore
if ($vbulletin->options['vbtrends_enabled'])
{
  	$specialtemplates[] = "vbtrends";
	$vbulletin->datastore->fetch($specialtemplates);
	
	$vbtrends_posts = 0;
	$vbtrends_threads = 0;
	$vbtrends_joins = 0;
	
	$curdate = getdate();
	$vbtrends_new_day = false;
	$vbtrends_update = false;
	
	($hook = vBulletinHook::fetch_hook('trends_start')) ? eval($hook) : false;

	if (!$vbulletin->vbtrends || $vbulletin->vbtrends[0] != $curdate['mday'])
	{
		$vbtrends_new_day = true;
	}
	else
	{
	 	$vbtrends_posts = $vbulletin->vbtrends[2];
	 	$vbtrends_threads = $vbulletin->vbtrends[3];
	 	$vbtrends_joins = $vbulletin->vbtrends[4];
	}
	
	// Add delay minutes to stored time to see if we are ready for an update
	$delaycheck = 0;
	if (!$vbulletin->vbtrends || $vbulletin->options['vbtrends_delay'] == 0)
	{
		$vbtrends_update = true;
	}
	else
	{
		$delaycheck = $vbulletin->vbtrends[1] + ($vbulletin->options['vbtrends_delay'] * 60);
		if ($delaycheck < $curdate[0])
		{
			$vbtrends_update = true;
		}
	}
	
	// Do we need to run daily trends?
	if ($vbtrends_new_day)
	{
		// Get average posts		
		($hook = vBulletinHook::fetch_hook('trends_avg_posts')) ? eval($hook) : false;

		// Get average threads
		($hook = vBulletinHook::fetch_hook('trends_avg_threads')) ? eval($hook) : false;
	
		// Get average joins
		($hook = vBulletinHook::fetch_hook('trends_avg_joins')) ? eval($hook) : false;
	}

	/*
	 * Get this months statistics
	 */
	
	// Posts This Month
	($hook = vBulletinHook::fetch_hook('trends_cur_posts')) ? eval($hook) : false;

	// Threads This Month
	($hook = vBulletinHook::fetch_hook('trends_cur_threads')) ? eval($hook) : false;
	
	// Joins This Month
	($hook = vBulletinHook::fetch_hook('trends_cur_joins')) ? eval($hook) : false;
	
	// Last x joins
	($hook = vBulletinHook::fetch_hook('trends_last_x_joins')) ? eval($hook) : false;
	
	// Run the calculations
 	($hook = vBulletinHook::fetch_hook('trends_calc')) ? eval($hook) : false;
	
	// Do we need to save the datastore?
	if ($vbtrends_new_day || $vbtrends_update)
	{
	 	$vbtrends = array($curdate['mday'], $curdate[0], $vbtrends_posts, $vbtrends_threads, $vbtrends_joins, $vbtrends_posts_thismonth, $vbtrends_threads_thismonth, $vbtrends_joins_thismonth);		
		build_datastore('vbtrends', serialize($vbtrends), 1);
	}

	var_dump($errors);
	$show['thismonththreads'] = (count($errors) == 0) && ($vbtrends_threads_percentage >= 0 || !$vbulletin->options['vbtrends_posonly']);
	$show['thismonthposts'] = (count($errors) == 0) && ($vbtrends_posts_percentage >= 0 || !$vbulletin->options['vbtrends_posonly']);
	$show['thismonthjoins'] = (count($errors) == 0) && ($vbtrends_joins_percentage >= 0 || !$vbulletin->options['vbtrends_posonly']);

	$vbtrends_threads_image = iif($vbtrends_threads_percentage >= 0, "/vbtrends_up.gif", "/vbtrends_down.gif");
	$vbtrends_threads_alt = iif($vbtrends_threads_percentage >= 0, $vbphrase['vbtrends_up'], $vbphrase['vbtrends_down']);
	$vbtrends_threads_style = iif($vbtrends_threads_percentage >= 0, $vbulletin->options['vbtrends_poscss'], $vbulletin->options['vbtrends_negcss']);
	$vbtrends_posts_image = iif($vbtrends_posts_percentage >= 0, "/vbtrends_up.gif", "/vbtrends_down.gif");
	$vbtrends_posts_alt = iif($vbtrends_posts_percentage >= 0, $vbphrase['vbtrends_up'], $vbphrase['vbtrends_down']);
	$vbtrends_posts_style = iif($vbtrends_posts_percentage >= 0, $vbulletin->options['vbtrends_poscss'], $vbulletin->options['vbtrends_negcss']);
	$vbtrends_joins_image = iif($vbtrends_joins_percentage >= 0, "/vbtrends_up.gif", "/vbtrends_down.gif");
	$vbtrends_joins_alt = iif($vbtrends_joins_percentage >= 0, $vbphrase['vbtrends_up'], $vbphrase['vbtrends_down']);
	$vbtrends_joins_style = iif($vbtrends_joins_percentage >= 0, $vbulletin->options['vbtrends_poscss'], $vbulletin->options['vbtrends_negcss']);
	
	$show['activemembersper'] = $vbulletin->options['vbtrends_activemembersper'];
	$numbermembers_calc = str_replace(',', '', $numbermembers);
	$activemembers_calc = str_replace(',', '', $activemembers);
	$vbtrends_active_percentage = round($activemembers_calc / $numbermembers_calc * 100);

	$vbtrends_newmembers_bit = '';	
	while($member = $db->fetch_array($vbtrends_last_x_joins_result))
	{
	  	$newuserid = $member['userid'];
	  	$newusername = $member['username'];
  		eval('$vbtrends_newmembers_bit .= "' . fetch_template('forumhome_vbtrends_newmember_bit') . '";');
	}
	
	eval('$vbtrends_output = "' . fetch_template('forumhome_vbtrends') . '";');
	
	if ($vbulletin->options['vbtrends_autoreplace'])
	{
		$find = '<div class=\\"smallfont\\">
			<div>
				$vbphrase[threads]: $totalthreads,
				$vbphrase[posts]: $totalposts,
				$vbphrase[members]: $numbermembers".(($show[\'activemembers\']) ? (",
					<span title=\\"" . construct_phrase("$vbphrase[within_the_last_x_days]", "" . $GLOBALS[\'vbulletin\']->options[\'activememberdays\'] . "") . "\\">$vbphrase[active_members]: $activemembers</span>
				") : (""))."
			</div>
			<div>" . construct_phrase("$vbphrase[welcome_to_our_newest_member_x]", "member.php?" . $GLOBALS[\'vbulletin\']->session->vars[\'sessionurl\'] . "u=$newuserid", "$newusername") . "</div>
		</div>';

		$vbulletin->templatecache['FORUMHOME'] = str_replace($find, '$vbtrends_output', $vbulletin->templatecache['FORUMHOME']);

		($hook = vBulletinHook::fetch_hook('trends_complete')) ? eval($hook) : false;
	}
}