<?php
/*======================================================================*\
|| #################################################################### ||
|| # File Inspector 1.0
|| #################################################################### ||
\*======================================================================*/

//    
clearstatcache();

//     
function gfiGetFileInfo($filename)
{
	$filepath = DIR . '/' . $filename;
	return	file_exists($filepath) ? array(
			'filesize'	=> filesize($filepath),
			'modified'	=> filemtime($filepath),
			'owner'		=> fileowner($filepath),
			'perms'		=> substr(sprintf('%o', fileperms($filepath)), -4)
		) : false;
}

//           
function gfiGetFileList($path = '')
{
	global $vbulletin;
	$epreg	= '/\.(' . str_replace(',', '|', $vbulletin->options['gfi_extensions']) . ')$/i';
	$excld	= split("\n", str_replace("\r", '', $vbulletin->options['gfi_excludes']));
	$emask	= $vbulletin->options['gfi_preg'] ? ('/' . $vbulletin->options['gfi_preg'] . '/i') : false;
	$files	= array();
	$folder	= opendir(DIR . '/' . $path);
	while ($file = readdir($folder))
	{
		if ($file != '.' AND $file != '..')
		{
			$pathfile = $path . '/' . $file;
			if (!($emask AND preg_match($emask, $pathfile)))
			{
				if (is_dir(DIR . '/' . $pathfile))
				{
					$files = array_merge($files, gfiGetFileList($pathfile));
				}
				elseif (!in_array($pathfile, $excld) AND ($file == $vbulletin->options['gfi_htaccess'] OR preg_match($epreg, $file)) AND $fileinfo = gfiGetFileInfo($pathfile))
				{
					$files[$pathfile] = $fileinfo;
				}
			}
		}
	}
	closedir($folder);
	return $files;
}

//       
function gfiReadFileList($rev = 0)
{
	global $vbulletin;
	$files	= array();
	$fquery	= $vbulletin->db->query_read('SELECT `filename`, `filesize`, `modified`, `owner`, `perms` FROM `' . TABLE_PREFIX . 'gfi` WHERE `revision` = ' . intval($rev) . ' ORDER BY `filename`;');
	while ($file = $vbulletin->db->fetch_array($fquery))
	{
		$filename = $file['filename'];
		unset($file['filename']);
		$files[$filename] = $file;
	}
	$vbulletin->db->free_result($fquery);
	return $files;
}

//  
function gfiFileSize($filesize)
{
	$byte = 'b';
	if ($filesize > 1024) { $filesize /= 1024; $byte = 'K'; }
	if ($filesize > 1024) { $filesize /= 1024; $byte = 'M'; }
	$filesize = str_replace('.', ',', $filesize);
	if (!strpos($filesize, ',')) { $filesize .= ','; }
	return preg_replace ('/^(\d+),(\d{2})(.*)$/', '\\1,\\2', $filesize . '00') . $byte;
}

// /  
function gfiFileTime($filetime)
{
	return date('d/m/y H:i', $filetime);
}

?>