<?php
/*======================================================================*\
|| #################################################################### ||
|| # File Inspector 1.0
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);
if (!is_object($vbulletin->db))
{
	exit;
}

// ########################## REQUIRE BACK-END ############################
require_once(DIR . '/includes/functions_gfi.php');

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

//      
$filelist = gfiGetFileList();

//      
$fileindb = gfiReadFileList();

// / 
$alerts = array ('new' => array(), 'changed' => array());

// / ,     
$mailed = array ('new' => array(), 'changed' => array());
$mquery = $vbulletin->db->query_read('SELECT * FROM `' . TABLE_PREFIX . 'gfi_mail`;');
while ($mail = $vbulletin->db->fetch_array($mquery))
{
	foreach ($mailed as $key => $val)
	{
		$mailed[$key] = array_merge($val, split(PHP_EOL, $mail[$key]));
	}
}
$vbulletin->db->free_result($mquery);

//   
foreach ($filelist as $filename => $fileinfo)
{
	if (!isset($fileindb[$filename]))
	{
		if (!in_array($filename, $mailed['new']))
		{
			$alerts['new'][] = $filename;
		}
	}
	else
	{
		if (!in_array($filename, $mailed['changed']))
		{
			$alert		= false;
			$original	= $fileindb[$filename];
			foreach ($fileinfo as $key => $val)
			{
				$alert = ($alert OR ($val != $original[$key]));
				if ($alert)
				{
					break;
				}
			}
			if ($alert)
			{
				$alerts['changed'][] = $filename;
			}
		}
	}
}

//  ,   / 
$log = false;
if ($alerts['new'] OR $alerts['changed'])
{
	//  
	$admins = array();
	$aquery = $vbulletin->db->query_read('SELECT `username`, `email`, `languageid` FROM `' . TABLE_PREFIX . 'user` WHERE `userid` IN (' . $vbulletin->options['gfi_userids'] . ');');
	while ($user = $vbulletin->db->fetch_array($aquery))
	{
		if ($user['email'])
		{
			$admins[] = $user;
		}
	}
	$vbulletin->db->free_result($aquery);

	$admins_count = count($admins);
	if ($admins_count > 0)
	{
		vbmail_start();

		//     
		$newfilecount	= count($alerts['new']);
		$newfiles	= '';
		if ($newfilecount > 0)
		{
			$newfiles .= PHP_EOL;
			sort($alerts['new']);
			foreach ($alerts['new'] as $filename)
			{
				$fileinfo =& $filelist[$filename];
				$fileinfo['filesize'] = gfiFileSize($fileinfo['filesize']);
				$fileinfo['modified'] = gfiFileTime($fileinfo['modified']);
				$newfiles .= '	' . $filename . ' (' . join(', ', $fileinfo) . ')' . PHP_EOL;
			}
		}

		$changedfilecount	= count($alerts['changed']);
		$changedfiles		= '';
		if ($changedfilecount > 0)
		{
			$changedfiles .= PHP_EOL;
			sort($alerts['changed']);
			foreach ($alerts['changed'] as $filename)
			{
				$fileinfo =& $filelist[$filename];
				$fileinfo['filesize'] = gfiFileSize($fileinfo['filesize']);
				$fileinfo['modified'] = gfiFileTime($fileinfo['modified']);
				$changedfiles .= '	' . $filename . ' (' . join(', ', $fileinfo) . ')' . PHP_EOL;
			}
		}

		//   
		$log = array($newfilecount, $changedfilecount, $admins_count);

		//   
		foreach ($admins as $user)
		{
			$username = $user['username'];

			eval(fetch_email_phrases('gfi_email', $user['languageid']));

			vbmail($user['email'], $subject, $message);
		}

		vbmail_end();
	}

	//       
	$vbulletin->db->query_write('
		INSERT INTO `' . TABLE_PREFIX . 'gfi_mail` (`dateline`, `new`, `changed`) VALUES (
			UNIX_TIMESTAMP(),
			\'' . $vbulletin->db->escape_string(join(PHP_EOL, $alerts['new'])) . '\',
			\'' . $vbulletin->db->escape_string(join(PHP_EOL, $alerts['changed'])) . '\'
		);
	');
}

//  
if ($log !== false)
{
	log_cron_action(serialize($log), $nextitem, 1);
}

?>